/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import sun.plugin.panel.ActivatorSubPanel;
import sun.plugin.panel.ConfigurationInfo;
import sun.plugin.panel.MessageHandler;
import sun.plugin.usability.DialogFactory;

public class AdvancedPanel
extends ActivatorSubPanel
implements ItemListener,
KeyListener {
    private MessageHandler mh = new MessageHandler("advanced");
    private JTextField javaParms;
    private JTextField jdkPath;
    private JComboBox jdkInstalled;
    private final String otherJDK = this.mh.getMessage("other_jdk");
    private final String defaultJRE = this.mh.getMessage("default_jdk");
    private JLabel pathLabel;
    private int jreNb;
    private int jdkNb;

    AdvancedPanel(ConfigurationInfo configurationInfo) {
        super(configurationInfo);
        this.setLayout(new BoxLayout(this, 1));
        JPanel jPanel = new JPanel();
        Border border = BorderFactory.createEtchedBorder();
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4), BorderFactory.createTitledBorder(border, this.mh.getMessage("jre_name"))));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 1));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add(jPanel2);
        this.jdkInstalled = new JComboBox();
        this.jdkInstalled.setMaximumRowCount(3);
        jPanel2.add(Box.createGlue());
        if (this.setInstalledJavaList()) {
            this.jdkInstalled.addItemListener(this);
            jPanel2.add(this.jdkInstalled);
        }
        jPanel2.add(Box.createGlue());
        this.add(jPanel);
        this.add(Box.createGlue());
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(3, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(15, 8, 4, 4));
        jPanel3.add(Box.createGlue());
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.pathLabel = new JLabel(this.mh.getMessage("path"));
        jPanel4.add(this.pathLabel);
        this.jdkPath = new JTextField();
        this.jdkPath.setEnabled(false);
        jPanel4.add(this.jdkPath);
        jPanel3.add(jPanel4);
        jPanel3.add(Box.createGlue());
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jPanel3);
        this.add(Box.createGlue());
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        GridLayout gridLayout = new GridLayout(2, 1);
        jPanel5.setLayout(gridLayout);
        jPanel5.add(new JLabel(this.mh.getMessage("java_parms"), 2));
        this.javaParms = new JTextField();
        jPanel5.add(this.javaParms);
        this.javaParms.addKeyListener(this);
        this.add(jPanel5);
    }

    public void setJavaParmsText() {
        this.javaParms.setText(this.model.getJavaParms());
        this.reset();
    }

    private boolean setInstalledJavaList() {
        Object[] objectArray;
        Object object;
        if (this.jdkInstalled.getItemCount() > 0) {
            this.jdkInstalled.removeAllItems();
        }
        this.jdkInstalled.addItem(this.defaultJRE);
        String[][] stringArray = this.model.getInstalledJREList();
        this.jreNb = stringArray == null ? 0 : stringArray.length;
        int n = 0;
        while (n < this.jreNb) {
            object = stringArray[n][0];
            String string = stringArray[n][1];
            if (object != null && string != null) {
                objectArray = new Object[]{object, string};
                this.jdkInstalled.addItem(MessageFormat.format(this.mh.getMessage("jre_format"), objectArray));
            }
            ++n;
        }
        object = this.model.getInstalledJDKList();
        this.jdkNb = object == null ? 0 : ((String[][])object).length;
        int n2 = 0;
        while (n2 < this.jdkNb) {
            objectArray = object[n2][0];
            String string = object[n2][1];
            if (objectArray != null && string != null) {
                Object[] objectArray2 = new Object[]{objectArray, string};
                this.jdkInstalled.addItem(MessageFormat.format(this.mh.getMessage("jdk_format"), objectArray2));
            }
            ++n2;
        }
        this.jdkInstalled.addItem(this.otherJDK);
        return true;
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.jdkInstalled && itemEvent.getStateChange() == 1) {
            String[][] stringArray;
            int n = this.jdkInstalled.getSelectedIndex();
            if (n == 0) {
                this.model.setJavaRuntimeType("Default");
                this.model.setJavaRuntimeVersion(null);
                this.jdkPath.setText("");
            }
            if (n > 0 && n <= this.jreNb) {
                this.model.setJavaRuntimeType("JRE");
                stringArray = this.model.getInstalledJREList();
                this.model.setJavaRuntimeVersion(stringArray[n - 1][0]);
                this.jdkPath.setText("");
            }
            if (n > this.jreNb && n <= this.jreNb + this.jdkNb) {
                this.model.setJavaRuntimeType("JDK");
                stringArray = this.model.getInstalledJDKList();
                this.model.setJavaRuntimeVersion(stringArray[n - this.jreNb - 1][0]);
                this.jdkPath.setText("");
            }
            if (n == this.jdkInstalled.getItemCount() - 1 && (this.jdkPath.getText() == null || this.jdkPath.getText().length() < 1)) {
                stringArray = new Object[]{this.mh.getMessage("warning_popup_ok"), this.mh.getMessage("warning_popup_cancel")};
                int n2 = DialogFactory.showOptionDialog(this, 3, this.mh.getMessage("jre_selection_warning.info"), this.mh.getMessage("jre_selection_warning.caption"), (Object[])stringArray, stringArray[1]);
                if (n2 == 0) {
                    JFileChooser jFileChooser = new JFileChooser();
                    jFileChooser.setFileSelectionMode(2);
                    boolean bl = false;
                    while (!bl) {
                        int n3 = jFileChooser.showOpenDialog(this);
                        if (n3 == 0) {
                            if (jFileChooser.getSelectedFile().isDirectory()) {
                                this.jdkPath.setText(jFileChooser.getSelectedFile().getAbsolutePath());
                                this.model.setJavaRuntimeType(this.jdkPath.getText());
                                this.jdkInstalled.setSelectedIndex(this.jdkInstalled.getItemCount() - 1);
                                bl = true;
                                continue;
                            }
                            DialogFactory.showErrorDialog(this, this.mh.getMessage("error.text"), this.mh.getMessage("error.caption"));
                            bl = false;
                            continue;
                        }
                        this.model.setJavaRuntimeType("Default");
                        this.jdkInstalled.setSelectedIndex(0);
                        bl = true;
                    }
                } else {
                    this.model.setJavaRuntimeType("Default");
                    this.jdkInstalled.setSelectedIndex(0);
                }
            }
            this.reset();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.javaParms) {
            this.model.setJavaParms(this.javaParms.getText());
        } else if (keyEvent.getSource() == this.jdkPath) {
            this.model.setJavaRuntimeType(this.jdkPath.getText());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keyTyped(keyEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void reset() {
        block7: {
            this.javaParms.setText(this.model.getJavaParms());
            boolean bl = true;
            String string = this.model.getJavaRuntimeType();
            this.pathLabel.setEnabled(false);
            this.jdkPath.setEnabled(false);
            try {
                if (string.equalsIgnoreCase("Default")) {
                    this.jdkInstalled.setSelectedIndex(0);
                    break block7;
                }
                if (string.equalsIgnoreCase("JDK")) {
                    String[][] stringArray = this.model.getInstalledJDKList();
                    String string2 = this.model.getJavaRuntimeVersion();
                    int n = 0;
                    while (!stringArray[n][0].equalsIgnoreCase(string2)) {
                        ++n;
                    }
                    this.jdkInstalled.setSelectedIndex(this.jreNb + n + 1);
                    break block7;
                }
                if (string.equalsIgnoreCase("JRE")) {
                    String[][] stringArray = this.model.getInstalledJREList();
                    String string3 = this.model.getJavaRuntimeVersion();
                    int n = 0;
                    while (!stringArray[n][0].equalsIgnoreCase(string3)) {
                        ++n;
                    }
                    this.jdkInstalled.setSelectedIndex(n + 1);
                    break block7;
                }
                this.jdkPath.setText(string);
                this.pathLabel.setEnabled(true);
                this.jdkInstalled.setSelectedIndex(this.jdkInstalled.getItemCount() - 1);
            }
            catch (Exception exception) {
                this.jdkInstalled.setSelectedIndex(0);
                this.model.firePropertyChange();
            }
        }
    }

    public void setTextSize(int n) {
        this.jdkPath.setMaximumSize(new Dimension(n, 25));
        this.jdkPath.revalidate();
    }
}

