/***************************************************************************
                          reportview.h  -  description
                             -------------------
    begin                : Sun Oct 15 2000
    copyright            : (C) 2000 by Ian Reinhart Geiser
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef REPORTVIEW_H
#define REPORTVIEW_H

#include <qdialog.h>
#include <qstringlist.h>

class KHTMLPart;

/**This is the main report generated for the user.
  *@author Ian Reinhart Geiser
  */

class reportView : public QDialog {
    Q_OBJECT

public:
    reportView( QWidget *parent=0, const char *name=0);
    ~reportView();
    
    void render();
    void setTemp( QString temp );
    void setWind( QString wind );
    void setDate( QString date );
    void setPressure( QString pressure );
    void setCover( QStringList cover );
    void setWeather( QStringList weather );
    void setWeatherIcon( const QString &icon );

private:
    KHTMLPart *theReport;
    QString currentTemp;
    QString currentTime;
    QString currentPressure;
    QString currentWind;
    QString currentDate;
    QStringList currentCover;
    QStringList currentWeather;
    QString currentIcon;
};

#endif
