/*
 * kfortuneview.h
 *
 * Copyright (c) 2001 Frerich Raabe <raabe@kde.org>
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. For licensing and distribution details, check the
 * accompanying file 'COPYING'.
 */
#ifndef KFORTUNEVIEW_H
#define KFORTUNEVIEW_H

#include <qwidget.h>

class QGridLayout;
class QGroupBox;
class QLabel;
class QPushButton;

class KFortuneView : public QWidget
{
	Q_OBJECT

	public:
		KFortuneView(QWidget *parent);
		virtual ~KFortuneView();

		QString fortune() const;
		void setFortune(const QString &fortune);
	
	signals:
		void newFortuneClicked();
		void closeClicked();
		
	private:
		QGridLayout *m_layout;
		QGroupBox *m_groupBox;
		QLabel *m_fortune;
		QPushButton *m_bNewFortune;
		QPushButton *m_bClose;
};

#endif // KFORTUNEVIEW_H
// vim:ts=4:sw=4:noet
