/*
 *   kaphorism - weekly spreuk of Steiner.
 *   $Id: main.cpp,v 1.3 2001/10/10 20:57:10 mueller Exp $
 *   Copyright (C) 1998,2000  Hans Dijkema 
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <kapplication.h>
#include <kwin.h>
#include <kaboutdata.h>
#include <klocale.h>
#include <ksimpleconfig.h>                                                      
#include <kcmdlineargs.h>                                                      
 
#include "kaphorism.h"

static const char *description =
     I18N_NOOP("K Aphorisms\n"
               "\n"
               "A program to display aphorisms each day, week, etc.\n"
               "\n"
               "Currently the 'Antroposofischer Seelenkalender' is provided\n"
               "Other contributions are welcome."
              );

static KCmdLineOptions options[] =
{
    { 0, 0, 0 }
};

int main( int argc, char **argv)
{
    KAboutData aboutData( "kaphorism", I18N_NOOP("K Aphorisms"),
						  VERSION, description, KAboutData::License_GPL,
						  "(c) 2001, Hans Dijkema");
    aboutData.addAuthor("Hans Dijkema",0, "h.dijkema@hum.org");

    KCmdLineArgs::init( argc, argv, &aboutData );
    KCmdLineArgs::addCmdLineOptions( options );

    KApplication a;
    KSimpleConfig conf("kaphorism.rc");
    kaphorism *spreuken=new kaphorism(&conf);

    KWin::setSystemTrayWindowFor(spreuken->winId(),0);

    kapp->setTopWidget(spreuken);
    a.setMainWidget(spreuken);
    spreuken->show();
    KWin::appStarted();

    return a.exec();
}

