/*
    buglvi.cpp  -  Custom QListViewItem that holds a Bug object

    copyright   : (c) 2001 by Martijn Klingens
    email       : mklingens@yahoo.com

    *************************************************************************
    *                                                                       *
    * This program is free software; you can redistribute it and/or modify  *
    * it under the terms of the GNU General Public License as published by  *
    * the Free Software Foundation; either version 2 of the License, or     *
    * (at your option) any later version.                                   *
    *                                                                       *
    *************************************************************************
*/

#include <qfont.h>
#include <qpainter.h>

#include <kstringhandler.h>
#include <kdebug.h>

#include "bugsystem.h"

#include "buglvi.h"

using namespace KBugBusterMainWindow;

BugLVI::BugLVI( QListView *parent , const Bug &bug )
: QListViewItem( parent, bug.number() + "  ",
                 bug.title(), //KStringHandler::csqueeze( bug.title(), 70 ),
                 Bug::statusToString( bug.status() ),
                 Bug::severityToString( bug.severity() ),
                 bug.submitter().fullName() )
{
    m_bug = bug;

    bool hasCommands = BugSystem::self()->hasCommandsFor( bug );
    mCommandState = hasCommands ? BugCommand::Queued : BugCommand::None;
}

BugLVI::~BugLVI()
{
}

QString BugLVI::key ( int column, bool ) const
{
    QString key;

    if ( column == 0 ) {
        key = text( 0 ).rightJustify( 10, '0' );
    } else {
        key = text( column );
    }

    return key;
}

void BugLVI::paintCell(QPainter* p, const QColorGroup& cg,
                       int column, int width, int align)
{
    QColorGroup newCg = cg;
    if ( mCommandState == BugCommand::Queued ) {
        QFont font = p->font();
        font.setBold( true );
        p->setFont( font );
    } else if ( mCommandState == BugCommand::Sent ) {
        QFont font = p->font();
        font.setItalic( true );
        p->setFont( font );
    } else if ( m_bug.status() == Bug::Closed ) {
        // Different color for closed bugs
        newCg.setColor( QColorGroup::Text, cg.color( QColorGroup::Dark ) );
    }

    QListViewItem::paintCell(p,newCg,column,width,align);
}

void BugLVI::setCommandState( BugCommand::State state)
{
    mCommandState = state;
}

/* vim: set et ts=4 sw=4 softtabstop=4: */

