/* ****************************************************************************
  This file is part of KBabel

  Copyright (C) 1999-2001 by Matthias Kiefer
                            <matthias.kiefer@gmx.de>
		2001	  by Stanislav Visnovsky
			    <visnovsky@kde.org>

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

**************************************************************************** */
#include "catalogmanager.h"
#include "catalogmanageriface.h"
#include "catalog.h"
#include "catalogmanagerapp.h"

#include "version.h"

#include <dcopclient.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kcursor.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <kapplication.h>
#include <kwin.h>
#include <kdebug.h>
#include <kmainwindow.h>

#include <qfile.h>
#include <qtimer.h>

CatalogManager *CatalogManagerApp::_view = 0;

CatalogManagerApp::CatalogManagerApp()
    : KApplication()
{
    kbInterface = new CatalogManagerInterface;
    _view = 0;
    _preferredWindow = 0;
}

CatalogManagerApp::~CatalogManagerApp()
{
    delete kbInterface;
}

void CatalogManagerApp::setPreferredWindow(WId id)
{
    _preferredWindow = id;
    if( _view )
    {
	_view->raise();
	KWin::setActiveWindow(_view->winId());
    }
}

void CatalogManagerApp::updatedFile(QString url)
{
    if( _view )
	_view->updateFile(url);
}

QString CatalogManagerApp::findNextFile()
{
    QString reply = "";
    if( !CatalogManager::_foundFilesList.isEmpty() )
    {
	reply = CatalogManager::_foundFilesList.first();
	CatalogManager::_foundFilesList.pop_front();
	if( _view ) _view->decreaseNumberOfFound();
    } else 
    {
	if( !CatalogManager::_toBeSearched.isEmpty() )
	    reply = QString(""); // nothing found yet
	else 
	    reply = QString::null; // not found definitely
    }
    
    return reply;
}

int CatalogManagerApp::newInstance()
{
    if( isRestored() )
    {
	RESTORE( CatalogManager )
    }
    else
    {
	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();
        
	_view=new CatalogManager();

	_view->setPreferredWindow( _preferredWindow );
	_view->show();
	_view->raise();
	KWin::setActiveWindow(_view->winId());

	args->clear();
    }
    
    return 0;
}

CatalogManagerInterface::CatalogManagerInterface()
    : DCOPObject("CatalogManagerIFace")
{
}

void CatalogManagerInterface::setPreferredWindow( WId id )
{
    CatalogManagerApp::setPreferredWindow(id);
}

QString CatalogManagerInterface::findNextFile()
{
    return CatalogManagerApp::findNextFile();
}

void CatalogManagerInterface::updatedFile( QString url )
{
    CatalogManagerApp::updatedFile(url);
}

static KCmdLineOptions options[] =
{
   {0,0,0}
};


int main(int argc, char **argv)
{
    KLocale::setMainCatalogue("kbabel");
    KAboutData about("catalogmanager",I18N_NOOP("KBabel - Catalog Manager"),VERSION,
       I18N_NOOP("An advanced catalog manager for KBabel, PO-file editor"),KAboutData::License_GPL,
       "(c) 1999,2000,2001,2002 The KBabel developers",0,"http://i18n.kde.org/tools/kbabel");

    about.addAuthor("Matthias Kiefer",I18N_NOOP("Original author"),"kiefer@kde.org");
    about.addAuthor("Stanislav Visnovsky",I18N_NOOP("Current maintainer, porting to KDE3/Qt3.")
	,"visnovsky@kde.org");

    about.addCredit("Claudiu Costin",I18N_NOOP("Wrote documentation and sent "
		"many bug reports and suggestions for improvements.")
         ,"claudiuc@geocities.com");
    about.addCredit("Thomas Diehl",I18N_NOOP("Gave many hints to the gui "
         "and the behaviour of KBabel and contributed the beautiful splash screen.")
            ,"thd@kde.org");
    about.addCredit("Wolfram Diestel"
         ,I18N_NOOP("Wrote diff algorithm, fixed KSpell and gave a lot "
         "of useful hints."),"wolfram@steloj.de");
    about.addCredit("Stephan Kulow",I18N_NOOP("Helped keep KBabel up to date "
		"with the KDE API and gave a lot of other help."),"coolo@kde.org");
	about.addCredit("SuSE GmbH"
					,I18N_NOOP("Sponsors development of KBabel.")
					,"suse@suse.de","http://www.suse.de");
    about.addCredit("",
            I18N_NOOP("KBabel contains code from the following projects:\n"
            "Qt by Trolltech and GNU gettext"));

    about.setTranslator(I18N_NOOP("_: NAME OF TRANSLATORS\nYour names")
            ,I18N_NOOP("_: EMAIL OF TRANSLATORS\nYour emails"));

    // Initialize command line args
    KCmdLineArgs::init(argc, argv, &about);

    // Tell which options are supported
    KCmdLineArgs::addCmdLineOptions( options );

    // Add options from other components
    KApplication::addCmdLineOptions();

    CatalogManagerApp app;
    
    app.newInstance();

    return app.exec();
}
