/***************************************************************************
                            KWinModule.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KWINMODULE_H
#define KWINMODULE_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QObject.h>

/**


 The class KWinModule provides information about the state of the
 window manager as required by windowmanager modules. It informs a
 module about all currently managed windows and changes to them (via
 Qt signals).

 KWinModule uses NETRootInfo internally. Modules written with this
 class will work fine under any window manager that implements the
 NET_WM protocol.

 There are no methods to manipulate windows. Those are defined in
 the classes KWin, NETWinInfo and NETRootInfo.

 @author Matthias Ettrich (ettrich@kde.org)

 @version $Id: KWinModule.h,v 1.3 2002/03/15 02:12:24 rdale Exp $
 
 @short Base class for KDE Window Manager modules.

*/
@interface KWinModule : QObject 

/** 
 Creates a KWinModule object and connects to the window
 manager.

*/
- initWithObject: (QObject *)parent;
- init;

/** 
 Destructor. Internal cleanup, nothing fancy.

*/
- (void) dealloc;

/** 
 Test to see if @p WId still managed at present.

*/
- (BOOL) hasWId: (unsigned int)arg1;

/** 
 Returns the current virtual desktop.

*/
- (int) currentDesktop;

/** 
 Returns the number of virtual desktops.

*/
- (int) numberOfDesktops;

/** 
 Returns the currently active window, or 0 if no window is active.

*/
- (unsigned int) activeWindow;

/** 
 Returns the workarea for the specified desktop, or the current
 work area if no desktop has been specified.

*/
//- (QRect*) workArea: (int)area;
//- (QRect*) workArea;

/** 
 Returns the name of the specified desktop.

*/
- (NSString *) desktopName: (int)desktop;

/** 
 Sets the name of the specified desktop.

*/
- setDesktopName: (int)desktop name: (NSString *)name;

/** 
 Informs kwin via dcop to not manage a window with the
 specified @p title.

 Useful for swallowing legacy applications, for example java
 applets.

     
*/
- doNotManage: (NSString *)title;
@end

/** Override these methods in subclasses of KWinModule to customise event handling behaviour */
@protocol KWinModuleEventHandling
- childEvent:(QChildEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- timerEvent:(QTimerEvent*) arg1;
@end


#endif
