/***************************************************************************
                            KStdGuiItem.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KSTDGUIITEM_H
#define KSTDGUIITEM_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QtSupport.h>

@class KGuiItem;

@interface  KStdGuiItem : NSObject <QtSupport>
{
@private
	void * _qt;
	BOOL  _allocatedInObjcWorld;
}
+ (KGuiItem*) guiItem: (int)ui_enum;
+ (NSString *) stdItem: (int)ui_enum;
+ (KGuiItem*) ok;
+ (KGuiItem*) cancel;
+ (KGuiItem*) yes;
+ (KGuiItem*) no;
+ (KGuiItem*) discard;
+ (KGuiItem*) save;
+ (KGuiItem*) help;
+ (KGuiItem*) dontSave;
+ (KGuiItem*) saveAs;
+ (KGuiItem*) apply;
+ (KGuiItem*) clear;
+ (KGuiItem*) defaults;
+ (KGuiItem*) close;

/** 
 Return a GUI item for a 'back' action, like Konqueror's back button.
 This GUI item can optionally honour the user's setting for BiDi, so the
 icon for right-to-left languages (Hebrew and Arab) has the arrow
 pointing in the opposite direction.
 By default the arrow points in the Western 'back' direction (i.e.
 to the left). This is because usually you only want the Bidi aware
 GUI item if you also want the 'forward' item. Those two are available
 in the separate @ref -backAndForward method.
     
*/
+ (KGuiItem*) back: (int)useBidi;
+ (KGuiItem*) back;

/** 
 Return a GUI item for a 'forward' action, like Konqueror's forward
 button. This GUI item can optionally honour the user's setting for BiDi,
 so the icon for right-to-left languages (Hebrew and Arab) has the arrow
 pointing in the opposite direction.
 By default the arrow points in the Western 'forward' direction (i.e.
 to the right). This is because usually you only want the Bidi aware
 GUI item if you also want the 'back' item. Those two are available
 in the separate @ref -backAndForward method.
     
*/
+ (KGuiItem*) forward: (int)useBidi;
+ (KGuiItem*) forward;
+ (int) UseRTL;
+ (int) IgnoreRTL;
+ (int) Ok;
+ (int) Cancel;
+ (int) Yes;
+ (int) No;
+ (int) Discard;
+ (int) Save;
+ (int) DontSave;
+ (int) SaveAs;
+ (int) Apply;
+ (int) Clear;
+ (int) Help;
+ (int) Defaults;
+ (int) Close;
+ (int) Back;
+ (int) Forward;
@end

#endif
