/***************************************************************************
                            ProgressBase.java -  description
                             -------------------
    begin                : Wed Jan 30 16:02:13 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Jan 30 16:02:13 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 This class does all initialization stuff for progress,
 like connecting signals to slots.
 All slots are implemented as pure virtual methods.

 All custom IO progress dialog should inherit this class.
 Add your GUI code to the constructor and implemement those virtual
 methods which you need in order to display progress.

 E.g. {@link #StatusbarProgress} only implements {@link #slotTotalSize},
 {@link #slotPercent} and {@link #slotSpeed}.

 Custom progress dialog will be used like this :
 <pre>
 // create job
 CopyJob job = KIO.copy(...);
 // create a dialog
 MyCustomProgress customProgress;
 customProgress = new MyCustomProgress();
 // connect progress with job
 customProgress.setJob( job );
 ...
 </pre>

 There is a special method {@link #setStopOnClose} that controls the behavior of
 the dialog.

 See {@link ProgressBaseSignals} for signals emitted by ProgressBase.

 See {@link ProgressBaseEventHandling} for event handlers to override in subclasses of ProgressBase.

 @author Matej Koss <koss@miesto.sk>

 @short Base class for IO progress dialogs.

*/
public class ProgressBase extends QWidget  {
	protected ProgressBase(Class dummy){super((Class) null);}

	private native void newProgressBase( QWidget parent);
	public ProgressBase( QWidget parent) {
		super((Class) null);
		newProgressBase( parent);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	public native void setJob( Job job);
	public native void setJob( CopyJob job);
	public native void setJob( DeleteJob job);
	public native void setStopOnClose( boolean stopOnClose);
	public native boolean stopOnClose();

/** 
 This controls whether the dialog should be deleted or only cleaned when
 the KIO.Job is finished (or canceled).

 If your dialog is an embedded widget and not a separate window, you should
 setOnlyClean(true) in the constructor of your custom dialog.

 If true - Dialog will only call method {@link slotClean}.
 If false - Dialog will be deleted.
   
*/
	public native void setOnlyClean( boolean onlyClean);
	public native boolean onlyClean();

/** 
 This method should be called for correct cancelation of IO operation
 Connect this to the progress widgets buttons etc.
   
*/
	public native void slotStop();

/** 
 This method is called when the widget should be cleaned (after job is finished).
 redefine this for custom behavior.
   
*/
	public native void slotClean();
	public native void slotTotalSize( Job arg1, int arg2);
	public native void slotTotalFiles( Job arg1, long arg2);
	public native void slotTotalDirs( Job arg1, long arg2);
	public native void slotProcessedSize( Job arg1, int arg2);
	public native void slotProcessedFiles( Job arg1, long arg2);
	public native void slotProcessedDirs( Job arg1,long arg2);
	public native void slotSpeed( Job arg1,long arg2);
	public native void slotPercent( Job arg1, long arg2);
	public native void slotCopying( Job arg1, KURL arg2, KURL arg3);
	public native void slotMoving( Job arg1, KURL arg2, KURL arg3);
	public native void slotDeleting( Job arg1, KURL arg2);
	public native void slotCreatingDir( Job arg1, KURL arg2);
	public native void slotCanResume( Job arg1, int arg2);
	protected native void closeEvent( QCloseEvent arg1);
	protected native void slotFinished( Job arg1);
}
