/***************************************************************************
                            KTipDialog.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 A Tip-of-the-Day dialog.

 This dialog class presents a tip-of-the-day.

 See {@link KTipDialogSignals} for signals emitted by KTipDialog.

 See {@link KTipDialogEventHandling} for event handlers to override in subclasses of KTipDialog.

 @author Matthias Hoelzer-Kluepfel <mhk@caldera.de>
 
 @short 
 A Tip-of-the-Day dialog.
*/
public class KTipDialog extends KDialog  {
	protected KTipDialog(Class dummy){super((Class) null);}


/** 
 Shows a tip.

 This static method is all that is needed to add a tip-of-the-day
 dialog to an application. It will pop up the dialog, unless the
 user has asked that the dialog does not pop up on startup.

 Note that you probably want an item in the help menu calling
 this method with force=true.

*/
	public static native void showTip( QWidget parent, String tipFile, boolean force);
	public static native void showTip( QWidget parent);

/** 
 Shows a tip.

 This methods calls showTip() with the applications main window as parent.

   
*/
	public static native void showTip( String tipFile, boolean force);
	public static native void showTip();

/** 
 Toggles the start behaviour.

 Normally, the user can disable the display of the tip in the dialog.
 This is just a way to change this setting from outside.
   
*/
	public static native void setShowOnStart( boolean show);
	private native void newKTipDialog( KTipDatabase db, QWidget parent, String name);
	public KTipDialog( KTipDatabase db, QWidget parent, String name) {
		super((Class) null);
		newKTipDialog( db, parent, name);
	}
	private native void newKTipDialog( KTipDatabase db);
	public KTipDialog( KTipDatabase db) {
		super((Class) null);
		newKTipDialog( db);
	}
}
