/***************************************************************************
                            KLibFactory.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 If you develop a library that is to be loaded dynamically at runtime, then
 you should return a pointer to your factory. The K_EXPORT_COMPONENT_FACTORY
 macro is provided for this purpose:
 <pre>
   K_EXPORT_COMPONENT_FACTORY( libkspread, KSpreadFactory )
 </pre>

 The first macro argument is the name of your library, the second specifies the name 
 of your factory.

 In the constructor of your factory you should create an instance of {@link KInstance}
 like this:
 <pre>
     s_global = new KInstance( "kspread" );
 </pre>
 This {@link KInstance} is comparable to {@link KGlobal} used by normal applications.
 It allows you to find resource files (images, XML, sound etc.) belonging
 to the library.

 If you want to load a library, use {@link KLibLoader}. You can query {@link KLibLoader}
 directly for a pointer to the libraries factory by using the {@link KLibLoader#factory}
 function.

 The KLibFactory is used to create the components, the library has to offer.
 The factory of KSpread for example will create instances of KSpreadDoc,
 while the Konqueror factory will create KonqView widgets.
 All objects created by the factory must be derived from {@link QObject}, since {@link QObject}
 offers type safe casting.

 KLibFactory is an abstract class. Reimplement the {@link #createObject} method to give it functionality.

 @author Torben Weis <weis@kde.org>
 
 @short 
 If you develop a library that is to be loaded dynamically at runtime, then
 you should return a pointer to your factory.
*/
public class KLibFactory extends QObject  {
	protected KLibFactory(Class dummy){super((Class) null);}

	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();

/** 
 Creates a new object. The returned object has to be derived from
 the requested classname.

 It is valid behavior to create different kinds of objects
 depending on the requested <code>classname.</code> For example a koffice
 library may usually return a pointer to KoDocument.  But
 if asked for a "QWidget", it could create a wrapper widget,
 that encapsulates the Koffice specific features.

 create() automatically emits a signal {@link objectCreated} to tell
 the library about its newly created object.  This is very
 important for reference counting, and allows unloading the
 library automatically once all its objects have been destroyed.
     
*/
	public native QObject create( QObject parent, String name, String classname, String[] args);
	public native QObject create();
}
