package org.kde.koala;
import org.kde.qt.*;


/** {@link KEdit} emits these signals */
public interface KEditSignals {
	void currentVerticalAlignmentChanged( int a );
	void destroyed( QObject obj );
	void returnPressed();
	void contentsMoving( int x, int y );
	void currentFontChanged( QFont f );
	void currentColorChanged( QColor c );
	void undoAvailable( boolean yes );

/**  This signal is emitted if the user dropped a URL over the text editor
 {@link QMultiLineEdit} widget.

  Note that the user can drop also Text on it, but
 this is already handled internally by QMultiLineEdit.
      
*/
	void gotUrlDrop( QDropEvent e );
	void currentAlignmentChanged( int a );
	void copyAvailable( boolean arg1 );

/**  This signal is emitted whenever the cursor position changes.

 Use this in conjunction with {@link KEdit#currentLine}, {@link KEdit#currentColumn}
 if you need to know the cursor position.
     
*/
	void CursorPositionChanged();
	void cursorPositionChanged( int para, int pos );

/** 
 This signal is emitted if the user toggles from insert to overwrite mode
 or vice versa.

 The user can do so by pressing the "Insert" button on a PC keyboard.

 This feature must be activated by calling {@link KEdit#setOverwriteEnabled}
 first.
     
*/
	void toggle_overwrite_signal();
	void modificationChanged( boolean m );
	void selectionChanged();
	void redoAvailable( boolean yes );
	void textChanged();
}

