/***************************************************************************
                            KAccel.java -  description
                             -------------------
    begin                : Sun Jan 27 16:22:17 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd.
    email                : Richard_Dale@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Jan 27 16:22:17 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
***************************************************************************/

package org.kde.koala;

import org.kde.qt.*;
import java.util.*;
import java.lang.Error;

/**

 Handle shortcuts.

 Allow a user to configure shortcuts
 through application configuration files or through the
 {@link KKeyChooser} GUI.

 A {@link KAccel} contains a list of {@link KAccelAction} objects.

 For example, CTRL+Key_P could be a shortcut for printing a document. The key
 codes are listed in qnamespace.h. "Print" could be the action name for printing.
 The action name identifies the shortcut in configuration files and the
 {@link KKeyChooser} GUI.

 A KAccel object handles key events sent to its parent widget and to all
 children of this parent widget.  The most recently created KAccel object
 has precedence over any KAccel objects created before it.
 When a shortcut pressed, KAccel calls the slot to which it has been
 connected.

 Reconfiguration of a given shortcut can be prevented by specifying
 that an accelerator item is not configurable when it is inserted. A special
 group of non-configurable key bindings are known as the
 standard accelerators.

 The standard accelerators appear repeatedly in applications for
 standard document actions such as printing and saving. A convenience method is
 available to insert and connect these accelerators which are configurable on
 a desktop-wide basis.

 It is possible for a user to choose to have no key associated with
 an action.

 The translated first argument for {@link #insertItem} is used only
 in the configuration dialog.
<pre>
 KAccel pAccel = new KAccel( this );

 // Insert an action "Scroll Up" which is associated with the "Up" key:
 pAccel.insert( "Scroll Up", i18n("Scroll up"),
                       i18n("Scroll up the current document by one line."),
                       Qt.Key_Up, this, SLOT("slotScrollUp()") );
 // Insert an standard acclerator action.
 pAccel.insert( KStdAccel.Print, this, SLOT("slotPrint()") );

 // Update the shortcuts by read any user-defined settings from the
 //  application's config file.
 pAccel.readSettings();
</pre>

 See {@link KAccelSignals} for signals emitted by KAccel.

 See {@link KAccelEventHandling} for event handlers to override in subclasses of KAccel.

 @version $Id: KAccel.java,v 1.7 2002/01/31 04:48:54 rdale Exp $
 
 @short Configurable shortcut support.

*/
public class KAccel extends QAccel  {
	protected KAccel(Class dummy){super((Class) null);}

	private native void newKAccel( QWidget pParent, String psName);
	public KAccel( QWidget pParent, String psName) {
		super((Class) null);
		newKAccel( pParent, psName);
	}
	private native void newKAccel( QWidget pParent);
	public KAccel( QWidget pParent) {
		super((Class) null);
		newKAccel( pParent);
	}
	private native void newKAccel( QWidget watch, QObject parent, String psName);
	public KAccel( QWidget watch, QObject parent, String psName) {
		super((Class) null);
		newKAccel( watch, parent, psName);
	}
	private native void newKAccel( QWidget watch, QObject parent);
	public KAccel( QWidget watch, QObject parent) {
		super((Class) null);
		newKAccel( watch, parent);
	}
	protected native void finalize() throws InternalError;
	public native void dispose();
	public native boolean isDisposed();
	public native KAccelActions actions();
//	public native KAccelActions actions();
	public native boolean isEnabled();
	public native void setEnabled( boolean bEnabled);
	public native boolean getAutoUpdate();
	public native boolean setAutoUpdate( boolean bAuto);

/** 
 Create an accelerator action.

 Usage:
<pre>
 insert( "Do Something", i18n("Do Something"),
   i18n("This action allows you to do something really great with this program to "
        "the currently open document."),
   ALT+Key_D, this, SLOT("slotDoSomething()") );
</pre>

*/
	public native KAccelAction insert( String sAction, String sLabel, String sWhatsThis, KShortcut cutDef, QObject pObjSlot, String psMethodSlot, boolean bConfigurable, boolean bEnabled);
	public native KAccelAction insert( String sAction, String sLabel, String sWhatsThis, KShortcut cutDef, QObject pObjSlot, String psMethodSlot);

/** 
 Same as first insert(), but with separate shortcuts defined for
 3- and 4- modifier defaults.
	 
*/
	public native KAccelAction insert( String sAction, String sLabel, String sWhatsThis, KShortcut cutDef3, KShortcut cutDef4, QObject pObjSlot, String psMethodSlot, boolean bConfigurable, boolean bEnabled);
	public native KAccelAction insert( String sAction, String sLabel, String sWhatsThis, KShortcut cutDef3, KShortcut cutDef4, QObject pObjSlot, String psMethodSlot);

/** 
 This is an overloaded function provided for convenience.
 The advantage of this is when you want to use the same text for the name
 of the action as for the user-visible label.

 Usage: insert( I18N_NOOP("Do Something"), ALT+Key_D, this, SLOT("slotDoSomething()") );

*/
	public native KAccelAction insert( String psAction, KShortcut cutDef, QObject pObjSlot, String psMethodSlot, boolean bConfigurable, boolean bEnabled);
	public native KAccelAction insert( String psAction, KShortcut cutDef, QObject pObjSlot, String psMethodSlot);

/** 
 Similar to the first insert() method, but with the action
 name, short description, help text, and default shortcuts all
 set according to one of the standard accelerators.

*/
	public native KAccelAction insert( int identifier, QObject pObjSlot, String psMethodSlot, boolean bConfigurable, boolean bEnabled);
	public native KAccelAction insert( int identifier, QObject pObjSlot, String psMethodSlot);

/** 
 Use this to insert a label into the action list.  This will be
 displayed when the user configures shortcuts.
	 
*/
	public native KAccelAction insert( String sName, String sLabel);
	public native boolean remove( String sAction);
	public native boolean updateConnections();

/**  Return the shortcut associated with the action named by <code>sAction.</code> 
*/
	public native KShortcut shortcut( String sAction);

/**  Set the shortcut to be associated with the action named by <code>sAction.</code> 
*/
	public native boolean setShortcut( String sAction, KShortcut arg1);

/**  Set the slot to be called when the shortcut of the action named
 by <code>sAction</code> is pressed. 
*/
	public native boolean setSlot( String sAction, QObject pObjSlot, String psMethodSlot);

/**  Enable or disable the action named by <code>sAction.</code> 
*/
	public native boolean setEnabled( String sAction, boolean bEnabled);

/** 
 Read all shortcuts from <code>pConfig</code>, or (if <code>pConfig</code>
 is zero) from the application's configuration file
 {@link KGlobal#config}.

 The group in which the configuration is stored can be
 set with {@link #setConfigGroup}.
	 
*/
	public native boolean readSettings( KConfigBase pConfig);
	public native boolean readSettings();

/** 
 Write the current shortcuts to <code>pConfig</code>,
 or (if <code>pConfig</code> is zero) to the application's
 configuration file.
	 
*/
	public native boolean writeSettings( KConfigBase pConfig);
	public native boolean writeSettings();
	public native void setConfigGroup( String arg1);
	public native void emitKeycodeChanged();
	public native boolean insertItem( String sLabel, String sAction, String psKey, int nIDMenu, QPopupMenu pMenu, boolean bConfigurable);
	public native boolean insertItem( String sLabel, String sAction, String psKey);
	public native boolean insertItem( String sLabel, String sAction, int key, int nIDMenu, QPopupMenu pMenu, boolean bConfigurable);
	public native boolean insertItem( String sLabel, String sAction, int key);
	public native boolean insertStdItem( int identifier, String descr);
	public native boolean insertStdItem( int identifier);
	public native boolean connectItem( String sAction, QObject pObjSlot, String psMethodSlot, boolean bActivate);
	public native boolean connectItem( String sAction, QObject pObjSlot, String psMethodSlot);
	public native boolean connectItem( int accel, QObject pObjSlot, String psMethodSlot);
	public native boolean removeItem( String sAction);
	public native boolean setItemEnabled( String sAction, boolean bEnable);
	public native void changeMenuAccel( QPopupMenu menu, int identifier, String action);
	public native void changeMenuAccel( QPopupMenu menu, int identifier, int accel);

/** 
 @depricated.  Use shortcut().
 Retrieve the key code of the accelerator item with the action name
 <code>action</code>, or zero if either the action name cannot be
 found or the current key is set to no key.
	 
*/
	public native int currentKey( String action);

/** 
 @depricated.  Use actions().actionPtr().
 Return the name of the accelerator item with the keycode <code>key</code>,
 or {@link String#null} if the item cannot be found.
	 
*/
	public native String findKey( int key);
//	public static native int stringToKey( String arg1);
}
