/***************************************************************************
                            kde_ReadOnlyPart.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_READONLYPART
#define KDE_READONLYPART

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 Base class for any "viewer" part.

 This class takes care of network transparency for you,
 in the simplest way (synchronously).
 To use the built-in network transparency, you only need to implement
 @ref openFile(), not @ref openURL().
 To prevent network transparency, or to implement it another way
 (e.g. asynchronously), override openURL().

 KParts Application can use the signals to show feedback while the URL is being loaded.

 ReadOnlyPart handles the window caption by setting it to the current URL
 (set in @ref #openURL(), and each time the part is activated).
 If you want another caption, set it in @ref openFile() and
 (if the part might ever be used with a part manager) in @ref guiActivateEvent()
 
 @short 
 Base class for any "viewer" part.
*/

/** 
 Destructor
   
*/
void kde_del_ReadOnlyPart( kde_ReadOnlyPart* p );

/** 
 Call this to turn off the progress info dialog used by
 the internal KIO job. Use this if you provide another way
 of displaying progress info (e.g. a statusbar), using the
 signals emitted by this class, and/or those emitted by
 the Job given by @ref started.
   
*/
void kde_ReadOnlyPart_showProgressInfo(kde_ReadOnlyPart* instPointer,int show);

/** 
  Returns the currently in part used URL.

*/
kde_KURL* kde_ReadOnlyPart_url(kde_ReadOnlyPart* instPointer);

/** 
 Called when closing the current url (e.g. document), for instance
 when switching to another url (note that @ref #openURL() calls it
 automatically in this case).
 If the current URL is not fully loaded yet, aborts loading.
 Deletes the temporary file used when the url is remote.

*/
int kde_ReadOnlyPart_closeURL(kde_ReadOnlyPart* instPointer);

/** 
 Only reimplement openURL if you don't want synchronous network transparency
 Otherwise, reimplement @ref openFile() only .

 If you reimplement it, don't forget to set the caption, usually with
 emit setWindowCaption( url.prettyURL() );
   
*/
int kde_ReadOnlyPart_openURL(kde_ReadOnlyPart* instPointer,kde_KURL* url);

#endif
