/***************************************************************************
                            kde_MidiOut.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_MIDIOUT
#define KDE_MIDIOUT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 External MIDI port output class . This class is used to send midi
 events to external midi devices.

 MidiOut is inherited by other MIDI devices classes
 (like @ref SynthOut or @ref FMOut) to support a common API.

 In general, you don't want to use MidiOut directly, but within a
 @ref DeviceManager object, which is the preferred way to generate music.

 If you want to add support for other devices (I don't think
 there are any) you just have to create a class that inherits from MidiOut
 and create one object of your new class in
 @ref DeviceManager::initManager().

 @author Antonio Larrosa Jimenez <larrosa@kde.org>
 
 @version 0.9.5 17/01/2000

 @short Sends MIDI events to external MIDI devices.
*/

/** 
 Constructor. After constructing a MidiOut device, you must open it
 (using @ref #openDev() ). Additionally you may want to initialize it
 (with @ref #initDev() ),
   
*/
kde_MidiOut * kde_new_MidiOut(int d);

/** 
 Destructor. It doesn't matter if you close the device (@ref closeDev() )
 before you destruct the object because in other case, it will be closed
 here.
   
*/
void kde_del_MidiOut( kde_MidiOut* p );

/** 
 Opens the device. This is generally called from @ref DeviceManager , so you
 shouldn't call this yourself (except if you created the MidiOut object
 yourself.

*/
void kde_MidiOut_openDev(kde_MidiOut* instPointer,int sqfd);

/** 
 Closes the device. It basically tells the device (the file descriptor)
 is going to be closed.

*/
void kde_MidiOut_closeDev(kde_MidiOut* instPointer);

/** 
 Initializes the device sending generic standard midi events and controllers,
 such as changing the patches of each channel to an Acoustic Piano (000),
 setting the volume to a normal value, etc.
   
*/
void kde_MidiOut_initDev(kde_MidiOut* instPointer);

/** 

 which are defined in midispec.h

*/
int kde_MidiOut_deviceType(kde_MidiOut* instPointer);

/** 
 Returns the name and type of this MIDI device.

*/
char* kde_MidiOut_deviceName(kde_MidiOut* instPointer);

/** 
 Sets a @ref MidiMapper object to be used to modify the midi events before
 sending them.

*/
void kde_MidiOut_setMidiMapper(kde_MidiOut* instPointer,kde_MidiMapper* map);

/** 
 See @ref DeviceManager::noteOn()
   
*/
void kde_MidiOut_noteOn(kde_MidiOut* instPointer,unsigned char chn, unsigned char note, unsigned char vel);

/** 
 See @ref DeviceManager::noteOff()
   
*/
void kde_MidiOut_noteOff(kde_MidiOut* instPointer,unsigned char chn, unsigned char note, unsigned char vel);

/** 
 See @ref DeviceManager::keyPressure()
   
*/
void kde_MidiOut_keyPressure(kde_MidiOut* instPointer,unsigned char chn, unsigned char note, unsigned char vel);

/** 
 See @ref DeviceManager::chnPatchChange()
   
*/
void kde_MidiOut_chnPatchChange(kde_MidiOut* instPointer,unsigned char chn, unsigned char patch);

/** 
 See @ref DeviceManager::chnPressure()
   
*/
void kde_MidiOut_chnPressure(kde_MidiOut* instPointer,unsigned char chn, unsigned char vel);

/** 
 See @ref DeviceManager::chnPitchBender()
   
*/
void kde_MidiOut_chnPitchBender(kde_MidiOut* instPointer,unsigned char chn, unsigned char lsb, unsigned char msb);

/** 
 See @ref DeviceManager::chnController()
   
*/
void kde_MidiOut_chnController(kde_MidiOut* instPointer,unsigned char chn, unsigned char ctl, unsigned char v);

/** 
 See @ref DeviceManager::sysex()
   
*/
void kde_MidiOut_sysex(kde_MidiOut* instPointer,unsigned char* data, unsigned long size);

/** 
 Send a All Notes Off event to every channel
   
*/
void kde_MidiOut_allNotesOff(kde_MidiOut* instPointer);

/** 
 Mutes all notes being played on a given channel.
   
*/
void kde_MidiOut_channelSilence(kde_MidiOut* instPointer,unsigned char chn);

/** 
 Mute or "unmute" a given channel .

*/
void kde_MidiOut_channelMute(kde_MidiOut* instPointer,unsigned char chn, int a);

/** 
 Change all channel volume events multiplying it by this percentage correction
 Instead of forcing a channel to a fixed volume, this method allows to
 music to fade out even when it was being played softly.

*/
void kde_MidiOut_setVolumePercentage(kde_MidiOut* instPointer,int volper);

/** 
 Returns true if everything's ok and false if there has been any problem
   
*/
int kde_MidiOut_ok(kde_MidiOut* instPointer);

/** 
 Returns the path to the file where the current used @ref MidiMapper object
 reads the configuration from, or an empty string if there's no MidiMapper.
   
*/
char* kde_MidiOut_midiMapFilename(kde_MidiOut* instPointer);

/** 
 Sends the buffer to the device and returns when it's played, so you can
 synchronize
 XXX: sync should be virtual after next bic release
   
*/
void kde_MidiOut_sync(kde_MidiOut* instPointer,int i);
void kde_MidiOut_seqbuf_dump(kde_MidiOut* instPointer);
void kde_MidiOut_seqbuf_clean(kde_MidiOut* instPointer);

#endif
