/***************************************************************************
                            kde_DCOPRef.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_DCOPREF
#define KDE_DCOPREF

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 If you want to return a reference to another DCOP
 object in a DCOP interface, then you have to return
 a DCOPRef object.

 @author Torben Weis <weis@kde.org>
 
 @short 
 If you want to return a reference to another DCOP
 object in a DCOP interface, then you have to return
 a DCOPRef object.
*/

/** 
 Creates a null reference.
     
*/
kde_DCOPRef * kde_new_DCOPRef();

/** 
 Copy constructor.
     
*/
kde_DCOPRef * kde_new_DCOPRef1(kde_DCOPRef* ref);

/** 
 Creates a reference to a certain object in a
 certain application.

*/
kde_DCOPRef * kde_new_DCOPRef2(qt_QCString* app, qt_QCString* obj);

/** 
 Creates a reference to a certain object in a
 certain application.

*/
kde_DCOPRef * kde_new_DCOPRef3(kde_DCOPObject* object);

/** 
 Creates a reference to a certain object in a
 certain application.

*/
kde_DCOPRef * kde_new_DCOPRef4(qt_QCString* app, qt_QCString* obj, qt_QCString* type);

/** 
 Tests wether it is a null reference.
     
*/
int kde_DCOPRef_isNull(kde_DCOPRef* instPointer);

/** 
 Name of the application in which the object resides.
     
*/
qt_QCString* kde_DCOPRef_app(kde_DCOPRef* instPointer);

/** 
 Object ID of the referenced object.
     
*/
qt_QCString* kde_DCOPRef_object(kde_DCOPRef* instPointer);

/** 
 type of the referenced object. May be null (i.e. unknown).
     
*/
qt_QCString* kde_DCOPRef_type(kde_DCOPRef* instPointer);

/** 
 Changes the referenced object. Resets the type to unknown (null).
     
*/
void kde_DCOPRef_setRef(kde_DCOPRef* instPointer,qt_QCString* app, qt_QCString* obj);

/** 
 Changes the referenced object
     
*/
void kde_DCOPRef_setRef1(kde_DCOPRef* instPointer,qt_QCString* app, qt_QCString* obj, qt_QCString* type);

/** 
 Makes this a null reference.
     
*/
void kde_DCOPRef_clear(kde_DCOPRef* instPointer);

#endif
