/*
 * keylargo.h: definitions for using the "KeyLargo" I/O controller chip.
 *
 */

/* offset from base for feature control registers */
#define KEYLARGO_MBCR		0x34	/* Media bay control/status */
#define KEYLARGO_FCR0		0x38
#define KEYLARGO_FCR1		0x3c
#define KEYLARGO_FCR2		0x40
#define KEYLARGO_FCR3		0x44
#define KEYLARGO_FCR4		0x48

/* GPIO registers */
#define KEYLARGO_GPIO_LEVELS0		0x50
#define KEYLARGO_GPIO_LEVELS1		0x54
#define KEYLARGO_GPIO_EXTINT_0		0x58
#define KEYLARGO_GPIO_EXTINT_CNT	18
#define KEYLARGO_GPIO_0			0x6A
#define KEYLARGO_GPIO_CNT		17

/* Specific GPIO regs */

#define KL_GPIO_ETH_PHY_RESET		(KEYLARGO_GPIO_0+0x10)
#define KL_GPIO_ETH_PHY_RESET_ASSERT	0x04
#define KL_GPIO_ETH_PHY_RESET_RELEASE	0x05
#define KL_GPIO_ETH_PHY_RESET_TRISTATE	0x00

#define KL_GPIO_EXTINT_CPU1		(KEYLARGO_GPIO_0+0x0a)
#define KL_GPIO_EXTINT_CPU1_ASSERT	0x04
#define KL_GPIO_EXTINT_CPU1_RELEASE	0x38

#define KL_GPIO_RESET_CPU0		(KEYLARGO_GPIO_EXTINT_0+0x03)
#define KL_GPIO_RESET_CPU1		(KEYLARGO_GPIO_EXTINT_0+0x04)
#define KL_GPIO_RESET_CPU2		(KEYLARGO_GPIO_EXTINT_0+0x0f)
#define KL_GPIO_RESET_CPU3		(KEYLARGO_GPIO_EXTINT_0+0x10)
#define KL_GPIO_RESET_CPU_ASSERT	0x04
#define KL_GPIO_RESET_CPU_RELEASE	0x05

#define KL_GPIO_PMU_MESSAGE_IRQ		(KEYLARGO_GPIO_EXTINT_0+0x09)
#define KL_GPIO_PMU_MESSAGE_BIT		0x02

/*
 * Bits in feature control register
 */
#define KL_MBCR_MBDEV_ENABLE		0x00001000

#define KL0_SCC_B_INTF_ENABLE		0x00000001	/* ??? */
#define KL0_SCC_A_INTF_ENABLE		0x00000002	/* ??? */
#define KL0_SCC_SLOWPCLK		0x00000004
#define KL0_SCC_RESET			0x00000008
#define KL0_SCCA_ENABLE			0x00000010
#define KL0_SCCB_ENABLE			0x00000020
#define KL0_SCC_CELL_ENABLE		0x00000040
#define KL0_IRDA_ENABLE			0x00008000
#define KL0_IRDA_CLK32_ENABLE		0x00010000
#define KL0_IRDA_CLK19_ENABLE		0x00020000
#define KL0_USB0_PAD_SUSPEND0		0x00040000
#define KL0_USB0_PAD_SUSPEND1		0x00080000
#define KL0_USB0_CELL_ENABLE		0x00100000
#define KL0_USB1_PAD_SUSPEND0		0x00400000
#define KL0_USB1_PAD_SUSPEND1		0x00800000
#define KL0_USB1_CELL_ENABLE		0x01000000
#define KL0_USB_REF_SUSPEND		0x10000000

#define KL0_SERIAL_ENABLE		(KL0_SCC_B_INTF_ENABLE | \
					KL0_SCC_SLOWPCLK | \
					KL0_SCC_CELL_ENABLE | KL0_SCCA_ENABLE)

#define KL1_AUDIO_SEL_22MCLK		0x00000002
#define KL1_AUDIO_CLK_ENABLE_BIT	0x00000008
#define KL1_AUDIO_CLK_OUT_ENABLE	0x00000020	/* Burgundy only ? */
#define KL1_AUDIO_CELL_ENABLE		0x00000040
#define KL1_AUDIO_CHOOSE		0x00000080	/* Burgundy only ? */
#define KL1_I2S0_CELL_ENABLE		0x00000400
#define KL1_I2S0_CLK_ENABLE_BIT		0x00001000
#define KL1_I2S0_ENABLE			0x00002000
#define KL1_I2S1_CELL_ENABLE		0x00020000
#define KL1_I2S1_CLK_ENABLE_BIT		0x00080000
#define KL1_I2S1_ENABLE			0x00100000
#define KL1_EIDE0_ENABLE		0x00800000
#define KL1_EIDE0_RESET_N		0x01000000
#define KL1_EIDE1_ENABLE		0x04000000
#define KL1_EIDE1_RESET_N		0x08000000
#define KL1_UIDE_ENABLE			0x20000000
#define KL1_UIDE_RESET_N		0x40000000

#define KL2_IOBUS_ENABLE		0x00000002
#define KL2_SLEEP_STATE_BIT		0x00000100
#define KL2_MPIC_ENABLE			0x00020000
#define KL2_MODEM_POWER_N		0x02000000
#define KL2_AIRPORT_RESET_N		0x08000000	/* Or power ? */

#define KL3_SHUTDOWN_PLL_TOTAL		0x00000001
#define KL3_SHUTDOWN_PLLKW6		0x00000002
#define KL3_SHUTDOWN_PLLKW4		0x00000004
#define KL3_SHUTDOWN_PLLKW35		0x00000008
#define KL3_SHUTDOWN_PLLKW12		0x00000010
#define KL3_PLL_RESET			0x00000020
#define KL3_SHUTDOWN_PLL2X		0x00000080
#define KL3_CLK66_ENABLE		0x00000100
#define KL3_CLK49_ENABLE		0x00000200
#define KL3_CLK45_ENABLE		0x00000400
#define KL3_CLK31_ENABLE		0x00000800
#define KL3_TIMER_CLK18_ENABLE		0x00001000
#define KL3_I2S1_CLK18_ENABLE		0x00002000
#define KL3_I2S0_CLK18_ENABLE		0x00004000
#define KL3_VIA_CLK16_ENABLE		0x00008000
#define KL3_STOPPING33_ENABLED		0x00080000

/* Port 0,1 : bus 0, port 2,3 : bus 1 */
#define KL4_SET_PORT_ENABLE(p)		(0x00000008 << ((p)<<3))
#define KL4_SET_PORT_RESUME(p)		(0x00000004 << ((p)<<3))
#define KL4_SET_PORT_CONNECT(p)		(0x00000002 << ((p)<<3))
#define KL4_SET_PORT_DISCONNECT(p)	(0x00000001 << ((p)<<3))
#define KL4_GET_PORT_RESUME(p)		(0x00000040 << ((p)<<3))
#define KL4_GET_PORT_CONNECT(p)		(0x00000020 << ((p)<<3))
#define KL4_GET_PORT_DISCONNECT(p)	(0x00000010 << ((p)<<3))

