.\"
.\" Copyright (c) Mark J. Kilgard, 1998.
.\"
.TH glutJoystickFunc 3GLUT "3.7" "GLUT" "GLUT"
.SH NAME
glutJoystickFunc - sets the joystick callback for the current window. 
.SH SYNTAX
.nf
.LP
void glutJoystickFunc(void (*func)(unsigned int buttonMask,
                     int x, int y, int z), int pollInterval);
.fi
.SH ARGUMENTS
.IP \fIfunc\fP 1i
The new joystick callback function. 
.IP \fIpollInterval\fP 1i
Joystick polling interval in milliseconds.
.SH DESCRIPTION
glutJoystickFunc sets the joystick callback for the current window. 

The joystick callback is called either due to polling of the joystick
at the uniform timer interval specified by pollInterval (in milliseconds) or 
in response to calling glutForceJoystickFunc.  If the pollInterval is
non-positive, no joystick polling is performed and the GLUT application
must frequently (usually from an idle callback) call glutForceJoystickFunc.

The joystick buttons are reported by the callback's buttonMask parameter.
The constants GLUT_JOYSTICK_BUTTON_A (0x1), GLUT_JOYSTICK_BUTTON_B (0x2),
GLUT_JOYSTICK_BUTTON_C (0x4), and GLUT_JOYSTICK_BUTTON_D (0x8) are provided
for programming convience.

The x, y, and z callback parameters report the X, Y, and Z axes of the
joystick.  The joystick is centered at (0,0,0).  X, Y, and Z are
scaled to range between -1000 and 1000.  Moving the joystick left reports
negative X; right reports positive X.  Pulling the stick towards
you reports negative Y; push the stick away from you reports positive Y.
If the joystick has a third axis (rudder or up/down), down reports
negative Z; up reports positive Z.

Passing a NULL func to glutJoystickFunc
disables the generation of joystick callbacks.  Without a joystick
callback registered, glutForceJoystickFunc does nothing.

When a new window is created, no joystick callback is
initially registered.
.SH LIMITATIONS
The GLUT joystick callback only reports the first 3 axes and 32 buttons.
GLUT supports only a single joystick.
.SH GLUT IMPLEMENTATION NOTES FOR X11
The GLUT 3.7 implementation of GLUT for X11 supports the joystick API, but
not joystick input.  A future implementation of GLUT for X11 may
add joystick support.
.SH GLUT IMPLEMENTATION NOTES FOR WIN32
The GLUT 3.7 implementation of GLUT for Win32 supports the joystick API
and joystick input, but does so through the dated joySetCapture and
joyGetPosEx Win32 Multimedia API.  The GLUT 3.7 joystick support for
Win32 has all the limitations of the Win32 Multimedia API joystick support.
A future implementation of GLUT for Win32 may use DirectInput.
.SH SEE ALSO
glutForceJoystickFunc, glutMotionFunc, glutMouseFunc, glutSpaceballButtonFunc, glutSpaceballMotionFunc, glutButtonBoxFunc, glutTabletButtonFunc, glutDeviceGet
.SH AUTHOR
Mark J. Kilgard (mjk@nvidia.com)
