/*
 *   Copyright 1995 Peter Scott  (OZ2ABA/OZ7SAT)
 *              All Rights Reserved
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 1, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*
	filelist.c

	List the contents of the download file
*/

#define VERSION_STRING "(version 1.0 by oz2aba)"

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <netinet/in.h>

#include <fcntl.h>
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <signal.h>
#include <ctype.h>
#include <time.h>
#include <strings.h>

#include "pb.h"


/* Download files control structures */
unsigned long download_list [MAXDOWNLOAD];


int main(int argc, char **argv)
{
	FILE		*fp;
	int		x;


	/* Read the download.req file and check if the wanted file exist */
	fp = fopen ("download.req", "r+");
	if (fp == NULL) {		/* No download file. Abort */
		printf ("download.req control file does not exist\n");
		exit (1);
	}

	fread (download_list, sizeof (unsigned long), MAXDOWNLOAD, fp);
	if (ferror (fp)) {			/* Error reading. Abort */
		printf ("Error reading download.req\n");
		exit (1);
	}
	fclose (fp);

	/* Check if the requested file exist in the list */
	for (x = 0; x < MAXDOWNLOAD; x++) {
		if (download_list [x] != 0xFFFFFFFF) {
			printf ("%lx ", download_list [x]);
		}
	}
	printf ("\n");
	exit (0);
}
