/*****************************************************************************/

/*
 *      stpoutput.h  --  Output STP data.
 *
 *      Copyright (C) 2000
 *        Thomas Sailer (sailer@ife.ee.ethz.ch)
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

/*****************************************************************************/

#ifndef _STPOUTPUT_H
#define _STPOUTPUT_H

/* ---------------------------------------------------------------------- */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "modem.h"

/* ---------------------------------------------------------------------- */

extern struct modemparams stpparams[];
extern struct modemparams stpconnparams[];

extern void stpoutput_init(void);
extern void stpoutput_flushconfig(void);
extern void stpoutput_newconfig(const char *params[]);
extern void stpoutput_newconnconfig(const char *params[]);
extern void stpoutput_flushconnections(void);
extern void stpoutput_packet(const unsigned char *pkt);


/* ---------------------------------------------------------------------- */
#endif /* _STPOUTPUT_H */
