/*
 *   Copyright (C) 1991-2000 by Jonathan Naylor HB9DRD/G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <unistd.h>
#include <time.h>

#include <sys/stat.h>

#include <gtk/gtk.h>

#include "global.h"

static struct {
	char *File_Name;
	char *Description;
} Help_File_List[] = {
	{"main.help",		"Help for the main tracking screen"},
	{"satlist.help",	"Help for the satellite selection screen"},
	{"satedit.help",	"Help for the satellite addition/modification screen"},
	{"dxlist.help",		"Help for the locations selection screen"},
	{"dxedit.help",		"Help for the locations addition/modification screen"},
	{"preferences.help",	"Help for the user preferences modification screen"},
	{"listask.help",	"Help for the tabular tracking values screen"},
	{"elements.help",	"Help for the updated elements screen"},
	{"visibility.help",	"Help for the locations visibility screen"},
	{"list.help",		"Help for the tabular tracking screen"},
	{"import.help",		"Help for the satellite importing file screen"},
	{"index.help",		"Help for the help index screen"}
};

static char About_Text[] = "mtrack v0.2.3\n"
	"A GTK based Satellite Tracking Program\n"
	"24th November 2000\n"
	"Written by Jonathan Naylor  HB9DRD/G4KLX\n"
	"<g4klx@g4klx.demon.co.uk>";

static void SelectCb(GtkWidget *, gint, gint, GdkEventButton *, gpointer);
static void IndexCb(GtkWidget *, gpointer);
static void Help_Index(void);
static void Display_Help(int);

static int Help_Position = 1;

static void SelectCb(GtkWidget *w, gint row, gint column, GdkEventButton *event, gpointer data)
{
	Help_Position = row + 1;
}

static void IndexCb(GtkWidget *w, gpointer data)
{
	Display_Help(Help_Position);
}

void HelpCb(GtkWidget *w, gpointer data)
{
	int n = (int)data;

	if (n == 0)
		Help_Index();
	else
		Display_Help(n);
}

static void Help_Index(void)
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *listlist, *listwin;
	GtkWidget *separator;
	GtkWidget *bbox;
	GtkWidget *button[3];
	char *title[2];
	int Count = sizeof(Help_File_List) / sizeof(Help_File_List[0]);
	int i;

	Help_Position = 1;

	window = gtk_window_new(GTK_WINDOW_DIALOG);

	gtk_window_set_title(GTK_WINDOW(window), "Mtrack Help Contents and Index");
	gtk_container_set_border_width(GTK_CONTAINER(window), BORDER_WIDTH);

	vbox = gtk_vbox_new(FALSE, BORDER_WIDTH);
	gtk_container_add(GTK_CONTAINER(window), vbox);

	title[0] = "Contents";
	title[1] = NULL;
	listlist = gtk_clist_new_with_titles(1, (gchar **)title);
	gtk_widget_set_usize(listlist, HELP_LIST_WIDTH, HELP_LIST_HEIGHT);
	gtk_clist_column_titles_passive(GTK_CLIST(listlist));
	gtk_clist_set_selection_mode(GTK_CLIST(listlist), GTK_SELECTION_SINGLE);
	gtk_signal_connect(GTK_OBJECT(listlist), "select_row", GTK_SIGNAL_FUNC(SelectCb), NULL);

	listwin = gtk_scrolled_window_new(NULL, NULL);
	gtk_container_add(GTK_CONTAINER(listwin), listlist);
	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(listwin), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);
	gtk_container_set_border_width(GTK_CONTAINER(listwin), BORDER_ITEM);
	gtk_box_pack_start(GTK_BOX(vbox), listwin, TRUE, TRUE, 0);

	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), separator, TRUE, TRUE, 0);

	bbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
	gtk_box_pack_end(GTK_BOX(vbox), bbox, TRUE, TRUE, 0);

	button[0] = gtk_button_new_with_label("OK");
	button[1] = gtk_button_new_with_label("Cancel");
	button[2] = gtk_button_new_with_label("Help");

	gtk_container_add(GTK_CONTAINER(bbox), button[0]);
	gtk_container_add(GTK_CONTAINER(bbox), button[1]);
	gtk_container_add(GTK_CONTAINER(bbox), button[2]);

        gtk_signal_connect(GTK_OBJECT(button[0]), "clicked", GTK_SIGNAL_FUNC(IndexCb), NULL);
	gtk_signal_connect_object(GTK_OBJECT(button[1]), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));
        gtk_signal_connect(GTK_OBJECT(button[2]), "clicked", GTK_SIGNAL_FUNC(HelpCb), (gpointer)12);

	GTK_WIDGET_SET_FLAGS(button[0], GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button[1], GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button[2], GTK_CAN_DEFAULT);
	gtk_widget_grab_default(button[0]);

	gtk_clist_freeze(GTK_CLIST(listlist));

	for (i = 0; i < Count; i++)
		gtk_clist_append(GTK_CLIST(listlist), &Help_File_List[i].Description);

	gtk_clist_select_row(GTK_CLIST(listlist), 0, 0);

	gtk_clist_thaw(GTK_CLIST(listlist));

	gtk_widget_show(button[0]);
	gtk_widget_show(button[1]);
	gtk_widget_show(button[2]);
	gtk_widget_show(bbox);
	gtk_widget_show(separator);
	gtk_widget_show(listlist);
	gtk_widget_show(listwin);
	gtk_widget_show(vbox);
	gtk_widget_show(window);
}

static void Display_Help(int n)
{
	GtkWidget *window;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *text;
	GtkWidget *scroll;
	GtkWidget *separator;
	GtkWidget *bbox;
	GtkWidget *button[2];
	char File_Name[81];
	char *Buffer;
	struct stat statb;
	FILE *fp;

	n--;

	sprintf(File_Name, "%s/%s", HELPDIR, Help_File_List[n].File_Name);

	if (stat(File_Name, &statb) == -1 || (statb.st_mode & S_IFMT) != S_IFREG) {
		Warning_Box("Cannot open help file");
		return;
	}

	if ((fp = fopen(File_Name, "r")) == NULL) {
		Warning_Box("Cannot open help file");
		return;
	}

	Buffer = g_malloc(statb.st_size + 1);

	fread(Buffer, sizeof(char), statb.st_size, fp);

	Buffer[statb.st_size] = '\0';
	
	fclose(fp);

	window = gtk_window_new(GTK_WINDOW_DIALOG);

	gtk_window_set_title(GTK_WINDOW(window), "Mtrack Help");
	gtk_container_set_border_width(GTK_CONTAINER(window), BORDER_WIDTH);

	vbox = gtk_vbox_new(FALSE, BORDER_WIDTH);
	gtk_container_add(GTK_CONTAINER(window), vbox);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);

	text = gtk_text_new(NULL, NULL);
	gtk_text_set_editable(GTK_TEXT(text), FALSE);	
	gtk_text_set_word_wrap(GTK_TEXT(text), TRUE);
	gtk_widget_set_usize(text, TEXT_WIDTH, TEXT_HEIGHT);
	gtk_box_pack_start(GTK_BOX(hbox), text, TRUE, TRUE, 0);

	scroll = gtk_vscrollbar_new(GTK_TEXT(text)->vadj);
	gtk_box_pack_end(GTK_BOX(hbox), scroll, TRUE, TRUE, 0);

	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), separator, TRUE, TRUE, 0);

	bbox = gtk_hbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_END);
	gtk_button_box_set_spacing(GTK_BUTTON_BOX(bbox), 5);
	gtk_box_pack_end(GTK_BOX(vbox), bbox, TRUE, TRUE, 0);

	button[0] = gtk_button_new_with_label("Cancel");
	button[1] = gtk_button_new_with_label("Help");

	gtk_container_add(GTK_CONTAINER(bbox), button[0]);
	gtk_container_add(GTK_CONTAINER(bbox), button[1]);

	gtk_signal_connect_object(GTK_OBJECT(button[0]), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));
        gtk_signal_connect(GTK_OBJECT(button[1]), "clicked", GTK_SIGNAL_FUNC(HelpCb), (gpointer)0);

	GTK_WIDGET_SET_FLAGS(button[0], GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button[1], GTK_CAN_DEFAULT);
	gtk_widget_grab_default(button[0]);

	gtk_text_freeze(GTK_TEXT(text));
	gtk_text_insert(GTK_TEXT(text), NULL, NULL, NULL, Buffer, -1);
	gtk_text_thaw(GTK_TEXT(text));

	g_free(Buffer);

	gtk_widget_show(button[0]);
	gtk_widget_show(button[1]);
	gtk_widget_show(bbox);
	gtk_widget_show(separator);
	gtk_widget_show(scroll);
	gtk_widget_show(text);
	gtk_widget_show(hbox);
	gtk_widget_show(vbox);
	gtk_widget_show(window);
}

void AboutCb(GtkWidget *w, gpointer data)
{
	GtkWidget *window;
	GtkWidget *hbox;
	GtkWidget *frame;
	GtkWidget *vbox;
	GtkWidget *bbox;
	GtkWidget *label;
	GtkWidget *button;

	window = gtk_window_new(GTK_WINDOW_DIALOG);

	gtk_window_set_title(GTK_WINDOW(window), "About Mtrack");
	gtk_container_set_border_width(GTK_CONTAINER(window), BORDER_WIDTH);

	hbox = gtk_hbox_new(FALSE, BORDER_WIDTH);
	gtk_container_add(GTK_CONTAINER(window), hbox);

	frame = gtk_frame_new(NULL);
	gtk_box_pack_start(GTK_BOX(hbox), frame, TRUE, TRUE, 0);

	vbox = gtk_vbox_new(FALSE, BORDER_WIDTH);
	gtk_container_set_border_width(GTK_CONTAINER(vbox), BORDER_WIDTH);
	gtk_container_add(GTK_CONTAINER(frame), vbox);

	label = gtk_label_new(About_Text);
	gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);

	bbox = gtk_vbutton_box_new();
	gtk_button_box_set_layout(GTK_BUTTON_BOX(bbox), GTK_BUTTONBOX_START);
	gtk_box_pack_end(GTK_BOX(hbox), bbox, TRUE, TRUE, 0);

	button = gtk_button_new_with_label("OK");
	gtk_container_add(GTK_CONTAINER(bbox), button);

	gtk_signal_connect_object(GTK_OBJECT(button), "clicked", GTK_SIGNAL_FUNC(gtk_widget_destroy), GTK_OBJECT(window));
	GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
	gtk_widget_grab_default(button);

	gtk_widget_show(button);
	gtk_widget_show(label);
	gtk_widget_show(bbox);
	gtk_widget_show(frame);
	gtk_widget_show(vbox);
	gtk_widget_show(hbox);
	gtk_widget_show(window);
}
