/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.CertificateStore;
import sun.plugin.usability.Trace;
import sun.plugin.usability.UserProfile;

public class PluginHttpsCertStore
implements CertificateStore {
    private static String _filename = null;
    private KeyStore _jpicerts = null;

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.securityPrintln(ResourceHandler.getMessage("jpihttpscertstore.cert.loading") + _filename, 2);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file;
                    if (PluginHttpsCertStore.this._jpicerts == null) {
                        PluginHttpsCertStore.this._jpicerts = KeyStore.getInstance("JKS");
                        PluginHttpsCertStore.this._jpicerts.load(null, null);
                    }
                    if ((file = new File(_filename)).exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        PluginHttpsCertStore.this._jpicerts.load(bufferedInputStream, new char[0]);
                        bufferedInputStream.close();
                        fileInputStream.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.securityPrintln(ResourceHandler.getMessage("jpihttpscertstore.cert.loaded") + _filename, 2);
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.securityPrintln(ResourceHandler.getMessage("jpihttpscertstore.cert.saving") + _filename, 2);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    FileOutputStream fileOutputStream = new FileOutputStream(new File(_filename));
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    PluginHttpsCertStore.this._jpicerts.store(bufferedOutputStream, new char[0]);
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.securityPrintln(ResourceHandler.getMessage("jpihttpscertstore.cert.saved") + _filename, 2);
    }

    public void add(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln(ResourceHandler.getMessage("jpihttpscertstore.cert.adding"), 2);
        if (!this.contains(certificate)) {
            Random random = new Random();
            boolean bl = false;
            String string = null;
            do {
                Certificate certificate2;
                if ((certificate2 = this._jpicerts.getCertificate(string = "jpicert" + random.nextLong())) != null) continue;
                bl = true;
            } while (!bl);
            this._jpicerts.setCertificateEntry(string, certificate);
            Trace.securityPrintln(ResourceHandler.getMessage("jpihttpscertstore.cert.added") + string, 2);
        }
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln(ResourceHandler.getMessage("jpihttpscertstore.cert.removing"), 2);
        String string = this._jpicerts.getCertificateAlias(certificate);
        if (string != null) {
            this._jpicerts.deleteEntry(string);
        }
        Trace.securityPrintln(ResourceHandler.getMessage("jpihttpscertstore.cert.removed"), 2);
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln(ResourceHandler.getMessage("jpihttpscertstore.cert.instore"), 2);
        String string = null;
        string = this._jpicerts.getCertificateAlias(certificate);
        return string != null;
    }

    public boolean verify(Certificate certificate) {
        Trace.securityPrintln(ResourceHandler.getMessage("jpihttpscertstore.cert.canverify"), 2);
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        Trace.securityPrintln(ResourceHandler.getMessage("jpihttpscertstore.cert.iterator"), 2);
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        Enumeration<String> enumeration = this._jpicerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = this._jpicerts.getCertificate(string);
            hashSet.add(certificate);
        }
        return hashSet.iterator();
    }

    static {
        _filename = UserProfile.getHttpsCertificateFile();
    }
}

