/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cachescheme;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.util.Hashtable;
import java.util.StringTokenizer;
import sun.plugin.cachescheme.AppletInstallationException;
import sun.plugin.cachescheme.BookmarkManager;
import sun.plugin.cachescheme.EntryNotFoundException;
import sun.plugin.cachescheme.HTMLGenerator;
import sun.plugin.cachescheme.HTMLVersionTable;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.DialogFactory;
import sun.plugin.usability.Trace;
import sun.plugin.usability.UserProfile;
import sun.security.action.GetPropertyAction;

public class HTMLInstaller {
    String relativeCacheDir = UserProfile.getHTMLCacheDir();

    public boolean install(Hashtable hashtable, URL uRL) throws AppletInstallationException, EntryNotFoundException, IOException {
        Object object;
        Trace.println(ResourceHandler.getMessage("html.install.check"), 2);
        Hashtable hashtable2 = (Hashtable)hashtable.clone();
        hashtable2.remove("codebase");
        hashtable2.remove("java_codebase");
        hashtable2.put("codebase", uRL.toString());
        String string = (String)hashtable2.get("applet_html_title");
        String string2 = (String)hashtable2.get("applet_html_version");
        String string3 = (String)hashtable2.get("applet_object_clsid");
        String string4 = (String)hashtable2.get("applet_object_codebase");
        String string5 = (String)hashtable2.get("applet_embed_pluginpage");
        String string6 = (String)hashtable2.get("applet_embed_pluginsurl");
        String string7 = (String)hashtable2.get("type");
        String string8 = (String)hashtable2.get("code");
        String string9 = (String)hashtable2.get("codebase");
        if (string == null) {
            return false;
        }
        if (string2 == null) {
            throw new AppletInstallationException("\"applet_html_version\" is missing from HTML parameter");
        }
        if (string3 == null) {
            throw new AppletInstallationException("\"applet_object_clsid\" is missing from HTML parameter");
        }
        if (string7 == null) {
            throw new AppletInstallationException("\"type\" is missing from HTML parameter");
        }
        if (string8 == null) {
            throw new AppletInstallationException("\"code\" is missing from HTML parameter");
        }
        String string10 = this.mangleName(string);
        try {
            Trace.println(ResourceHandler.getMessage("html.install.version.checklocal"), 2);
            long l = this.calculateVersion(string2);
            object = new HTMLVersionTable();
            ((HTMLVersionTable)object).load();
            String string11 = ((HTMLVersionTable)object).getVersion(string);
            Trace.messagePrintln("html.install.version.remote.local", new Object[]{string2, string11}, null, 2);
            if (this.calculateVersion(string11) >= l) {
                String string12;
                String string13 = ((HTMLVersionTable)object).getPath(string);
                File file = new File(string13, string12 = ((HTMLVersionTable)object).getFilename(string));
                if (file.exists()) {
                    Trace.println(ResourceHandler.getMessage("html.install.local.uptodated"), 2);
                    return true;
                }
                Trace.println(ResourceHandler.getMessage("html.install.local.outdated"), 2);
            } else {
                Trace.println(ResourceHandler.getMessage("html.install.remote.uptodated"), 2);
            }
        }
        catch (EntryNotFoundException entryNotFoundException) {
            Trace.println(ResourceHandler.getMessage("html.install.info.missing"), 2);
        }
        if (!this.promptUserForHTMLInstallation()) {
            Trace.println(ResourceHandler.getMessage("html.install.user.deny"), 2);
            return true;
        }
        String string14 = AccessController.doPrivileged(new GetPropertyAction("user.home"));
        String string15 = UserProfile.getHTMLCacheDir() + File.separator + string10;
        object = "index.html";
        this.installHTML(string, string2, string15, (String)object, hashtable2);
        return true;
    }

    public long calculateVersion(String string) throws AppletInstallationException {
        long l = 0L;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", false);
        if (stringTokenizer.countTokens() != 4) {
            throw new AppletInstallationException("\"applet_html_version\" " + string + " must be in X.X.X.X form where X is 0 to F");
        }
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken().trim();
                l *= 16L;
                l += (long)Integer.parseInt(string2, 16);
            }
        }
        catch (Throwable throwable) {
            throw new AppletInstallationException("\"applet_html_version\" " + string + " must be in X.X.X.X form where X is 0 to F");
        }
        return l;
    }

    public String mangleName(String string) throws AppletInstallationException {
        if (string.indexOf("/") != -1 || string.indexOf("\\") != -1 || string.indexOf(":") != -1 || string.indexOf("*") != -1 || string.indexOf("?") != -1 || string.indexOf("\"") != -1 || string.indexOf("<") != -1 || string.indexOf(">") != -1 || string.indexOf("|") != -1) {
            throw new AppletInstallationException("\"applet_html_title\" can not contain the following characters: / \\ : * ? \" < > |");
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            char c = string.charAt(n);
            if (c == ' ') {
                stringBuffer.append('_');
            } else {
                stringBuffer.append(c);
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    private void installHTML(String string, String string2, String string3, String string4, Hashtable hashtable) throws IOException {
        Trace.println(ResourceHandler.getMessage("html.install.html.generate"), 2);
        HTMLGenerator hTMLGenerator = new HTMLGenerator();
        hTMLGenerator.generate(hashtable, new File(string3, string4));
        Trace.println(ResourceHandler.getMessage("html.install.version.update"), 2);
        HTMLVersionTable hTMLVersionTable = new HTMLVersionTable();
        hTMLVersionTable.load();
        hTMLVersionTable.add(string, string2, string3, string4);
        hTMLVersionTable.save();
        Trace.println(ResourceHandler.getMessage("html.install.bookmark.add"), 2);
        BookmarkManager bookmarkManager = new BookmarkManager();
        bookmarkManager.addBookmark(string, string3 + File.separator + string4);
    }

    private boolean promptUserForHTMLInstallation() {
        String string = ResourceHandler.getMessage("html.caption");
        String string2 = ResourceHandler.getMessage("html.prompt_user");
        int n = 0;
        if (!Trace.isAutomationEnabled()) {
            n = DialogFactory.showConfirmDialog(string2, string);
        } else {
            Trace.println(ResourceHandler.getMessage("html.install.automation"), 2);
            n = 0;
        }
        return n == 0;
    }
}

