/*
 * Decompiled with CFR 0.152.
 */
package sun.security.x509;

import java.io.IOException;
import java.security.cert.PolicyQualifierInfo;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;
import sun.security.x509.AttributeNameEnumeration;
import sun.security.x509.CertificatePolicyId;

public class PolicyInformation {
    public static final String NAME = "PolicyInformation";
    public static final String ID = "id";
    public static final String QUALIFIERS = "qualifiers";
    private CertificatePolicyId policyIdentifier;
    private Set policyQualifiers;

    public PolicyInformation(CertificatePolicyId certificatePolicyId, Set set) throws IOException {
        this.policyQualifiers = new HashSet();
        if (set == null) {
            throw new NullPointerException("policyQualifiers is null");
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            if (object instanceof PolicyQualifierInfo) continue;
            throw new IOException("policyQualifiers must be a Set of java.security.cert.PolicyQualifierInfo objects");
        }
        set.addAll(set);
        this.policyIdentifier = certificatePolicyId;
    }

    /*
     * Unable to fully structure code
     */
    public PolicyInformation(DerValue var1_1) throws IOException {
        block3: {
            super();
            this.policyQualifiers = new HashSet();
            if (var1_1.tag != 48) {
                throw new IOException("Invalid encoding of PolicyInformation");
            }
            this.policyIdentifier = new CertificatePolicyId(var1_1.data.getDerValue());
            if (var1_1.data.available() == 0) break block3;
            var2_2 = var1_1.data.getDerValue();
            if (var2_2.tag != 48) {
                throw new IOException("Invalid encoding of PolicyInformation");
            }
            if (var2_2.data.available() != 0) ** GOTO lbl14
            throw new IOException("No data available in policyQualifiers");
lbl-1000:
            // 1 sources

            {
                this.policyQualifiers.add(new PolicyQualifierInfo(var2_2.data.getDerValue().toByteArray()));
lbl14:
                // 2 sources

                ** while (var2_2.data.available() != 0)
            }
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof PolicyInformation)) {
            return false;
        }
        PolicyInformation policyInformation = (PolicyInformation)object;
        if (!this.policyIdentifier.equals(policyInformation.getPolicyIdentifier())) {
            return false;
        }
        return this.policyQualifiers.equals(policyInformation.getPolicyQualifiers());
    }

    public CertificatePolicyId getPolicyIdentifier() {
        return this.policyIdentifier;
    }

    public Set getPolicyQualifiers() {
        return this.policyQualifiers;
    }

    public Object get(String string) throws IOException {
        if (string.equalsIgnoreCase(ID)) {
            return this.policyIdentifier;
        }
        if (string.equalsIgnoreCase(QUALIFIERS)) {
            return this.policyQualifiers;
        }
        throw new IOException("Attribute name [" + string + "] not recognized by PolicyInformation.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(String string, Object object) throws IOException {
        if (string.equalsIgnoreCase(ID)) {
            if (!(object instanceof CertificatePolicyId)) throw new IOException("Attribute value must be instance of CertificatePolicyId.");
            this.policyIdentifier = (CertificatePolicyId)object;
            return;
        } else {
            if (!string.equalsIgnoreCase(QUALIFIERS)) throw new IOException("Attribute name [" + string + "] not recognized by PolicyInformation");
            if (this.policyIdentifier == null) {
                throw new IOException("Attribute must have a CertificatePolicyIdentifier value before PolicyQualifierInfo can be set.");
            }
            if (!(object instanceof Set)) throw new IOException("Attribute value must be of type Set.");
            Iterator iterator = ((Set)object).iterator();
            while (iterator.hasNext()) {
                Object object2 = iterator.next();
                if (object2 instanceof PolicyQualifierInfo) continue;
                throw new IOException("Attribute value must be aSet of PolicyQualifierInfo objects.");
            }
            this.policyQualifiers = (Set)object;
        }
    }

    public void delete(String string) throws IOException {
        if (string.equalsIgnoreCase(QUALIFIERS)) {
            try {
                this.policyQualifiers.clear();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.policyQualifiers = new HashSet();
            }
        } else {
            if (string.equalsIgnoreCase(ID)) {
                throw new IOException("Attribute ID may not be deleted from PolicyInformation.");
            }
            throw new IOException("Attribute name [" + string + "] not recognized by PolicyInformation.");
        }
    }

    public Enumeration getElements() {
        AttributeNameEnumeration attributeNameEnumeration = new AttributeNameEnumeration();
        attributeNameEnumeration.addElement(ID);
        attributeNameEnumeration.addElement(QUALIFIERS);
        return attributeNameEnumeration.elements();
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("  [" + this.policyIdentifier.toString());
        stringBuffer.append(this.policyQualifiers + "  ]\n");
        return stringBuffer.toString();
    }

    public void encode(DerOutputStream derOutputStream) throws IOException {
        DerOutputStream derOutputStream2 = new DerOutputStream();
        this.policyIdentifier.encode(derOutputStream2);
        if (!this.policyQualifiers.isEmpty()) {
            Iterator iterator = this.policyQualifiers.iterator();
            DerOutputStream derOutputStream3 = new DerOutputStream();
            while (iterator.hasNext()) {
                PolicyQualifierInfo policyQualifierInfo = (PolicyQualifierInfo)iterator.next();
                derOutputStream3.write(policyQualifierInfo.getEncoded());
            }
            derOutputStream2.write((byte)48, derOutputStream3);
        }
        derOutputStream.write((byte)48, derOutputStream2);
    }
}

