/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.util.Collection;
import java.util.Date;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.util.Debug;

class BasicChecker
extends PKIXCertPathChecker {
    private static final Debug debug = Debug.getInstance("certpath");
    private final PublicKey trustedPubKey;
    private final X500Principal caName;
    private final Date testDate;
    private final String sigProvider;
    private final boolean sigOnly;
    private X500Principal prevSubject;
    private PublicKey prevPubKey;

    BasicChecker(PublicKey publicKey, X500Principal x500Principal, Date date, String string, boolean bl2) throws CertPathValidatorException {
        this.trustedPubKey = publicKey;
        this.caName = x500Principal;
        this.testDate = date;
        this.sigProvider = string;
        this.sigOnly = bl2;
        this.init(false);
    }

    public void init(boolean bl2) throws CertPathValidatorException {
        if (bl2) {
            throw new CertPathValidatorException("forward checking not supported");
        }
        this.prevPubKey = this.trustedPubKey;
        this.prevSubject = this.caName;
    }

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public Set getSupportedExtensions() {
        return null;
    }

    public void check(Certificate certificate, Collection collection) throws CertPathValidatorException {
        X509Certificate x509Certificate = (X509Certificate)certificate;
        if (!this.sigOnly) {
            this.verifyTimestamp(x509Certificate, this.testDate);
            this.verifyNameChaining(x509Certificate, this.prevSubject);
        }
        this.verifySignature(x509Certificate, this.prevPubKey, this.sigProvider);
        this.updateState(x509Certificate);
    }

    private void verifySignature(X509Certificate x509Certificate, PublicKey publicKey, String string) throws CertPathValidatorException {
        String string2 = "signature";
        if (debug != null) {
            debug.println("---checking " + string2 + "...");
        }
        try {
            x509Certificate.verify(publicKey, string);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println(exception.getMessage());
                exception.printStackTrace();
            }
            throw new CertPathValidatorException(string2 + " check failed", exception);
        }
        if (debug != null) {
            debug.println(string2 + " verified.");
        }
    }

    private void verifyTimestamp(X509Certificate x509Certificate, Date date) throws CertPathValidatorException {
        String string = "timestamp";
        if (debug != null) {
            debug.println("---checking " + string + ":" + date.toString() + "...");
        }
        try {
            x509Certificate.checkValidity(date);
        }
        catch (Exception exception) {
            if (debug != null) {
                debug.println(exception.getMessage());
                exception.printStackTrace();
            }
            throw new CertPathValidatorException(string + " check failed", exception);
        }
        if (debug != null) {
            debug.println(string + " verified.");
        }
    }

    private void verifyNameChaining(X509Certificate x509Certificate, X500Principal x500Principal) throws CertPathValidatorException {
        if (x500Principal != null) {
            X500Principal x500Principal2;
            String string = "subject/issuer name chaining";
            if (debug != null) {
                debug.println("---checking " + string + "...");
            }
            if ((x500Principal2 = x509Certificate.getIssuerX500Principal()).getName() == null || x500Principal2.getName().length() == 0) {
                throw new CertPathValidatorException(string + " check failed: " + "empty/null issuer DN in certificate is invalid");
            }
            if (!x500Principal2.equals(x500Principal)) {
                throw new CertPathValidatorException(string + " check failed");
            }
            if (debug != null) {
                debug.println(string + " verified.");
            }
        }
    }

    private void updateState(X509Certificate x509Certificate) throws CertPathValidatorException {
        PublicKey publicKey = x509Certificate.getPublicKey();
        if (debug != null) {
            debug.println("BasicChecker.updateState issuer: " + x509Certificate.getIssuerDN().toString() + "; subject: " + x509Certificate.getSubjectDN() + "; serial#: " + x509Certificate.getSerialNumber().toString());
        }
        if (publicKey instanceof DSAPublicKey && ((DSAPublicKey)publicKey).getParams() == null) {
            publicKey = BasicChecker.makeInheritedParamsKey(publicKey, this.prevPubKey);
            if (debug != null) {
                debug.println("BasicChecker.updateState Made key with inherited params");
            }
        }
        this.prevPubKey = publicKey;
        this.prevSubject = x509Certificate.getSubjectX500Principal();
    }

    static PublicKey makeInheritedParamsKey(PublicKey publicKey, PublicKey publicKey2) throws CertPathValidatorException {
        PublicKey publicKey3;
        if (!(publicKey instanceof DSAPublicKey) || !(publicKey2 instanceof DSAPublicKey)) {
            throw new CertPathValidatorException("Input key is not appropriate type for inheriting parameters");
        }
        DSAParams dSAParams = ((DSAPublicKey)publicKey2).getParams();
        if (dSAParams == null) {
            throw new CertPathValidatorException("Key parameters missing");
        }
        try {
            BigInteger bigInteger = ((DSAPublicKey)publicKey).getY();
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(bigInteger, dSAParams.getP(), dSAParams.getQ(), dSAParams.getG());
            publicKey3 = keyFactory.generatePublic(dSAPublicKeySpec);
        }
        catch (Exception exception) {
            throw new CertPathValidatorException("Unable to generate key with inherited parameters: " + exception.getMessage(), exception);
        }
        return publicKey3;
    }

    PublicKey getPublicKey() {
        return this.prevPubKey;
    }
}

