/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.rmi.ConnectException;
import java.rmi.RemoteException;
import java.rmi.dgc.DGC;
import java.rmi.dgc.Lease;
import java.rmi.dgc.VMID;
import java.rmi.server.ObjID;
import java.rmi.server.RemoteRef;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import sun.misc.GC;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.server.RemoteProxy;
import sun.rmi.server.UnicastRef;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.Transport;
import sun.security.action.GetLongAction;

final class DGCClient {
    private static long nextSequenceNum = Long.MIN_VALUE;
    private static VMID vmid = new VMID();
    private static final long leaseValue = (Long)AccessController.doPrivileged(new GetLongAction("java.rmi.dgc.leaseValue", 600000L));
    private static final long cleanInterval = (Long)AccessController.doPrivileged(new GetLongAction("sun.rmi.dgc.cleanInterval", 180000L));
    private static final long gcInterval = (Long)AccessController.doPrivileged(new GetLongAction("sun.rmi.dgc.client.gcInterval", 60000L));
    private static final int dirtyFailureRetries = 5;
    private static final int cleanConnectRetries = 3;
    private static final ObjID[] emptyObjIDArray = new ObjID[0];
    private static final ObjID dgcID = new ObjID(2);

    private DGCClient() {
    }

    static void registerRefs(Endpoint endpoint, List list) {
        EndpointEntry endpointEntry;
        while (!(endpointEntry = EndpointEntry.lookup(endpoint)).registerRefs(list)) {
        }
    }

    private static synchronized long getNextSequenceNum() {
        return nextSequenceNum++;
    }

    private static long computeRenewTime(long l2, long l3) {
        return l2 + l3 / 2L;
    }

    private static class EndpointEntry {
        private Endpoint endpoint;
        private DGC dgc;
        private Map refTable = new HashMap(5);
        private Set invalidRefs = new HashSet(5);
        private boolean removed = false;
        private long renewTime = Long.MAX_VALUE;
        private long expirationTime = Long.MIN_VALUE;
        private int dirtyFailures = 0;
        private long dirtyFailureStartTime;
        private long dirtyFailureDuration;
        private Thread renewCleanThread;
        private boolean interruptible = false;
        private ReferenceQueue refQueue = new ReferenceQueue();
        private Set pendingCleans = new HashSet(5);
        private static Map endpointTable = new HashMap(5);
        private static GC.LatencyRequest gcLatencyRequest = null;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static EndpointEntry lookup(Endpoint endpoint) {
            Map map = endpointTable;
            synchronized (map) {
                EndpointEntry endpointEntry = (EndpointEntry)endpointTable.get(endpoint);
                if (endpointEntry == null) {
                    endpointEntry = new EndpointEntry(endpoint);
                    endpointTable.put(endpoint, endpointEntry);
                    if (gcLatencyRequest == null) {
                        gcLatencyRequest = GC.requestLatency(gcInterval);
                    }
                }
                EndpointEntry endpointEntry2 = endpointEntry;
                return endpointEntry2;
            }
        }

        private EndpointEntry(Endpoint endpoint) {
            this.endpoint = endpoint;
            try {
                LiveRef liveRef = new LiveRef(dgcID, endpoint, false);
                this.dgc = (DGC)((Object)RemoteProxy.getStub("sun.rmi.transport.DGCImpl", (RemoteRef)new UnicastRef(liveRef)));
            }
            catch (RemoteException remoteException) {
                throw new Error("internal error creating DGC stub");
            }
            this.renewCleanThread = (Thread)AccessController.doPrivileged(new NewThreadAction(new RenewCleanThread(), "RenewClean-" + endpoint, true));
            this.renewCleanThread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean registerRefs(List list) {
            long l2;
            Set set = null;
            EndpointEntry endpointEntry = this;
            synchronized (endpointEntry) {
                block9: {
                    block8: {
                        if (!this.removed) break block8;
                        boolean bl2 = false;
                        return bl2;
                    }
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        LiveRef liveRef = (LiveRef)iterator.next();
                        RefEntry refEntry = (RefEntry)this.refTable.get(liveRef);
                        if (refEntry == null) {
                            LiveRef liveRef2 = (LiveRef)liveRef.clone();
                            refEntry = new RefEntry(liveRef2);
                            this.refTable.put(liveRef2, refEntry);
                            if (set == null) {
                                set = new HashSet(5);
                            }
                            set.add(refEntry);
                        }
                        refEntry.addInstanceToRefSet(liveRef);
                    }
                    if (set != null) break block9;
                    boolean bl3 = true;
                    return bl3;
                }
                set.addAll(this.invalidRefs);
                this.invalidRefs.clear();
                l2 = DGCClient.getNextSequenceNum();
            }
            this.makeDirtyCall(set, l2);
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeRefEntry(RefEntry refEntry) {
            this.refTable.remove(refEntry.getRef());
            this.invalidRefs.remove(refEntry);
            if (this.refTable.isEmpty()) {
                Map map = endpointTable;
                synchronized (map) {
                    endpointTable.remove(this.endpoint);
                    Transport transport = this.endpoint.getOutboundTransport();
                    transport.free(this.endpoint);
                    if (endpointTable.isEmpty()) {
                        gcLatencyRequest.cancel();
                        gcLatencyRequest = null;
                    }
                    this.removed = true;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void makeDirtyCall(Set set, long l2) {
            ObjID[] objIDArray = set != null ? EndpointEntry.createObjIDArray(set) : emptyObjIDArray;
            long l3 = System.currentTimeMillis();
            try {
                Lease lease = this.dgc.dirty(objIDArray, l2, new Lease(vmid, leaseValue));
                long l4 = lease.getValue();
                long l5 = DGCClient.computeRenewTime(l3, l4);
                long l6 = l3 + l4;
                EndpointEntry endpointEntry = this;
                synchronized (endpointEntry) {
                    this.dirtyFailures = 0;
                    this.setRenewTime(l5);
                    this.expirationTime = l6;
                }
            }
            catch (Exception exception) {
                long l7 = System.currentTimeMillis();
                EndpointEntry endpointEntry = this;
                synchronized (endpointEntry) {
                    ++this.dirtyFailures;
                    if (this.dirtyFailures == 1) {
                        this.dirtyFailureStartTime = l3;
                        this.dirtyFailureDuration = l7 - l3;
                        this.setRenewTime(l7);
                    } else {
                        long l8;
                        int n2 = this.dirtyFailures - 2;
                        if (n2 == 0) {
                            this.dirtyFailureDuration = this.dirtyFailureDuration + (l7 - l3) >> 1;
                        }
                        if ((l8 = l7 + (this.dirtyFailureDuration << n2)) < this.expirationTime || this.dirtyFailures < 5 || l8 < this.dirtyFailureStartTime + leaseValue) {
                            this.setRenewTime(l8);
                        } else {
                            this.setRenewTime(Long.MAX_VALUE);
                        }
                    }
                    if (set != null) {
                        this.invalidRefs.addAll(set);
                        Iterator iterator = set.iterator();
                        while (iterator.hasNext()) {
                            RefEntry refEntry = (RefEntry)iterator.next();
                            refEntry.markDirtyFailed();
                        }
                    }
                    if (this.renewTime >= this.expirationTime) {
                        this.invalidRefs.addAll(this.refTable.values());
                    }
                }
            }
        }

        private void setRenewTime(long l2) {
            if (l2 < this.renewTime) {
                this.renewTime = l2;
                if (this.interruptible) {
                    AccessController.doPrivileged(new PrivilegedAction(this){
                        private final /* synthetic */ EndpointEntry this$0;
                        {
                            this.this$0 = endpointEntry;
                        }

                        public Object run() {
                            EndpointEntry.access$800(this.this$0).interrupt();
                            return null;
                        }
                    });
                }
            } else {
                this.renewTime = l2;
            }
        }

        private void processPhantomRefs(RefEntry.PhantomLiveRef phantomLiveRef) {
            Set set = null;
            Set set2 = null;
            do {
                RefEntry refEntry = phantomLiveRef.getRefEntry();
                refEntry.removeInstanceFromRefSet(phantomLiveRef);
                if (!refEntry.isRefSetEmpty()) continue;
                if (refEntry.hasDirtyFailed()) {
                    if (set == null) {
                        set = new HashSet(5);
                    }
                    set.add(refEntry);
                } else {
                    if (set2 == null) {
                        set2 = new HashSet(5);
                    }
                    set2.add(refEntry);
                }
                this.removeRefEntry(refEntry);
            } while ((phantomLiveRef = (RefEntry.PhantomLiveRef)this.refQueue.poll()) != null);
            if (set != null) {
                this.pendingCleans.add(new CleanRequest(EndpointEntry.createObjIDArray(set), DGCClient.getNextSequenceNum(), true));
            }
            if (set2 != null) {
                this.pendingCleans.add(new CleanRequest(EndpointEntry.createObjIDArray(set2), DGCClient.getNextSequenceNum(), false));
            }
        }

        private void makeCleanCalls() {
            Iterator iterator = this.pendingCleans.iterator();
            while (iterator.hasNext()) {
                CleanRequest cleanRequest = (CleanRequest)iterator.next();
                try {
                    this.dgc.clean(cleanRequest.objIDs, cleanRequest.sequenceNum, vmid, cleanRequest.strong);
                    iterator.remove();
                }
                catch (ConnectException connectException) {
                    if (++cleanRequest.connectFailures < 3) continue;
                    iterator.remove();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }

        private static ObjID[] createObjIDArray(Set set) {
            ObjID[] objIDArray = new ObjID[set.size()];
            Iterator iterator = set.iterator();
            int n2 = 0;
            while (n2 < objIDArray.length) {
                objIDArray[n2] = ((RefEntry)iterator.next()).getRef().getObjID();
                ++n2;
            }
            return objIDArray;
        }

        static /* synthetic */ Thread access$800(EndpointEntry endpointEntry) {
            return endpointEntry.renewCleanThread;
        }

        private class RefEntry {
            private LiveRef ref;
            private Set refSet = new HashSet(5);
            private boolean dirtyFailed = false;

            public RefEntry(LiveRef liveRef) {
                this.ref = liveRef;
            }

            public LiveRef getRef() {
                return this.ref;
            }

            public void addInstanceToRefSet(LiveRef liveRef) {
                this.refSet.add(new PhantomLiveRef(liveRef));
            }

            public void removeInstanceFromRefSet(PhantomLiveRef phantomLiveRef) {
                this.refSet.remove(phantomLiveRef);
            }

            public boolean isRefSetEmpty() {
                return this.refSet.size() == 0;
            }

            public void markDirtyFailed() {
                this.dirtyFailed = true;
            }

            public boolean hasDirtyFailed() {
                return this.dirtyFailed;
            }

            private class PhantomLiveRef
            extends PhantomReference {
                public PhantomLiveRef(LiveRef liveRef) {
                    super(liveRef, EndpointEntry.this.refQueue);
                }

                public RefEntry getRefEntry() {
                    return RefEntry.this;
                }
            }
        }

        private static class CleanRequest {
            public ObjID[] objIDs;
            public long sequenceNum;
            public boolean strong;
            public int connectFailures = 0;

            public CleanRequest(ObjID[] objIDArray, long l2, boolean bl2) {
                this.objIDs = objIDArray;
                this.sequenceNum = l2;
                this.strong = bl2;
            }
        }

        private class RenewCleanThread
        implements Runnable {
            private RenewCleanThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                do {
                    long l2;
                    RefEntry.PhantomLiveRef phantomLiveRef = null;
                    boolean bl2 = false;
                    Set set = null;
                    long l3 = Long.MIN_VALUE;
                    EndpointEntry endpointEntry = EndpointEntry.this;
                    synchronized (endpointEntry) {
                        long l4 = EndpointEntry.this.renewTime - System.currentTimeMillis();
                        l2 = Math.max(l4, 1L);
                        if (!EndpointEntry.this.pendingCleans.isEmpty()) {
                            l2 = Math.min(l2, cleanInterval);
                        }
                        EndpointEntry.this.interruptible = true;
                    }
                    try {
                        phantomLiveRef = (RefEntry.PhantomLiveRef)EndpointEntry.this.refQueue.remove(l2);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    EndpointEntry endpointEntry2 = EndpointEntry.this;
                    synchronized (endpointEntry2) {
                        long l5;
                        EndpointEntry.this.interruptible = false;
                        Thread.interrupted();
                        if (phantomLiveRef != null) {
                            EndpointEntry.this.processPhantomRefs(phantomLiveRef);
                        }
                        if ((l5 = System.currentTimeMillis()) > EndpointEntry.this.renewTime) {
                            bl2 = true;
                            if (!EndpointEntry.this.invalidRefs.isEmpty()) {
                                set = EndpointEntry.this.invalidRefs;
                                EndpointEntry.this.invalidRefs = new HashSet(5);
                            }
                            l3 = DGCClient.getNextSequenceNum();
                        }
                    }
                    if (bl2) {
                        EndpointEntry.this.makeDirtyCall(set, l3);
                    }
                    if (EndpointEntry.this.pendingCleans.isEmpty()) continue;
                    EndpointEntry.this.makeCleanCalls();
                } while (!EndpointEntry.this.removed || !EndpointEntry.this.pendingCleans.isEmpty());
            }
        }
    }
}

