/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.PrintStream;
import java.lang.ref.SoftReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.MarshalException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.UnmarshalException;
import java.rmi.server.RemoteCall;
import java.rmi.server.RemoteRef;
import java.rmi.server.RemoteStub;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.ServerRef;
import java.rmi.server.Skeleton;
import java.rmi.server.SkeletonNotFoundException;
import java.security.AccessController;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import sun.rmi.runtime.Log;
import sun.rmi.server.Dispatcher;
import sun.rmi.server.MarshalInputStream;
import sun.rmi.server.RemoteProxy;
import sun.rmi.server.UnicastRef;
import sun.rmi.transport.LiveRef;
import sun.rmi.transport.Target;
import sun.rmi.transport.tcp.TCPTransport;
import sun.security.action.GetBooleanAction;

public class UnicastServerRef
extends UnicastRef
implements ServerRef,
Dispatcher {
    public static final Log serverRefLog = Log.getLog("sun.rmi.server.ref", "transport", RemoteProxy.logLevel);
    public static final boolean logCalls;
    public static final Log callLog;
    private static final long serialVersionUID = -7384275867073752268L;
    private static final boolean wantExceptionLog;
    private static final boolean suppressStackTraces;
    private transient Skeleton skel;
    private transient Map methodTable = null;
    private static Map methodTableCache;
    private static Map withoutSkeletons;
    static /* synthetic */ Class class$java$rmi$Remote;

    public UnicastServerRef() {
    }

    public UnicastServerRef(LiveRef liveRef) {
        super(liveRef);
    }

    public UnicastServerRef(int n2) {
        super(new LiveRef(n2));
    }

    public RemoteStub exportObject(Remote remote, Object object) throws RemoteException {
        return this.exportObject(remote, object, false);
    }

    public RemoteStub exportObject(Remote remote, Object object, boolean bl2) throws RemoteException {
        RemoteStub remoteStub = this.setSkeleton(remote);
        Target target = new Target(remote, this, remoteStub, this.ref.getObjID(), bl2);
        this.ref.exportObject(target);
        this.methodTable = UnicastServerRef.getMethodTable(remote.getClass());
        return remoteStub;
    }

    public String getClientHost() throws ServerNotActiveException {
        return TCPTransport.getClientHost();
    }

    public RemoteStub setSkeleton(Remote remote) throws RemoteException {
        if (!withoutSkeletons.containsKey(remote.getClass())) {
            try {
                this.skel = RemoteProxy.getSkeleton(remote);
            }
            catch (SkeletonNotFoundException skeletonNotFoundException) {
                withoutSkeletons.put(remote.getClass(), null);
            }
        }
        return RemoteProxy.getStub(remote, this.getClientRef());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispatch(Remote remote, RemoteCall remoteCall) throws IOException {
        block25: {
            block24: {
                try {
                    try {
                        Object object;
                        long l2;
                        ObjectInput objectInput;
                        try {
                            objectInput = remoteCall.getInputStream();
                            int n2 = objectInput.readInt();
                            if (n2 >= 0) {
                                if (this.skel == null) throw new UnmarshalException("skeleton class not found but required for client version");
                                this.oldDispatch(remote, remoteCall, n2);
                                Object var16_7 = null;
                                break block24;
                            }
                            l2 = objectInput.readLong();
                        }
                        catch (Exception exception) {
                            throw new UnmarshalException("error unmarshalling call header", exception);
                        }
                        MarshalInputStream marshalInputStream = (MarshalInputStream)objectInput;
                        marshalInputStream.skipDefaultResolveClass();
                        Method method = (Method)this.methodTable.get(new Long(l2));
                        if (method == null) {
                            throw new UnmarshalException("invalid method hash");
                        }
                        this.logCall(remote, method);
                        Class[] classArray = method.getParameterTypes();
                        Object[] objectArray = new Object[classArray.length];
                        try {
                            try {
                                this.unmarshalCustomCallData(objectInput);
                                int n3 = 0;
                                while (n3 < classArray.length) {
                                    objectArray[n3] = UnicastRef.unmarshalValue(classArray[n3], objectInput);
                                    ++n3;
                                }
                            }
                            catch (IOException iOException) {
                                throw new UnmarshalException("error unmarshalling arguments", iOException);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new UnmarshalException("error unmarshalling arguments", classNotFoundException);
                            }
                            Object var14_21 = null;
                        }
                        catch (Throwable throwable) {
                            Object var14_22 = null;
                            remoteCall.releaseInputStream();
                            throw throwable;
                        }
                        remoteCall.releaseInputStream();
                        try {
                            object = method.invoke(remote, objectArray);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            throw invocationTargetException.getTargetException();
                        }
                        try {
                            ObjectOutput objectOutput = remoteCall.getResultStream(true);
                            Class clazz = method.getReturnType();
                            if (clazz != Void.TYPE) {
                                UnicastRef.marshalValue(clazz, object, objectOutput);
                            }
                            break block25;
                        }
                        catch (IOException iOException) {
                            throw new MarshalException("error marshalling return", iOException);
                        }
                    }
                    catch (Throwable throwable) {
                        RemoteException remoteException;
                        this.logCallException(throwable);
                        ObjectOutput objectOutput = remoteCall.getResultStream(false);
                        if (throwable instanceof Error) {
                            remoteException = new ServerError("Error occurred in server thread", (Error)throwable);
                        } else if (throwable instanceof RemoteException) {
                            remoteException = new ServerException("RemoteException occurred in server thread", (Exception)throwable);
                        }
                        if (suppressStackTraces) {
                            UnicastServerRef.clearStackTraces(remoteException);
                        }
                        objectOutput.writeObject(remoteException);
                        Object var16_9 = null;
                        remoteCall.releaseInputStream();
                        remoteCall.releaseOutputStream();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var16_10 = null;
                    remoteCall.releaseInputStream();
                    remoteCall.releaseOutputStream();
                    throw throwable;
                }
            }
            remoteCall.releaseInputStream();
            remoteCall.releaseOutputStream();
            return;
        }
        Object var16_8 = null;
        remoteCall.releaseInputStream();
        remoteCall.releaseOutputStream();
    }

    protected void unmarshalCustomCallData(ObjectInput objectInput) throws IOException, ClassNotFoundException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void oldDispatch(Remote remote, RemoteCall remoteCall, int n2) throws IOException {
        try {
            try {
                long l2;
                ObjectInput objectInput;
                try {
                    objectInput = remoteCall.getInputStream();
                    l2 = objectInput.readLong();
                }
                catch (Exception exception) {
                    throw new UnmarshalException("error unmarshalling call header", exception);
                }
                this.logCall(remote, this.skel.getOperations()[n2]);
                this.unmarshalCustomCallData(objectInput);
                this.skel.dispatch(remote, remoteCall, n2, l2);
            }
            catch (Throwable throwable) {
                RemoteException remoteException;
                this.logCallException(throwable);
                ObjectOutput objectOutput = remoteCall.getResultStream(false);
                if (throwable instanceof Error) {
                    remoteException = new ServerError("Error occurred in server thread", (Error)throwable);
                } else if (throwable instanceof RemoteException) {
                    remoteException = new ServerException("RemoteException occurred in server thread", (Exception)throwable);
                }
                if (suppressStackTraces) {
                    UnicastServerRef.clearStackTraces(remoteException);
                }
                objectOutput.writeObject(remoteException);
                Object var9_11 = null;
                remoteCall.releaseInputStream();
                remoteCall.releaseOutputStream();
                return;
            }
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            remoteCall.releaseInputStream();
            remoteCall.releaseOutputStream();
            throw throwable;
        }
        remoteCall.releaseInputStream();
        remoteCall.releaseOutputStream();
    }

    public static void clearStackTraces(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = new StackTraceElement[]{};
        while (throwable != null) {
            throwable.setStackTrace(stackTraceElementArray);
            throwable = throwable.getCause();
        }
    }

    private void logCall(Remote remote, Object object) {
        if (callLog.isLoggable(Log.VERBOSE)) {
            String string;
            try {
                string = this.getClientHost();
            }
            catch (ServerNotActiveException serverNotActiveException) {
                string = "(local)";
            }
            callLog.log(Log.VERBOSE, "[" + string + ": " + remote.getClass().getName() + this.ref.getObjID().toString() + ": " + object + "]");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logCallException(Throwable throwable) {
        Object object;
        if (callLog.isLoggable(Log.BRIEF)) {
            object = "";
            try {
                object = "[" + this.getClientHost() + "] ";
            }
            catch (ServerNotActiveException serverNotActiveException) {
                // empty catch block
            }
            callLog.log(Log.BRIEF, (String)object + "exception: ", throwable);
        }
        if (wantExceptionLog) {
            Object object2 = object = System.err;
            synchronized (object2) {
                ((PrintStream)object).println();
                ((PrintStream)object).println("Exception dispatching call to " + this.ref.getObjID() + " in thread \"" + Thread.currentThread().getName() + "\" at " + new Date() + ":");
                throwable.printStackTrace((PrintStream)object);
            }
        }
    }

    public String getRefClass(ObjectOutput objectOutput) {
        return "UnicastServerRef";
    }

    protected RemoteRef getClientRef() {
        return new UnicastRef(this.ref);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.ref = null;
        this.skel = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map getMethodTable(Class clazz) {
        SoftReference[] softReferenceArray;
        Map map = methodTableCache;
        synchronized (map) {
            softReferenceArray = (SoftReference[])methodTableCache.get(clazz);
            if (softReferenceArray == null) {
                softReferenceArray = new SoftReference[]{null};
                methodTableCache.put(clazz, softReferenceArray);
            }
        }
        SoftReference[] softReferenceArray2 = softReferenceArray;
        synchronized (softReferenceArray2) {
            Map map2 = null;
            if (softReferenceArray[0] != null) {
                map2 = (Map)softReferenceArray[0].get();
            }
            if (map2 == null) {
                map2 = UnicastServerRef.createMethodTable(clazz);
                softReferenceArray[0] = new SoftReference(map2);
            }
            Map map3 = map2;
            return map3;
        }
    }

    private static Map createMethodTable(Class clazz) {
        HashMap hashMap = new HashMap(11);
        Class clazz2 = clazz;
        while (clazz2 != null) {
            Class[] classArray = clazz2.getInterfaces();
            int n2 = 0;
            while (n2 < classArray.length) {
                if ((class$java$rmi$Remote == null ? UnicastServerRef.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(classArray[n2])) {
                    Method[] methodArray = classArray[n2].getMethods();
                    int n3 = 0;
                    while (n3 < methodArray.length) {
                        final Method method = methodArray[n3];
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                method.setAccessible(true);
                                return null;
                            }
                        });
                        long l2 = UnicastServerRef.computeMethodHash(method);
                        hashMap.put(new Long(l2), method);
                        ++n3;
                    }
                }
                ++n2;
            }
            clazz2 = clazz2.getSuperclass();
        }
        return hashMap;
    }

    private static long computeMethodHash(Method method) {
        long l2 = 0L;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(127);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DataOutputStream dataOutputStream = new DataOutputStream(new DigestOutputStream(byteArrayOutputStream, messageDigest));
            String string = UnicastServerRef.getMethodNameAndDescriptor(method);
            if (serverRefLog.isLoggable(Log.VERBOSE)) {
                serverRefLog.log(Log.VERBOSE, "string used for method hash: \"" + string + "\"");
            }
            dataOutputStream.writeUTF(string);
            dataOutputStream.flush();
            byte[] byArray = messageDigest.digest();
            int n2 = 0;
            while (n2 < Math.min(8, byArray.length)) {
                l2 += (long)(byArray[n2] & 0xFF) << n2 * 8;
                ++n2;
            }
        }
        catch (IOException iOException) {
            l2 = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l2;
    }

    private static String getMethodNameAndDescriptor(Method method) {
        StringBuffer stringBuffer = new StringBuffer(method.getName());
        stringBuffer.append('(');
        Class[] classArray = method.getParameterTypes();
        int n2 = 0;
        while (n2 < classArray.length) {
            stringBuffer.append(UnicastServerRef.getTypeDescriptor(classArray[n2]));
            ++n2;
        }
        stringBuffer.append(')');
        Class clazz = method.getReturnType();
        if (clazz == Void.TYPE) {
            stringBuffer.append('V');
        } else {
            stringBuffer.append(UnicastServerRef.getTypeDescriptor(clazz));
        }
        return stringBuffer.toString();
    }

    private static String getTypeDescriptor(Class clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                return "I";
            }
            if (clazz == Boolean.TYPE) {
                return "Z";
            }
            if (clazz == Byte.TYPE) {
                return "B";
            }
            if (clazz == Character.TYPE) {
                return "C";
            }
            if (clazz == Short.TYPE) {
                return "S";
            }
            if (clazz == Long.TYPE) {
                return "J";
            }
            if (clazz == Float.TYPE) {
                return "F";
            }
            if (clazz == Double.TYPE) {
                return "D";
            }
            if (clazz == Void.TYPE) {
                return "V";
            }
            throw new Error("unrecognized primitive type: " + clazz);
        }
        if (clazz.isArray()) {
            return clazz.getName().replace('.', '/');
        }
        return "L" + clazz.getName().replace('.', '/') + ";";
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.logCalls"));
        logCalls = bl2;
        callLog = Log.getLog("sun.rmi.server.call", "RMI", logCalls);
        wantExceptionLog = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.exceptionTrace"));
        suppressStackTraces = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.rmi.server.suppressStackTraces"));
        methodTableCache = new WeakHashMap(11);
        withoutSkeletons = Collections.synchronizedMap(new WeakHashMap(11));
    }
}

