/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.image;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import sun.awt.image.ImageConsumerQueue;
import sun.awt.image.ImageFormatException;
import sun.awt.image.InputStreamImageSource;

public abstract class ImageDecoder {
    InputStreamImageSource source;
    InputStream input;
    Thread feeder;
    protected boolean aborted;
    protected boolean finished;
    ImageConsumerQueue queue;
    ImageDecoder next;

    public ImageDecoder(InputStreamImageSource inputStreamImageSource, InputStream inputStream) {
        this.source = inputStreamImageSource;
        this.input = inputStream;
        this.feeder = Thread.currentThread();
    }

    public boolean isConsumer(ImageConsumer imageConsumer) {
        return ImageConsumerQueue.isConsumer(this.queue, imageConsumer);
    }

    public void removeConsumer(ImageConsumer imageConsumer) {
        this.queue = ImageConsumerQueue.removeConsumer(this.queue, imageConsumer, false);
        if (!this.finished && this.queue == null) {
            this.abort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ImageConsumerQueue nextConsumer(ImageConsumerQueue imageConsumerQueue) {
        InputStreamImageSource inputStreamImageSource = this.source;
        synchronized (inputStreamImageSource) {
            if (this.aborted) {
                return null;
            }
            imageConsumerQueue = imageConsumerQueue == null ? this.queue : imageConsumerQueue.next;
            while (imageConsumerQueue != null) {
                if (imageConsumerQueue.interested) {
                    return imageConsumerQueue;
                }
                imageConsumerQueue = imageConsumerQueue.next;
            }
            return null;
        }
    }

    protected int setDimensions(int n2, int n3) {
        ImageConsumerQueue imageConsumerQueue = null;
        int n4 = 0;
        while ((imageConsumerQueue = this.nextConsumer(imageConsumerQueue)) != null) {
            imageConsumerQueue.consumer.setDimensions(n2, n3);
            ++n4;
        }
        return n4;
    }

    protected int setProperties(Hashtable hashtable) {
        ImageConsumerQueue imageConsumerQueue = null;
        int n2 = 0;
        while ((imageConsumerQueue = this.nextConsumer(imageConsumerQueue)) != null) {
            imageConsumerQueue.consumer.setProperties(hashtable);
            ++n2;
        }
        return n2;
    }

    protected int setColorModel(ColorModel colorModel) {
        ImageConsumerQueue imageConsumerQueue = null;
        int n2 = 0;
        while ((imageConsumerQueue = this.nextConsumer(imageConsumerQueue)) != null) {
            imageConsumerQueue.consumer.setColorModel(colorModel);
            ++n2;
        }
        return n2;
    }

    protected int setHints(int n2) {
        ImageConsumerQueue imageConsumerQueue = null;
        int n3 = 0;
        while ((imageConsumerQueue = this.nextConsumer(imageConsumerQueue)) != null) {
            imageConsumerQueue.consumer.setHints(n2);
            ++n3;
        }
        return n3;
    }

    protected void headerComplete() {
        this.feeder.setPriority(3);
    }

    protected int setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, byte[] byArray, int n6, int n7) {
        this.source.latchConsumers(this);
        ImageConsumerQueue imageConsumerQueue = null;
        int n8 = 0;
        while ((imageConsumerQueue = this.nextConsumer(imageConsumerQueue)) != null) {
            imageConsumerQueue.consumer.setPixels(n2, n3, n4, n5, colorModel, byArray, n6, n7);
            ++n8;
        }
        return n8;
    }

    protected int setPixels(int n2, int n3, int n4, int n5, ColorModel colorModel, int[] nArray, int n6, int n7) {
        this.source.latchConsumers(this);
        ImageConsumerQueue imageConsumerQueue = null;
        int n8 = 0;
        while ((imageConsumerQueue = this.nextConsumer(imageConsumerQueue)) != null) {
            imageConsumerQueue.consumer.setPixels(n2, n3, n4, n5, colorModel, nArray, n6, n7);
            ++n8;
        }
        return n8;
    }

    protected int imageComplete(int n2, boolean bl2) {
        this.source.latchConsumers(this);
        if (bl2) {
            this.finished = true;
            this.source.doneDecoding(this);
        }
        ImageConsumerQueue imageConsumerQueue = null;
        int n3 = 0;
        while ((imageConsumerQueue = this.nextConsumer(imageConsumerQueue)) != null) {
            imageConsumerQueue.consumer.imageComplete(n2);
            ++n3;
        }
        return n3;
    }

    public void replayConsumer(ImageConsumer imageConsumer) {
    }

    public abstract boolean catchupConsumer(InputStreamImageSource var1, ImageConsumer var2);

    public abstract void produceImage() throws IOException, ImageFormatException;

    public void abort() {
        this.aborted = true;
        this.source.doneDecoding(this);
        this.close();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ImageDecoder.this.feeder.interrupt();
                return null;
            }
        });
    }

    public synchronized void close() {
        if (this.input != null) {
            try {
                this.input.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

