/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

public class SuballocatedIntVector {
    protected int m_blocksize;
    protected int m_numblocks = 32;
    protected int[][] m_map;
    protected int m_firstFree = 0;
    protected int[] m_map0;

    public SuballocatedIntVector() {
        this(2048);
    }

    public SuballocatedIntVector(int n2) {
        this.m_blocksize = n2;
        this.m_map0 = new int[n2];
        this.m_map = new int[this.m_numblocks][];
        this.m_map[0] = this.m_map0;
    }

    public SuballocatedIntVector(int n2, int n3) {
        this(n2);
    }

    public int size() {
        return this.m_firstFree;
    }

    private void setSize(int n2) {
        if (this.m_firstFree < n2) {
            this.m_firstFree = n2;
        }
    }

    public void addElement(int n2) {
        if (this.m_firstFree < this.m_blocksize) {
            this.m_map0[this.m_firstFree++] = n2;
        } else {
            int[] nArray;
            int n3 = this.m_firstFree / this.m_blocksize;
            int n4 = this.m_firstFree % this.m_blocksize;
            if (n3 >= this.m_map.length) {
                int n5 = n3 + this.m_numblocks;
                int[][] nArrayArray = new int[n5][];
                System.arraycopy(this.m_map, 0, nArrayArray, 0, this.m_map.length);
                this.m_map = nArrayArray;
            }
            if (null == (nArray = this.m_map[n3])) {
                this.m_map[n3] = new int[this.m_blocksize];
                nArray = this.m_map[n3];
            }
            nArray[n4] = n2;
            ++this.m_firstFree;
        }
    }

    private void addElements(int n2, int n3) {
        if (this.m_firstFree + n3 < this.m_blocksize) {
            int n4 = 0;
            while (n4 < n3) {
                this.m_map0[this.m_firstFree++] = n2;
                ++n4;
            }
        } else {
            int n5 = this.m_firstFree / this.m_blocksize;
            int n6 = this.m_firstFree % this.m_blocksize;
            this.m_firstFree += n3;
            while (n3 > 0) {
                int[] nArray;
                if (n5 >= this.m_map.length) {
                    int n7 = n5 + this.m_numblocks;
                    int[][] nArrayArray = new int[n7][];
                    System.arraycopy(this.m_map, 0, nArrayArray, 0, this.m_map.length);
                    this.m_map = nArrayArray;
                }
                if (null == (nArray = this.m_map[n5])) {
                    this.m_map[n5] = new int[this.m_blocksize];
                    nArray = this.m_map[n5];
                }
                int n8 = this.m_blocksize - n6 < n3 ? this.m_blocksize - n6 : n3;
                n3 -= n8;
                while (n8-- > 0) {
                    nArray[n6++] = n2;
                }
                ++n5;
                n6 = 0;
            }
        }
    }

    private void addElements(int n2) {
        int n3 = this.m_firstFree + n2;
        if (n3 > this.m_blocksize) {
            int n4 = this.m_firstFree % this.m_blocksize;
            int n5 = (this.m_firstFree + n2) % this.m_blocksize;
            int n6 = n4 + 1;
            while (n6 <= n5) {
                this.m_map[n6] = new int[this.m_blocksize];
                ++n6;
            }
        }
        this.m_firstFree = n3;
    }

    private void insertElementAt(int n2, int n3) {
        if (n3 == this.m_firstFree) {
            this.addElement(n2);
        } else if (n3 > this.m_firstFree) {
            int[] nArray;
            int n4 = n3 / this.m_blocksize;
            if (n4 >= this.m_map.length) {
                int n5 = n4 + this.m_numblocks;
                int[][] nArrayArray = new int[n5][];
                System.arraycopy(this.m_map, 0, nArrayArray, 0, this.m_map.length);
                this.m_map = nArrayArray;
            }
            if (null == (nArray = this.m_map[n4])) {
                this.m_map[n4] = new int[this.m_blocksize];
                nArray = this.m_map[n4];
            }
            int n6 = n3 % this.m_blocksize;
            nArray[n6] = n2;
            this.m_firstFree = n6 + 1;
        } else {
            int n7 = n3 / this.m_blocksize;
            int n8 = this.m_firstFree / this.m_blocksize;
            ++this.m_firstFree;
            int n9 = n3 % this.m_blocksize;
            while (n7 <= n8) {
                int n10;
                int n11 = this.m_blocksize - n9 - 1;
                int[] nArray = this.m_map[n7];
                if (null == nArray) {
                    n10 = 0;
                    this.m_map[n7] = new int[this.m_blocksize];
                    nArray = this.m_map[n7];
                } else {
                    n10 = nArray[this.m_blocksize - 1];
                    System.arraycopy(nArray, n9, nArray, n9 + 1, n11);
                }
                nArray[n9] = n2;
                n2 = n10;
                n9 = 0;
                ++n7;
            }
        }
    }

    public void removeAllElements() {
        this.m_firstFree = 0;
    }

    private boolean removeElement(int n2) {
        int n3 = this.indexOf(n2, 0);
        if (n3 < 0) {
            return false;
        }
        this.removeElementAt(n3);
        return true;
    }

    private void removeElementAt(int n2) {
        if (n2 < this.m_firstFree) {
            int n3 = n2 / this.m_blocksize;
            int n4 = this.m_firstFree / this.m_blocksize;
            int n5 = n2 % this.m_blocksize;
            while (n3 <= n4) {
                int n6 = this.m_blocksize - n5 - 1;
                int[] nArray = this.m_map[n3];
                if (null == nArray) {
                    this.m_map[n3] = new int[this.m_blocksize];
                    nArray = this.m_map[n3];
                } else {
                    System.arraycopy(nArray, n5 + 1, nArray, n5, n6);
                }
                if (n3 < n4) {
                    int[] nArray2 = this.m_map[n3 + 1];
                    if (nArray2 != null) {
                        nArray[this.m_blocksize - 1] = nArray2 != null ? nArray2[0] : 0;
                    }
                } else {
                    nArray[this.m_blocksize - 1] = 0;
                }
                n5 = 0;
                ++n3;
            }
        }
        --this.m_firstFree;
    }

    public void setElementAt(int n2, int n3) {
        if (n3 < this.m_blocksize) {
            this.m_map0[n3] = n2;
        } else {
            int[] nArray;
            int n4 = n3 / this.m_blocksize;
            int n5 = n3 % this.m_blocksize;
            if (n4 >= this.m_map.length) {
                int n6 = n4 + this.m_numblocks;
                int[][] nArrayArray = new int[n6][];
                System.arraycopy(this.m_map, 0, nArrayArray, 0, this.m_map.length);
                this.m_map = nArrayArray;
            }
            if (null == (nArray = this.m_map[n4])) {
                this.m_map[n4] = new int[this.m_blocksize];
                nArray = this.m_map[n4];
            }
            nArray[n5] = n2;
        }
        if (n3 >= this.m_firstFree) {
            this.m_firstFree = n3 + 1;
        }
    }

    public int elementAt(int n2) {
        if (n2 < this.m_blocksize) {
            return this.m_map0[n2];
        }
        return this.m_map[n2 / this.m_blocksize][n2 % this.m_blocksize];
    }

    private boolean contains(int n2) {
        return this.indexOf(n2, 0) >= 0;
    }

    public int indexOf(int n2, int n3) {
        int n4;
        int[] nArray;
        if (n3 >= this.m_firstFree) {
            return -1;
        }
        int n5 = n3 / this.m_blocksize;
        int n6 = n3 % this.m_blocksize;
        int n7 = this.m_firstFree / this.m_blocksize;
        while (n5 < n7) {
            nArray = this.m_map[n5];
            if (nArray != null) {
                n4 = n6;
                while (n4 < this.m_blocksize) {
                    if (nArray[n4] == n2) {
                        return n4 + n5 * this.m_blocksize;
                    }
                    ++n4;
                }
            }
            n6 = 0;
            ++n5;
        }
        n4 = this.m_firstFree % this.m_blocksize;
        nArray = this.m_map[n7];
        int n8 = n6;
        while (n8 < n4) {
            if (nArray[n8] == n2) {
                return n8 + n7 * this.m_blocksize;
            }
            ++n8;
        }
        return -1;
    }

    public int indexOf(int n2) {
        return this.indexOf(n2, 0);
    }

    private int lastIndexOf(int n2) {
        int n3 = this.m_firstFree % this.m_blocksize;
        int n4 = this.m_firstFree / this.m_blocksize;
        while (n4 >= 0) {
            int[] nArray = this.m_map[n4];
            if (nArray != null) {
                int n5 = n3;
                while (n5 >= 0) {
                    if (nArray[n5] == n2) {
                        return n5 + n4 * this.m_blocksize;
                    }
                    --n5;
                }
            }
            n3 = 0;
            --n4;
        }
        return -1;
    }
}

