/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.BitSet;
import java.util.Vector;
import javax.swing.SizeRequirements;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BoxView;
import javax.swing.text.Element;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.html.HTML;

public abstract class TableView
extends BoxView {
    int[] columnSpans;
    int[] columnOffsets;
    SizeRequirements[] columnRequirements;
    Vector rows = new Vector();
    boolean gridValid = false;
    private static final BitSet EMPTY = new BitSet();

    public TableView(Element element) {
        super(element, 1);
    }

    protected TableRow createTableRow(Element element) {
        return new TableRow(element);
    }

    protected TableCell createTableCell(Element element) {
        return new TableCell(element);
    }

    int getColumnCount() {
        return this.columnSpans.length;
    }

    int getColumnSpan(int n2) {
        return this.columnSpans[n2];
    }

    int getRowCount() {
        return this.rows.size();
    }

    int getRowSpan(int n2) {
        TableRow tableRow = this.getRow(n2);
        if (tableRow != null) {
            return (int)((View)tableRow).getPreferredSpan(1);
        }
        return 0;
    }

    TableRow getRow(int n2) {
        if (n2 < this.rows.size()) {
            return (TableRow)this.rows.elementAt(n2);
        }
        return null;
    }

    int getColumnsOccupied(View view) {
        AttributeSet attributeSet = view.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.COLSPAN);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    int getRowsOccupied(View view) {
        AttributeSet attributeSet = view.getElement().getAttributes();
        String string = (String)attributeSet.getAttribute(HTML.Attribute.ROWSPAN);
        if (string != null) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 1;
    }

    void invalidateGrid() {
        this.gridValid = false;
    }

    protected void forwardUpdate(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Container container;
        super.forwardUpdate(elementChange, documentEvent, shape, viewFactory);
        if (shape != null && (container = this.getContainer()) != null) {
            Rectangle rectangle = shape instanceof Rectangle ? (Rectangle)shape : shape.getBounds();
            container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void replace(int n2, int n3, View[] viewArray) {
        super.replace(n2, n3, viewArray);
        this.invalidateGrid();
    }

    void updateGrid() {
        if (!this.gridValid) {
            this.rows.removeAllElements();
            int n2 = this.getViewCount();
            int n3 = 0;
            while (n3 < n2) {
                View view = this.getView(n3);
                if (view instanceof TableRow) {
                    this.rows.addElement(view);
                    TableRow tableRow = (TableRow)view;
                    tableRow.clearFilledColumns();
                    tableRow.setRow(n3);
                }
                ++n3;
            }
            int n4 = 0;
            int n5 = this.rows.size();
            int n6 = 0;
            while (n6 < n5) {
                TableRow tableRow = this.getRow(n6);
                int n7 = 0;
                int n8 = 0;
                while (n8 < tableRow.getViewCount()) {
                    View view = tableRow.getView(n8);
                    while (tableRow.isFilled(n7)) {
                        ++n7;
                    }
                    int n9 = this.getRowsOccupied(view);
                    int n10 = this.getColumnsOccupied(view);
                    if (n10 > 1 || n9 > 1) {
                        int n11 = n6 + n9;
                        int n12 = n7 + n10;
                        int n13 = n6;
                        while (n13 < n11) {
                            int n14 = n7;
                            while (n14 < n12) {
                                if (n13 != n6 || n14 != n7) {
                                    this.addFill(n13, n14);
                                }
                                ++n14;
                            }
                            ++n13;
                        }
                        if (n10 > 1) {
                            n7 += n10 - 1;
                        }
                    }
                    ++n8;
                    ++n7;
                }
                n4 = Math.max(n4, n7);
                ++n6;
            }
            this.columnSpans = new int[n4];
            this.columnOffsets = new int[n4];
            this.columnRequirements = new SizeRequirements[n4];
            int n15 = 0;
            while (n15 < n4) {
                this.columnRequirements[n15] = new SizeRequirements();
                ++n15;
            }
            this.gridValid = true;
        }
    }

    void addFill(int n2, int n3) {
        TableRow tableRow = this.getRow(n2);
        if (tableRow != null) {
            tableRow.fillColumn(n3);
        }
    }

    protected void layoutColumns(int n2, int[] nArray, int[] nArray2, SizeRequirements[] sizeRequirementsArray) {
        SizeRequirements.calculateTiledPositions(n2, null, sizeRequirementsArray, nArray, nArray2);
    }

    protected void layoutMinorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
        this.updateGrid();
        int n4 = this.getRowCount();
        int n5 = 0;
        while (n5 < n4) {
            TableRow tableRow = this.getRow(n5);
            tableRow.layoutChanged(n3);
            ++n5;
        }
        this.layoutColumns(n2, this.columnOffsets, this.columnSpans, this.columnRequirements);
        super.layoutMinorAxis(n2, n3, nArray, nArray2);
    }

    protected SizeRequirements calculateMinorAxisRequirements(int n2, SizeRequirements sizeRequirements) {
        this.updateGrid();
        this.calculateColumnRequirements(n2);
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n3 = 0;
        while (n3 < this.columnRequirements.length) {
            SizeRequirements sizeRequirements2 = this.columnRequirements[n3];
            l2 += (long)sizeRequirements2.minimum;
            l3 += (long)sizeRequirements2.preferred;
            l4 += (long)sizeRequirements2.maximum;
            ++n3;
        }
        sizeRequirements.minimum = (int)l2;
        sizeRequirements.preferred = (int)l3;
        sizeRequirements.maximum = (int)l4;
        sizeRequirements.alignment = 0.0f;
        return sizeRequirements;
    }

    void calculateColumnRequirements(int n2) {
        int n3;
        int n4;
        int n5;
        boolean bl2 = false;
        int n6 = this.getRowCount();
        int n7 = 0;
        while (n7 < n6) {
            TableRow tableRow = this.getRow(n7);
            int n8 = 0;
            n5 = tableRow.getViewCount();
            n4 = 0;
            while (n4 < n5) {
                View view = tableRow.getView(n4);
                while (tableRow.isFilled(n8)) {
                    ++n8;
                }
                int n9 = this.getRowsOccupied(view);
                n3 = this.getColumnsOccupied(view);
                if (n3 == 1) {
                    this.checkSingleColumnCell(n2, n8, view);
                } else {
                    bl2 = true;
                    n8 += n3 - 1;
                }
                ++n4;
                ++n8;
            }
            ++n7;
        }
        if (bl2) {
            int n10 = 0;
            while (n10 < n6) {
                TableRow tableRow = this.getRow(n10);
                n5 = 0;
                n4 = tableRow.getViewCount();
                int n11 = 0;
                while (n11 < n4) {
                    View view = tableRow.getView(n11);
                    while (tableRow.isFilled(n5)) {
                        ++n5;
                    }
                    n3 = this.getColumnsOccupied(view);
                    if (n3 > 1) {
                        this.checkMultiColumnCell(n2, n5, n3, view);
                        n5 += n3 - 1;
                    }
                    ++n11;
                    ++n5;
                }
                ++n10;
            }
        }
    }

    void checkSingleColumnCell(int n2, int n3, View view) {
        SizeRequirements sizeRequirements = this.columnRequirements[n3];
        sizeRequirements.minimum = Math.max((int)view.getMinimumSpan(n2), sizeRequirements.minimum);
        sizeRequirements.preferred = Math.max((int)view.getPreferredSpan(n2), sizeRequirements.preferred);
        sizeRequirements.maximum = Math.max((int)view.getMaximumSpan(n2), sizeRequirements.maximum);
    }

    void checkMultiColumnCell(int n2, int n3, int n4, View view) {
        int n5;
        Object object;
        long l2 = 0L;
        long l3 = 0L;
        long l4 = 0L;
        int n6 = 0;
        while (n6 < n4) {
            SizeRequirements sizeRequirements = this.columnRequirements[n3 + n6];
            l2 += (long)sizeRequirements.minimum;
            l3 += (long)sizeRequirements.preferred;
            l4 += (long)sizeRequirements.maximum;
            ++n6;
        }
        int n7 = (int)view.getMinimumSpan(n2);
        if ((long)n7 > l2) {
            Object object2;
            SizeRequirements[] sizeRequirementsArray = new SizeRequirements[n4];
            int n8 = 0;
            while (n8 < n4) {
                sizeRequirementsArray[n8] = this.columnRequirements[n3 + n8];
                object2 = sizeRequirementsArray[n8];
                object2.maximum = Math.max(object2.maximum, (int)view.getMaximumSpan(n2));
                ++n8;
            }
            object2 = new int[n4];
            object = new int[n4];
            SizeRequirements.calculateTiledPositions(n7, null, sizeRequirementsArray, object, object2);
            int n9 = 0;
            while (n9 < n4) {
                SizeRequirements sizeRequirements = sizeRequirementsArray[n9];
                sizeRequirements.minimum = Math.max(object2[n9], sizeRequirements.minimum);
                sizeRequirements.preferred = Math.max(sizeRequirements.minimum, sizeRequirements.preferred);
                sizeRequirements.maximum = Math.max(sizeRequirements.preferred, sizeRequirements.maximum);
                ++n9;
            }
        }
        if ((long)(n5 = (int)view.getPreferredSpan(n2)) > l3) {
            SizeRequirements[] sizeRequirementsArray = new SizeRequirements[n4];
            int n10 = 0;
            while (n10 < n4) {
                sizeRequirementsArray[n10] = this.columnRequirements[n3 + n10];
                object = sizeRequirementsArray[n10];
                ++n10;
            }
            object = new int[n4];
            int[] nArray = new int[n4];
            SizeRequirements.calculateTiledPositions(n5, null, sizeRequirementsArray, nArray, object);
            int n11 = 0;
            while (n11 < n4) {
                SizeRequirements sizeRequirements = sizeRequirementsArray[n11];
                sizeRequirements.preferred = Math.max(object[n11], sizeRequirements.preferred);
                sizeRequirements.maximum = Math.max(sizeRequirements.preferred, sizeRequirements.maximum);
                ++n11;
            }
        }
    }

    protected View getViewAtPosition(int n2, Rectangle rectangle) {
        View view;
        int n3 = this.getViewCount();
        int n4 = 0;
        while (n4 < n3) {
            view = this.getView(n4);
            int n5 = view.getStartOffset();
            int n6 = view.getEndOffset();
            if (n2 >= n5 && n2 < n6) {
                if (rectangle != null) {
                    this.childAllocation(n4, rectangle);
                }
                return view;
            }
            ++n4;
        }
        if (n2 == this.getEndOffset()) {
            view = this.getView(n3 - 1);
            if (rectangle != null) {
                this.childAllocation(n3 - 1, rectangle);
            }
            return view;
        }
        return null;
    }

    static interface GridCell {
        public void setGridLocation(int var1, int var2);

        public int getGridRow();

        public int getGridColumn();

        public int getColumnCount();

        public int getRowCount();
    }

    public class TableCell
    extends BoxView
    implements GridCell {
        int row;
        int col;

        public TableCell(Element element) {
            super(element, 1);
        }

        public int getColumnCount() {
            return 1;
        }

        public int getRowCount() {
            return 1;
        }

        public void setGridLocation(int n2, int n3) {
            this.row = n2;
            this.col = n3;
        }

        public int getGridRow() {
            return this.row;
        }

        public int getGridColumn() {
            return this.col;
        }
    }

    public class TableRow
    extends BoxView {
        BitSet fillColumns;
        int row;

        public TableRow(Element element) {
            super(element, 0);
            this.fillColumns = new BitSet();
        }

        void clearFilledColumns() {
            this.fillColumns.and(EMPTY);
        }

        void fillColumn(int n2) {
            this.fillColumns.set(n2);
        }

        boolean isFilled(int n2) {
            return this.fillColumns.get(n2);
        }

        int getRow() {
            return this.row;
        }

        void setRow(int n2) {
            this.row = n2;
        }

        int getColumnCount() {
            int n2 = 0;
            int n3 = this.fillColumns.size();
            int n4 = 0;
            while (n4 < n3) {
                if (this.fillColumns.get(n4)) {
                    ++n2;
                }
                ++n4;
            }
            return this.getViewCount() + n2;
        }

        public void replace(int n2, int n3, View[] viewArray) {
            super.replace(n2, n3, viewArray);
            TableView.this.invalidateGrid();
        }

        protected void layoutMajorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
            int n4 = 0;
            int n5 = this.getViewCount();
            int n6 = 0;
            while (n6 < n5) {
                View view = this.getView(n6);
                while (this.isFilled(n4)) {
                    ++n4;
                }
                int n7 = TableView.this.getColumnsOccupied(view);
                nArray2[n6] = TableView.this.columnSpans[n4];
                nArray[n6] = TableView.this.columnOffsets[n4];
                if (n7 > 1) {
                    int n8 = TableView.this.columnSpans.length;
                    int n9 = 1;
                    while (n9 < n7) {
                        if (n4 + n9 < n8) {
                            int n10 = n6;
                            nArray2[n10] = nArray2[n10] + TableView.this.columnSpans[n4 + n9];
                        }
                        ++n9;
                    }
                    n4 += n7 - 1;
                }
                ++n6;
                ++n4;
            }
        }

        protected void layoutMinorAxis(int n2, int n3, int[] nArray, int[] nArray2) {
            super.layoutMinorAxis(n2, n3, nArray, nArray2);
            int n4 = 0;
            int n5 = this.getViewCount();
            int n6 = 0;
            while (n6 < n5) {
                View view = this.getView(n6);
                while (this.isFilled(n4)) {
                    ++n4;
                }
                int n7 = TableView.this.getColumnsOccupied(view);
                int n8 = TableView.this.getRowsOccupied(view);
                if (n8 > 1) {
                    int n9 = 1;
                    while (n9 < n8) {
                        int n10 = this.getRow() + n9;
                        if (n10 < TableView.this.getViewCount()) {
                            int n11 = TableView.this.getSpan(1, this.getRow() + n9);
                            int n12 = n6;
                            nArray2[n12] = nArray2[n12] + n11;
                        }
                        ++n9;
                    }
                }
                if (n7 > 1) {
                    n4 += n7 - 1;
                }
                ++n6;
                ++n4;
            }
        }

        public int getResizeWeight(int n2) {
            return 1;
        }

        protected View getViewAtPosition(int n2, Rectangle rectangle) {
            View view;
            int n3 = this.getViewCount();
            int n4 = 0;
            while (n4 < n3) {
                view = this.getView(n4);
                int n5 = view.getStartOffset();
                int n6 = view.getEndOffset();
                if (n2 >= n5 && n2 < n6) {
                    if (rectangle != null) {
                        this.childAllocation(n4, rectangle);
                    }
                    return view;
                }
                ++n4;
            }
            if (n2 == this.getEndOffset()) {
                view = this.getView(n3 - 1);
                if (rectangle != null) {
                    this.childAllocation(n3 - 1, rectangle);
                }
                return view;
            }
            return null;
        }
    }
}

