/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.table;

import java.io.Serializable;
import java.util.Vector;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;

public class DefaultTableModel
extends AbstractTableModel
implements Serializable {
    protected Vector dataVector;
    protected Vector columnIdentifiers;

    public DefaultTableModel() {
        this(0, 0);
    }

    private static Vector newVector(int n2) {
        Vector vector = new Vector(n2);
        vector.setSize(n2);
        return vector;
    }

    public DefaultTableModel(int n2, int n3) {
        this(DefaultTableModel.newVector(n3), n2);
    }

    public DefaultTableModel(Vector vector, int n2) {
        this.setDataVector(DefaultTableModel.newVector(n2), vector);
    }

    public DefaultTableModel(Object[] objectArray, int n2) {
        this(DefaultTableModel.convertToVector(objectArray), n2);
    }

    public DefaultTableModel(Vector vector, Vector vector2) {
        this.setDataVector(vector, vector2);
    }

    public DefaultTableModel(Object[][] objectArray, Object[] objectArray2) {
        this.setDataVector(objectArray, objectArray2);
    }

    public Vector getDataVector() {
        return this.dataVector;
    }

    private static Vector nonNullVector(Vector vector) {
        return vector != null ? vector : new Vector();
    }

    public void setDataVector(Vector vector, Vector vector2) {
        this.dataVector = DefaultTableModel.nonNullVector(vector);
        this.columnIdentifiers = DefaultTableModel.nonNullVector(vector2);
        this.justifyRows(0, this.getRowCount());
        this.fireTableStructureChanged();
    }

    public void setDataVector(Object[][] objectArray, Object[] objectArray2) {
        this.setDataVector(DefaultTableModel.convertToVector(objectArray), DefaultTableModel.convertToVector(objectArray2));
    }

    public void newDataAvailable(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }

    private void justifyRows(int n2, int n3) {
        this.dataVector.setSize(this.getRowCount());
        int n4 = n2;
        while (n4 < n3) {
            if (this.dataVector.elementAt(n4) == null) {
                this.dataVector.setElementAt(new Vector(), n4);
            }
            ((Vector)this.dataVector.elementAt(n4)).setSize(this.getColumnCount());
            ++n4;
        }
    }

    public void newRowsAdded(TableModelEvent tableModelEvent) {
        this.justifyRows(tableModelEvent.getFirstRow(), tableModelEvent.getLastRow() + 1);
        this.fireTableChanged(tableModelEvent);
    }

    public void rowsRemoved(TableModelEvent tableModelEvent) {
        this.fireTableChanged(tableModelEvent);
    }

    public void setNumRows(int n2) {
        int n3 = this.getRowCount();
        if (n3 == n2) {
            return;
        }
        this.dataVector.setSize(n2);
        if (n2 <= n3) {
            this.fireTableRowsDeleted(n2, n3 - 1);
        } else {
            this.justifyRows(n3, n2);
            this.fireTableRowsInserted(n3, n2 - 1);
        }
    }

    public void setRowCount(int n2) {
        this.setNumRows(n2);
    }

    public void addRow(Vector vector) {
        this.insertRow(this.getRowCount(), vector);
    }

    public void addRow(Object[] objectArray) {
        this.addRow(DefaultTableModel.convertToVector(objectArray));
    }

    public void insertRow(int n2, Vector vector) {
        this.dataVector.insertElementAt(vector, n2);
        this.justifyRows(n2, n2 + 1);
        this.fireTableRowsInserted(n2, n2);
    }

    public void insertRow(int n2, Object[] objectArray) {
        this.insertRow(n2, DefaultTableModel.convertToVector(objectArray));
    }

    private static int gcd(int n2, int n3) {
        return n3 == 0 ? n2 : DefaultTableModel.gcd(n3, n2 % n3);
    }

    private static void rotate(Vector vector, int n2, int n3, int n4) {
        int n5 = n3 - n2;
        int n6 = n5 - n4;
        int n7 = DefaultTableModel.gcd(n5, n6);
        int n8 = 0;
        while (n8 < n7) {
            int n9 = n8;
            Object object = vector.elementAt(n2 + n9);
            int n10 = (n9 + n6) % n5;
            while (n10 != n8) {
                vector.setElementAt(vector.elementAt(n2 + n10), n2 + n9);
                n9 = n10;
                n10 = (n9 + n6) % n5;
            }
            vector.setElementAt(object, n2 + n9);
            ++n8;
        }
    }

    public void moveRow(int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n4 - n2;
        if (n7 < 0) {
            n6 = n4;
            n5 = n3;
        } else {
            n6 = n2;
            n5 = n4 + n3 - n2;
        }
        DefaultTableModel.rotate(this.dataVector, n6, n5 + 1, n7);
        this.fireTableRowsUpdated(n6, n5);
    }

    public void removeRow(int n2) {
        this.dataVector.removeElementAt(n2);
        this.fireTableRowsDeleted(n2, n2);
    }

    public void setColumnIdentifiers(Vector vector) {
        this.setDataVector(this.dataVector, vector);
    }

    public void setColumnIdentifiers(Object[] objectArray) {
        this.setColumnIdentifiers(DefaultTableModel.convertToVector(objectArray));
    }

    public void setColumnCount(int n2) {
        this.columnIdentifiers.setSize(n2);
        this.justifyRows(0, this.getRowCount());
        this.fireTableStructureChanged();
    }

    public void addColumn(Object object) {
        this.addColumn(object, (Vector)null);
    }

    public void addColumn(Object object, Vector vector) {
        this.columnIdentifiers.addElement(object);
        if (vector != null) {
            int n2 = vector.size();
            if (n2 > this.getRowCount()) {
                this.dataVector.setSize(n2);
            }
            this.justifyRows(0, this.getRowCount());
            int n3 = this.getColumnCount() - 1;
            int n4 = 0;
            while (n4 < n2) {
                Vector vector2 = (Vector)this.dataVector.elementAt(n4);
                vector2.setElementAt(vector.elementAt(n4), n3);
                ++n4;
            }
        } else {
            this.justifyRows(0, this.getRowCount());
        }
        this.fireTableStructureChanged();
    }

    public void addColumn(Object object, Object[] objectArray) {
        this.addColumn(object, DefaultTableModel.convertToVector(objectArray));
    }

    public int getRowCount() {
        return this.dataVector.size();
    }

    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    public String getColumnName(int n2) {
        Object object = null;
        if (n2 < this.columnIdentifiers.size()) {
            object = this.columnIdentifiers.elementAt(n2);
        }
        return object == null ? super.getColumnName(n2) : object.toString();
    }

    public boolean isCellEditable(int n2, int n3) {
        return true;
    }

    public Object getValueAt(int n2, int n3) {
        Vector vector = (Vector)this.dataVector.elementAt(n2);
        return vector.elementAt(n3);
    }

    public void setValueAt(Object object, int n2, int n3) {
        Vector vector = (Vector)this.dataVector.elementAt(n2);
        vector.setElementAt(object, n3);
        this.fireTableCellUpdated(n2, n3);
    }

    protected static Vector convertToVector(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Vector vector = new Vector(objectArray.length);
        int n2 = 0;
        while (n2 < objectArray.length) {
            vector.addElement(objectArray[n2]);
            ++n2;
        }
        return vector;
    }

    protected static Vector convertToVector(Object[][] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Vector vector = new Vector(objectArray.length);
        int n2 = 0;
        while (n2 < objectArray.length) {
            vector.addElement(DefaultTableModel.convertToVector(objectArray[n2]));
            ++n2;
        }
        return vector;
    }
}

