/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JSplitPane;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneUI;

public class BasicSplitPaneDivider
extends Container
implements PropertyChangeListener {
    protected static final int ONE_TOUCH_SIZE = 6;
    protected static final int ONE_TOUCH_OFFSET = 2;
    protected DragController dragger;
    protected BasicSplitPaneUI splitPaneUI;
    protected int dividerSize = 0;
    protected Component hiddenDivider;
    protected JSplitPane splitPane;
    protected MouseHandler mouseHandler;
    protected int orientation;
    protected JButton leftButton;
    protected JButton rightButton;
    static final Cursor horizontalCursor = Cursor.getPredefinedCursor(11);
    static final Cursor verticalCursor = Cursor.getPredefinedCursor(9);
    static final Cursor defaultCursor = Cursor.getPredefinedCursor(0);
    private Border border;

    public BasicSplitPaneDivider(BasicSplitPaneUI basicSplitPaneUI) {
        this.setLayout(new DividerLayout());
        this.setBasicSplitPaneUI(basicSplitPaneUI);
        this.orientation = this.splitPane.getOrientation();
        this.setCursor(this.orientation == 1 ? horizontalCursor : verticalCursor);
        this.setBackground(UIManager.getColor("SplitPane.background"));
    }

    public void setBasicSplitPaneUI(BasicSplitPaneUI basicSplitPaneUI) {
        if (this.splitPane != null) {
            this.splitPane.removePropertyChangeListener(this);
            if (this.mouseHandler != null) {
                this.splitPane.removeMouseListener(this.mouseHandler);
                this.splitPane.removeMouseMotionListener(this.mouseHandler);
                this.removeMouseListener(this.mouseHandler);
                this.removeMouseMotionListener(this.mouseHandler);
                this.mouseHandler = null;
            }
        }
        this.splitPaneUI = basicSplitPaneUI;
        if (basicSplitPaneUI != null) {
            this.splitPane = basicSplitPaneUI.getSplitPane();
            if (this.splitPane != null) {
                if (this.mouseHandler == null) {
                    this.mouseHandler = new MouseHandler();
                }
                this.splitPane.addMouseListener(this.mouseHandler);
                this.splitPane.addMouseMotionListener(this.mouseHandler);
                this.addMouseListener(this.mouseHandler);
                this.addMouseMotionListener(this.mouseHandler);
                this.splitPane.addPropertyChangeListener(this);
                if (this.splitPane.isOneTouchExpandable()) {
                    this.oneTouchExpandableChanged();
                }
            }
        } else {
            this.splitPane = null;
        }
    }

    public BasicSplitPaneUI getBasicSplitPaneUI() {
        return this.splitPaneUI;
    }

    public void setDividerSize(int n2) {
        this.dividerSize = n2;
    }

    public int getDividerSize() {
        return this.dividerSize;
    }

    public void setBorder(Border border) {
        Border border2 = this.border;
        this.border = border;
    }

    public Border getBorder() {
        return this.border;
    }

    public Insets getInsets() {
        Border border = this.getBorder();
        if (border != null) {
            return border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    public Dimension getPreferredSize() {
        if (this.orientation == 1) {
            return new Dimension(this.getDividerSize(), 1);
        }
        return new Dimension(1, this.getDividerSize());
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.splitPane) {
            if (propertyChangeEvent.getPropertyName().equals("orientation")) {
                this.orientation = this.splitPane.getOrientation();
                this.setCursor(this.orientation == 1 ? horizontalCursor : verticalCursor);
                this.invalidate();
                this.validate();
            } else if (propertyChangeEvent.getPropertyName().equals("oneTouchExpandable")) {
                this.oneTouchExpandableChanged();
            }
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        Border border = this.getBorder();
        if (border != null) {
            Dimension dimension = this.getSize();
            border.paintBorder(this, graphics, 0, 0, dimension.width, dimension.height);
        }
    }

    protected void oneTouchExpandableChanged() {
        if (this.splitPane.isOneTouchExpandable() && this.leftButton == null && this.rightButton == null) {
            this.leftButton = this.createLeftOneTouchButton();
            if (this.leftButton != null) {
                this.leftButton.addActionListener(new OneTouchActionHandler(true));
            }
            this.rightButton = this.createRightOneTouchButton();
            if (this.rightButton != null) {
                this.rightButton.addActionListener(new OneTouchActionHandler(false));
            }
            if (this.leftButton != null && this.rightButton != null) {
                this.add(this.leftButton);
                this.add(this.rightButton);
            }
        }
        this.invalidate();
        this.validate();
    }

    protected JButton createLeftOneTouchButton() {
        JButton jButton = new JButton(){

            public void setBorder(Border border) {
            }

            public void paint(Graphics graphics) {
                if (BasicSplitPaneDivider.this.splitPane != null) {
                    int[] nArray = new int[3];
                    int[] nArray2 = new int[3];
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    graphics.setColor(Color.black);
                    if (BasicSplitPaneDivider.this.orientation == 0) {
                        int n2;
                        nArray[0] = n2 = Math.min(this.getHeight(), 6);
                        nArray[1] = 0;
                        nArray[2] = n2 << 1;
                        nArray2[0] = 0;
                        nArray2[1] = nArray2[2] = n2;
                        graphics.drawPolygon(nArray, nArray2, 3);
                    } else {
                        int n3;
                        nArray[0] = nArray[2] = (n3 = Math.min(this.getWidth(), 6));
                        nArray[1] = 0;
                        nArray2[0] = 0;
                        nArray2[1] = n3;
                        nArray2[2] = n3 << 1;
                    }
                    graphics.fillPolygon(nArray, nArray2, 3);
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        jButton.setMinimumSize(new Dimension(6, 6));
        jButton.setCursor(defaultCursor);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setRequestFocusEnabled(false);
        return jButton;
    }

    protected JButton createRightOneTouchButton() {
        JButton jButton = new JButton(){

            public void setBorder(Border border) {
            }

            public void paint(Graphics graphics) {
                if (BasicSplitPaneDivider.this.splitPane != null) {
                    int[] nArray = new int[3];
                    int[] nArray2 = new int[3];
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                    if (BasicSplitPaneDivider.this.orientation == 0) {
                        int n2;
                        nArray[0] = n2 = Math.min(this.getHeight(), 6);
                        nArray[1] = n2 << 1;
                        nArray[2] = 0;
                        nArray2[0] = n2;
                        nArray2[2] = 0;
                        nArray2[1] = 0;
                    } else {
                        int n3 = Math.min(this.getWidth(), 6);
                        nArray[2] = 0;
                        nArray[0] = 0;
                        nArray[1] = n3;
                        nArray2[0] = 0;
                        nArray2[1] = n3;
                        nArray2[2] = n3 << 1;
                    }
                    graphics.setColor(Color.black);
                    graphics.fillPolygon(nArray, nArray2, 3);
                }
            }

            public boolean isFocusTraversable() {
                return false;
            }
        };
        jButton.setMinimumSize(new Dimension(6, 6));
        jButton.setCursor(defaultCursor);
        jButton.setFocusPainted(false);
        jButton.setBorderPainted(false);
        jButton.setRequestFocusEnabled(false);
        return jButton;
    }

    protected void prepareForDragging() {
        this.splitPaneUI.startDragging();
    }

    protected void dragDividerTo(int n2) {
        this.splitPaneUI.dragDividerTo(n2);
    }

    protected void finishDraggingTo(int n2) {
        this.splitPaneUI.finishDraggingTo(n2);
    }

    private class OneTouchActionHandler
    implements ActionListener {
        private boolean toMinimum;

        OneTouchActionHandler(boolean bl2) {
            this.toMinimum = bl2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Insets insets = BasicSplitPaneDivider.this.splitPane.getInsets();
            int n2 = BasicSplitPaneDivider.this.splitPane.getLastDividerLocation();
            int n3 = BasicSplitPaneDivider.this.splitPaneUI.getDividerLocation(BasicSplitPaneDivider.this.splitPane);
            int n4 = this.toMinimum ? (BasicSplitPaneDivider.this.orientation == 0 ? (n3 >= BasicSplitPaneDivider.this.splitPane.getHeight() - insets.bottom - BasicSplitPaneDivider.this.getHeight() ? n2 : insets.top) : (n3 >= BasicSplitPaneDivider.this.splitPane.getWidth() - insets.right - BasicSplitPaneDivider.this.getWidth() ? n2 : insets.left)) : (BasicSplitPaneDivider.this.orientation == 0 ? (n3 == insets.top ? n2 : BasicSplitPaneDivider.this.splitPane.getHeight() - BasicSplitPaneDivider.this.getHeight() - insets.top) : (n3 == insets.left ? n2 : BasicSplitPaneDivider.this.splitPane.getWidth() - BasicSplitPaneDivider.this.getWidth() - insets.left));
            if (n3 != n4) {
                BasicSplitPaneDivider.this.splitPane.setDividerLocation(n4);
                BasicSplitPaneDivider.this.splitPane.setLastDividerLocation(n3);
            }
        }
    }

    protected class DividerLayout
    implements LayoutManager {
        protected DividerLayout() {
        }

        public void layoutContainer(Container container) {
            if (BasicSplitPaneDivider.this.leftButton != null && BasicSplitPaneDivider.this.rightButton != null && container == BasicSplitPaneDivider.this) {
                if (BasicSplitPaneDivider.this.splitPane.isOneTouchExpandable()) {
                    Insets insets = BasicSplitPaneDivider.this.getInsets();
                    if (BasicSplitPaneDivider.this.orientation == 0) {
                        int n2 = insets != null ? insets.left : 0;
                        int n3 = BasicSplitPaneDivider.this.getHeight();
                        if (insets != null) {
                            n3 -= insets.top + insets.bottom;
                            n3 = Math.max(n3, 0);
                        }
                        n3 = Math.min(n3, 6);
                        int n4 = (container.getSize().height - n3) / 2;
                        BasicSplitPaneDivider.this.leftButton.setBounds(n2 + 2, n4, n3 * 2, n3);
                        BasicSplitPaneDivider.this.rightButton.setBounds(n2 + 2 + 12, n4, n3 * 2, n3);
                    } else {
                        int n5 = insets != null ? insets.top : 0;
                        int n6 = BasicSplitPaneDivider.this.getWidth();
                        if (insets != null) {
                            n6 -= insets.left + insets.right;
                            n6 = Math.max(n6, 0);
                        }
                        n6 = Math.min(n6, 6);
                        int n7 = (container.getSize().width - n6) / 2;
                        BasicSplitPaneDivider.this.leftButton.setBounds(n7, n5 + 2, n6, n6 * 2);
                        BasicSplitPaneDivider.this.rightButton.setBounds(n7, n5 + 2 + 12, n6, n6 * 2);
                    }
                } else {
                    BasicSplitPaneDivider.this.leftButton.setBounds(-5, -5, 1, 1);
                    BasicSplitPaneDivider.this.rightButton.setBounds(-5, -5, 1, 1);
                }
            }
        }

        public Dimension minimumLayoutSize(Container container) {
            int n2;
            if (container != BasicSplitPaneDivider.this || BasicSplitPaneDivider.this.splitPane == null) {
                return new Dimension(0, 0);
            }
            Dimension dimension = null;
            if (BasicSplitPaneDivider.this.splitPane.isOneTouchExpandable() && BasicSplitPaneDivider.this.leftButton != null) {
                dimension = BasicSplitPaneDivider.this.leftButton.getMinimumSize();
            }
            Insets insets = BasicSplitPaneDivider.this.getInsets();
            int n3 = n2 = BasicSplitPaneDivider.this.getDividerSize();
            if (BasicSplitPaneDivider.this.orientation == 0) {
                if (dimension != null) {
                    int n4 = dimension.height;
                    if (insets != null) {
                        n4 += insets.top + insets.bottom;
                    }
                    n3 = Math.max(n3, n4);
                }
                n2 = 1;
            } else {
                if (dimension != null) {
                    int n5 = dimension.width;
                    if (insets != null) {
                        n5 += insets.left + insets.right;
                    }
                    n2 = Math.max(n2, n5);
                }
                n3 = 1;
            }
            return new Dimension(n2, n3);
        }

        public Dimension preferredLayoutSize(Container container) {
            return this.minimumLayoutSize(container);
        }

        public void removeLayoutComponent(Component component) {
        }

        public void addLayoutComponent(String string, Component component) {
        }
    }

    protected class VerticalDragController
    extends DragController {
        protected VerticalDragController(MouseEvent mouseEvent) {
            super(mouseEvent);
            JSplitPane jSplitPane = BasicSplitPaneDivider.this.splitPaneUI.getSplitPane();
            Component component = jSplitPane.getLeftComponent();
            Component component2 = jSplitPane.getRightComponent();
            this.initialX = BasicSplitPaneDivider.this.getLocation().y;
            this.offset = mouseEvent.getSource() == BasicSplitPaneDivider.this ? mouseEvent.getY() : mouseEvent.getY() - this.initialX;
            if (component == null || component2 == null || this.offset < -1 || this.offset > BasicSplitPaneDivider.this.getSize().height) {
                this.maxX = -1;
            } else {
                Insets insets = jSplitPane.getInsets();
                if (component.isVisible()) {
                    this.minX = component.getMinimumSize().height;
                    if (insets != null) {
                        this.minX += insets.top;
                    }
                } else {
                    this.minX = 0;
                }
                if (component2.isVisible()) {
                    int n2 = insets != null ? insets.bottom : 0;
                    this.maxX = Math.max(0, jSplitPane.getSize().height - (BasicSplitPaneDivider.this.getSize().height + n2) - component2.getMinimumSize().height);
                } else {
                    int n3 = insets != null ? insets.bottom : 0;
                    this.maxX = Math.max(0, jSplitPane.getSize().height - (BasicSplitPaneDivider.this.getSize().height + n3));
                }
                if (this.maxX < this.minX) {
                    this.maxX = 0;
                    this.minX = 0;
                }
            }
        }

        protected int getNeededLocation(int n2, int n3) {
            int n4 = Math.min(this.maxX, Math.max(this.minX, n3 - this.offset));
            return n4;
        }

        protected int positionForMouseEvent(MouseEvent mouseEvent) {
            int n2 = mouseEvent.getSource() == BasicSplitPaneDivider.this ? mouseEvent.getY() + BasicSplitPaneDivider.this.getLocation().y : mouseEvent.getY();
            n2 = Math.min(this.maxX, Math.max(this.minX, n2 - this.offset));
            return n2;
        }
    }

    protected class DragController {
        int initialX;
        int maxX;
        int minX;
        int offset;

        protected DragController(MouseEvent mouseEvent) {
            JSplitPane jSplitPane = BasicSplitPaneDivider.this.splitPaneUI.getSplitPane();
            Component component = jSplitPane.getLeftComponent();
            Component component2 = jSplitPane.getRightComponent();
            this.initialX = BasicSplitPaneDivider.this.getLocation().x;
            this.offset = mouseEvent.getSource() == BasicSplitPaneDivider.this ? mouseEvent.getX() : mouseEvent.getX() - this.initialX;
            if (component == null || component2 == null || this.offset < -1 || this.offset >= BasicSplitPaneDivider.this.getSize().width) {
                this.maxX = -1;
            } else {
                Insets insets = jSplitPane.getInsets();
                if (component.isVisible()) {
                    this.minX = component.getMinimumSize().width;
                    if (insets != null) {
                        this.minX += insets.left;
                    }
                } else {
                    this.minX = 0;
                }
                if (component2.isVisible()) {
                    int n2 = insets != null ? insets.right : 0;
                    this.maxX = Math.max(0, jSplitPane.getSize().width - (BasicSplitPaneDivider.this.getSize().width + n2) - component2.getMinimumSize().width);
                } else {
                    int n3 = insets != null ? insets.right : 0;
                    this.maxX = Math.max(0, jSplitPane.getSize().width - (BasicSplitPaneDivider.this.getSize().width + n3));
                }
                if (this.maxX < this.minX) {
                    this.maxX = 0;
                    this.minX = 0;
                }
            }
        }

        protected boolean isValid() {
            return this.maxX > 0;
        }

        protected int positionForMouseEvent(MouseEvent mouseEvent) {
            int n2 = mouseEvent.getSource() == BasicSplitPaneDivider.this ? mouseEvent.getX() + BasicSplitPaneDivider.this.getLocation().x : mouseEvent.getX();
            n2 = Math.min(this.maxX, Math.max(this.minX, n2 - this.offset));
            return n2;
        }

        protected int getNeededLocation(int n2, int n3) {
            int n4 = Math.min(this.maxX, Math.max(this.minX, n2 - this.offset));
            return n4;
        }

        protected void continueDrag(int n2, int n3) {
            BasicSplitPaneDivider.this.dragDividerTo(this.getNeededLocation(n2, n3));
        }

        protected void continueDrag(MouseEvent mouseEvent) {
            BasicSplitPaneDivider.this.dragDividerTo(this.positionForMouseEvent(mouseEvent));
        }

        protected void completeDrag(int n2, int n3) {
            BasicSplitPaneDivider.this.finishDraggingTo(this.getNeededLocation(n2, n3));
        }

        protected void completeDrag(MouseEvent mouseEvent) {
            BasicSplitPaneDivider.this.finishDraggingTo(this.positionForMouseEvent(mouseEvent));
        }
    }

    protected class MouseHandler
    extends MouseAdapter
    implements MouseMotionListener {
        protected MouseHandler() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if ((mouseEvent.getSource() == BasicSplitPaneDivider.this || mouseEvent.getSource() == BasicSplitPaneDivider.this.splitPane) && BasicSplitPaneDivider.this.dragger == null && BasicSplitPaneDivider.this.splitPane.isEnabled()) {
                Component component = BasicSplitPaneDivider.this.splitPaneUI.getNonContinuousLayoutDivider();
                if (BasicSplitPaneDivider.this.hiddenDivider != component) {
                    if (BasicSplitPaneDivider.this.hiddenDivider != null) {
                        BasicSplitPaneDivider.this.hiddenDivider.removeMouseListener(this);
                        BasicSplitPaneDivider.this.hiddenDivider.removeMouseMotionListener(this);
                    }
                    BasicSplitPaneDivider.this.hiddenDivider = component;
                    if (BasicSplitPaneDivider.this.hiddenDivider != null) {
                        BasicSplitPaneDivider.this.hiddenDivider.addMouseMotionListener(this);
                        BasicSplitPaneDivider.this.hiddenDivider.addMouseListener(this);
                    }
                }
                if (BasicSplitPaneDivider.this.splitPane.getLeftComponent() != null && BasicSplitPaneDivider.this.splitPane.getRightComponent() != null) {
                    BasicSplitPaneDivider.this.dragger = BasicSplitPaneDivider.this.orientation == 1 ? new DragController(mouseEvent) : new VerticalDragController(mouseEvent);
                    if (!BasicSplitPaneDivider.this.dragger.isValid()) {
                        BasicSplitPaneDivider.this.dragger = null;
                    } else {
                        BasicSplitPaneDivider.this.prepareForDragging();
                        BasicSplitPaneDivider.this.dragger.continueDrag(mouseEvent);
                    }
                }
                mouseEvent.consume();
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (BasicSplitPaneDivider.this.dragger != null) {
                if (mouseEvent.getSource() == BasicSplitPaneDivider.this.splitPane) {
                    BasicSplitPaneDivider.this.dragger.completeDrag(mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getSource() == BasicSplitPaneDivider.this) {
                    Point point = BasicSplitPaneDivider.this.getLocation();
                    BasicSplitPaneDivider.this.dragger.completeDrag(mouseEvent.getX() + point.x, mouseEvent.getY() + point.y);
                } else if (mouseEvent.getSource() == BasicSplitPaneDivider.this.hiddenDivider) {
                    Point point = BasicSplitPaneDivider.this.hiddenDivider.getLocation();
                    int n2 = mouseEvent.getX() + point.x;
                    int n3 = mouseEvent.getY() + point.y;
                    BasicSplitPaneDivider.this.dragger.completeDrag(n2, n3);
                }
                BasicSplitPaneDivider.this.dragger = null;
                mouseEvent.consume();
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            if (BasicSplitPaneDivider.this.dragger != null) {
                if (mouseEvent.getSource() == BasicSplitPaneDivider.this.splitPane) {
                    BasicSplitPaneDivider.this.dragger.continueDrag(mouseEvent.getX(), mouseEvent.getY());
                } else if (mouseEvent.getSource() == BasicSplitPaneDivider.this) {
                    Point point = BasicSplitPaneDivider.this.getLocation();
                    BasicSplitPaneDivider.this.dragger.continueDrag(mouseEvent.getX() + point.x, mouseEvent.getY() + point.y);
                } else if (mouseEvent.getSource() == BasicSplitPaneDivider.this.hiddenDivider) {
                    Point point = BasicSplitPaneDivider.this.hiddenDivider.getLocation();
                    int n2 = mouseEvent.getX() + point.x;
                    int n3 = mouseEvent.getY() + point.y;
                    BasicSplitPaneDivider.this.dragger.continueDrag(n2, n3);
                }
                mouseEvent.consume();
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }
    }
}

