/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ActionMapUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PopupMenuUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.basic.DefaultMenuLayout;

public class BasicPopupMenuUI
extends PopupMenuUI {
    protected JPopupMenu popupMenu = null;
    static MenuKeyboardHelper menuKeyboardHelper = null;
    private static transient MouseGrabber mouseGrabber = null;
    private transient PopupMenuListener basicPopupMenuListener = null;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicPopupMenuUI();
    }

    public void installUI(JComponent jComponent) {
        this.popupMenu = (JPopupMenu)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void installDefaults() {
        if (this.popupMenu.getLayout() == null || this.popupMenu.getLayout() instanceof UIResource) {
            this.popupMenu.setLayout(new DefaultMenuLayout(this.popupMenu, 1));
        }
        this.popupMenu.setFocusable(false);
        this.popupMenu.setOpaque(true);
        LookAndFeel.installBorder(this.popupMenu, "PopupMenu.border");
        LookAndFeel.installColorsAndFont(this.popupMenu, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
    }

    protected void installListeners() {
        if (mouseGrabber == null) {
            mouseGrabber = new MouseGrabber();
        }
        if (this.basicPopupMenuListener == null) {
            this.basicPopupMenuListener = this.createPopupMenuListener();
        }
        this.popupMenu.addPopupMenuListener(this.basicPopupMenuListener);
        if (menuKeyboardHelper == null) {
            menuKeyboardHelper = new MenuKeyboardHelper();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.addChangeListener(menuKeyboardHelper);
        }
    }

    protected void installKeyboardActions() {
    }

    static InputMap getInputMap(JPopupMenu jPopupMenu, JComponent jComponent) {
        ComponentInputMap componentInputMap = null;
        Object[] objectArray = (Object[])UIManager.get("PopupMenu.selectedWindowInputMapBindings");
        if (objectArray != null) {
            Object[] objectArray2;
            componentInputMap = LookAndFeel.makeComponentInputMap(jComponent, objectArray);
            if (!jPopupMenu.getComponentOrientation().isLeftToRight() && (objectArray2 = (Object[])UIManager.get("PopupMenu.selectedWindowInputMapBindings.RightToLeft")) != null) {
                ComponentInputMap componentInputMap2 = LookAndFeel.makeComponentInputMap(jComponent, objectArray2);
                ((InputMap)componentInputMap2).setParent(componentInputMap);
                componentInputMap = componentInputMap2;
            }
        }
        return componentInputMap;
    }

    static ActionMap getActionMap() {
        ActionMap actionMap = (ActionMap)UIManager.get("PopupMenu.actionMap");
        if (actionMap == null && (actionMap = BasicPopupMenuUI.createActionMap()) != null) {
            UIManager.getLookAndFeelDefaults().put("PopupMenu.actionMap", actionMap);
        }
        return actionMap;
    }

    static ActionMap createActionMap() {
        ActionMapUIResource actionMapUIResource = new ActionMapUIResource();
        BasicLookAndFeel basicLookAndFeel = (BasicLookAndFeel)UIManager.getLookAndFeel();
        ActionMap actionMap = basicLookAndFeel.getAudioActionMap();
        actionMapUIResource.setParent(actionMap);
        actionMapUIResource.put("cancel", new CancelAction());
        actionMapUIResource.put("selectNext", new SelectNextItemAction(SelectNextItemAction.FORWARD));
        actionMapUIResource.put("selectPrevious", new SelectNextItemAction(SelectNextItemAction.BACKWARD));
        actionMapUIResource.put("selectParent", new SelectParentItemAction());
        actionMapUIResource.put("selectChild", new SelectChildItemAction());
        actionMapUIResource.put("return", new ReturnAction());
        return actionMapUIResource;
    }

    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.popupMenu = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.popupMenu);
    }

    protected void uninstallListeners() {
        if (this.basicPopupMenuListener != null) {
            this.popupMenu.removePopupMenuListener(this.basicPopupMenuListener);
        }
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.popupMenu, null);
        SwingUtilities.replaceUIInputMap(this.popupMenu, 2, null);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return null;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent);
    }

    private static Window getWindow(Component component) {
        Component component2 = component;
        while (!(component2 instanceof Window) && component2 != null) {
            component2 = component2.getParent();
        }
        return (Window)component2;
    }

    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return mouseEvent.getID() == 502 && (mouseEvent.getModifiers() & 4) != 0;
    }

    private PopupMenuListener createPopupMenuListener() {
        return new BasicPopupMenuListener();
    }

    private static MenuElement nextEnabledChild(MenuElement[] menuElementArray, int n2) {
        int n3 = n2;
        int n4 = menuElementArray.length;
        while (n3 < n4) {
            Component component;
            if (menuElementArray[n3] != null && (component = menuElementArray[n3].getComponent()) != null && component.isEnabled()) {
                return menuElementArray[n3];
            }
            ++n3;
        }
        return null;
    }

    private static MenuElement previousEnabledChild(MenuElement[] menuElementArray, int n2) {
        int n3 = n2;
        while (n3 >= 0) {
            Component component;
            if (menuElementArray[n3] != null && (component = menuElementArray[n3].getComponent()) != null && component.isEnabled()) {
                return menuElementArray[n3];
            }
            --n3;
        }
        return null;
    }

    private static class MenuKeyboardHelper
    implements ChangeListener,
    KeyListener {
        private Component lastFocused = null;
        private MenuElement[] lastPathSelected = new MenuElement[0];
        private JPopupMenu lastPopup;
        private JRootPane invokerRootPane;
        private ActionMap menuActionMap = BasicPopupMenuUI.getActionMap();
        private InputMap menuInputMap;
        private boolean focusTraversalKeysEnabled;
        private boolean receivedKeyPressed = false;

        private MenuKeyboardHelper() {
        }

        JPopupMenu getActivePopup(MenuElement[] menuElementArray) {
            int n2 = menuElementArray.length - 1;
            while (n2 >= 0) {
                MenuElement menuElement = menuElementArray[n2];
                if (menuElement instanceof JPopupMenu) {
                    return (JPopupMenu)menuElement;
                }
                --n2;
            }
            return null;
        }

        void addUIInputMap(JComponent jComponent, InputMap inputMap) {
            InputMap inputMap2 = null;
            InputMap inputMap3 = jComponent.getInputMap(2);
            while (inputMap3 != null && !(inputMap3 instanceof UIResource)) {
                inputMap2 = inputMap3;
                inputMap3 = inputMap3.getParent();
            }
            if (inputMap2 == null) {
                jComponent.setInputMap(2, inputMap);
            } else {
                inputMap2.setParent(inputMap);
            }
            inputMap.setParent(inputMap3);
        }

        void addUIActionMap(JComponent jComponent, ActionMap actionMap) {
            ActionMap actionMap2 = null;
            ActionMap actionMap3 = jComponent.getActionMap();
            while (actionMap3 != null && !(actionMap3 instanceof UIResource)) {
                actionMap2 = actionMap3;
                actionMap3 = actionMap3.getParent();
            }
            if (actionMap2 == null) {
                jComponent.setActionMap(actionMap);
            } else {
                actionMap2.setParent(actionMap);
            }
            actionMap.setParent(actionMap3);
        }

        void removeUIInputMap(JComponent jComponent, InputMap inputMap) {
            InputMap inputMap2 = null;
            InputMap inputMap3 = jComponent.getInputMap(2);
            while (inputMap3 != null) {
                if (inputMap3 == inputMap) {
                    if (inputMap2 == null) {
                        jComponent.setInputMap(2, inputMap.getParent());
                        break;
                    }
                    inputMap2.setParent(inputMap.getParent());
                    break;
                }
                inputMap2 = inputMap3;
                inputMap3 = inputMap3.getParent();
            }
        }

        void removeUIActionMap(JComponent jComponent, ActionMap actionMap) {
            ActionMap actionMap2 = null;
            ActionMap actionMap3 = jComponent.getActionMap();
            while (actionMap3 != null) {
                if (actionMap3 == actionMap) {
                    if (actionMap2 == null) {
                        jComponent.setActionMap(actionMap.getParent());
                        break;
                    }
                    actionMap2.setParent(actionMap.getParent());
                    break;
                }
                actionMap2 = actionMap3;
                actionMap3 = actionMap3.getParent();
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MenuSelectionManager menuSelectionManager = (MenuSelectionManager)changeEvent.getSource();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            JPopupMenu jPopupMenu = this.getActivePopup(menuElementArray);
            if (jPopupMenu != null && jPopupMenu instanceof BasicComboPopup) {
                return;
            }
            if (this.lastPathSelected.length == 0 && menuElementArray.length != 0) {
                if (jPopupMenu == null) {
                    return;
                }
                Component component = jPopupMenu.getInvoker();
                while (!(component instanceof JComponent)) {
                    if (component == null) {
                        return;
                    }
                    component = component.getParent();
                }
                JComponent jComponent = (JComponent)component;
                this.lastFocused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                this.invokerRootPane = SwingUtilities.getRootPane(jComponent);
                if (this.invokerRootPane != null) {
                    this.invokerRootPane.requestFocus(true);
                    this.invokerRootPane.addKeyListener(menuKeyboardHelper);
                    this.focusTraversalKeysEnabled = this.invokerRootPane.getFocusTraversalKeysEnabled();
                    this.invokerRootPane.setFocusTraversalKeysEnabled(false);
                    this.menuInputMap = BasicPopupMenuUI.getInputMap(jPopupMenu, this.invokerRootPane);
                    this.addUIInputMap(this.invokerRootPane, this.menuInputMap);
                    this.addUIActionMap(this.invokerRootPane, this.menuActionMap);
                }
            } else if (this.lastPathSelected.length != 0 && menuElementArray.length == 0) {
                if (this.lastFocused != null) {
                    this.lastFocused.requestFocus();
                }
                if (this.invokerRootPane != null) {
                    this.invokerRootPane.removeKeyListener(menuKeyboardHelper);
                    this.invokerRootPane.setFocusTraversalKeysEnabled(this.focusTraversalKeysEnabled);
                    this.removeUIInputMap(this.invokerRootPane, this.menuInputMap);
                    this.removeUIActionMap(this.invokerRootPane, this.menuActionMap);
                }
                this.receivedKeyPressed = false;
            } else if (jPopupMenu != this.lastPopup) {
                this.receivedKeyPressed = false;
            }
            this.lastPathSelected = menuElementArray;
            this.lastPopup = jPopupMenu;
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.receivedKeyPressed = true;
            MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (this.receivedKeyPressed) {
                this.receivedKeyPressed = false;
                MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (this.receivedKeyPressed) {
                MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
            }
        }
    }

    private static class SelectChildItemAction
    extends AbstractAction {
        private SelectChildItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 0 && menuElementArray[menuElementArray.length - 1].getComponent().isEnabled() && menuElementArray[menuElementArray.length - 1].getComponent() instanceof JMenu && !((JMenu)menuElementArray[menuElementArray.length - 1].getComponent()).isTopLevelMenu()) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                menuElementArray2[menuElementArray.length] = ((JMenu)menuElementArray[menuElementArray.length - 1].getComponent()).getPopupMenu();
                MenuElement[] menuElementArray3 = menuElementArray2[menuElementArray.length].getSubElements();
                if (menuElementArray3.length > 0) {
                    menuElementArray2[menuElementArray.length + 1] = BasicPopupMenuUI.nextEnabledChild(menuElementArray3, 0);
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
                }
            } else if (menuElementArray.length > 0 && menuElementArray[0].getComponent() instanceof JMenuBar) {
                MenuElement[] menuElementArray4;
                MenuElement menuElement = null;
                JPopupMenu jPopupMenu = null;
                MenuElement menuElement2 = null;
                if (menuElementArray.length > 1) {
                    menuElementArray4 = menuElementArray[0].getSubElements();
                    int n2 = 0;
                    int n3 = menuElementArray4.length;
                    while (n2 < n3) {
                        if (menuElementArray4[n2] == menuElementArray[1] && (menuElement = BasicPopupMenuUI.nextEnabledChild(menuElementArray4, n2 + 1)) == null) {
                            menuElement = BasicPopupMenuUI.nextEnabledChild(menuElementArray4, 0);
                        }
                        ++n2;
                    }
                }
                if (menuElement != null) {
                    jPopupMenu = ((JMenu)menuElement).getPopupMenu();
                    if (((JMenu)menuElement).isTopLevelMenu()) {
                        menuElement2 = null;
                    } else {
                        menuElementArray4 = jPopupMenu.getSubElements();
                        if (menuElementArray4.length > 0) {
                            menuElement2 = BasicPopupMenuUI.nextEnabledChild(menuElementArray4, 0);
                        }
                    }
                    MenuElement[] menuElementArray5 = menuElement2 != null ? new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu, menuElement2} : new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu};
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray5);
                }
            }
        }
    }

    private static class SelectParentItemAction
    extends AbstractAction {
        private SelectParentItemAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 3 && menuElementArray[menuElementArray.length - 3].getComponent() instanceof JMenu && !((JMenu)menuElementArray[menuElementArray.length - 3].getComponent()).isTopLevelMenu()) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            } else if (menuElementArray.length > 0 && menuElementArray[0].getComponent() instanceof JMenuBar) {
                MenuElement[] menuElementArray3;
                MenuElement menuElement = null;
                JPopupMenu jPopupMenu = null;
                MenuElement menuElement2 = null;
                if (menuElementArray.length > 1) {
                    menuElementArray3 = menuElementArray[0].getSubElements();
                    int n2 = 0;
                    int n3 = menuElementArray3.length;
                    while (n2 < n3) {
                        if (menuElementArray3[n2] == menuElementArray[1] && (menuElement = BasicPopupMenuUI.previousEnabledChild(menuElementArray3, n2 - 1)) == null) {
                            menuElement = BasicPopupMenuUI.previousEnabledChild(menuElementArray3, menuElementArray3.length - 1);
                        }
                        ++n2;
                    }
                }
                if (menuElement != null) {
                    jPopupMenu = ((JMenu)menuElement).getPopupMenu();
                    if (((JMenu)menuElement).isTopLevelMenu()) {
                        menuElement2 = null;
                    } else {
                        menuElementArray3 = jPopupMenu.getSubElements();
                        if (menuElementArray3.length > 0) {
                            menuElement2 = BasicPopupMenuUI.nextEnabledChild(menuElementArray3, 0);
                        }
                    }
                    MenuElement[] menuElementArray4 = menuElement2 != null ? new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu, menuElement2} : new MenuElement[]{menuElementArray[0], menuElement, jPopupMenu};
                    MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray4);
                }
            }
        }
    }

    private static class SelectNextItemAction
    extends AbstractAction {
        static int FORWARD = 1;
        static int BACKWARD = 2;
        int direction;

        SelectNextItemAction(int n2) {
            this.direction = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 1) {
                MenuElement menuElement = menuElementArray[menuElementArray.length - 2];
                if (menuElement.getComponent() instanceof JMenu) {
                    menuElement = menuElementArray[menuElementArray.length - 1];
                    MenuElement[] menuElementArray2 = menuElement.getSubElements();
                    if (menuElementArray2.length > 0) {
                        MenuElement menuElement2;
                        MenuElement menuElement3 = menuElement2 = this.direction == FORWARD ? BasicPopupMenuUI.nextEnabledChild(menuElementArray2, 0) : BasicPopupMenuUI.previousEnabledChild(menuElementArray2, menuElementArray2.length - 1);
                        if (menuElement2 != null) {
                            MenuElement[] menuElementArray3 = new MenuElement[menuElementArray.length + 1];
                            System.arraycopy(menuElementArray, 0, menuElementArray3, 0, menuElementArray.length);
                            menuElementArray3[menuElementArray.length] = menuElement2;
                            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray3);
                        }
                    }
                } else {
                    MenuElement[] menuElementArray4 = menuElement.getSubElements();
                    MenuElement menuElement4 = null;
                    int n2 = 0;
                    while (n2 < menuElementArray4.length) {
                        if (menuElementArray4[n2] == menuElementArray[menuElementArray.length - 1]) {
                            menuElement4 = this.direction == FORWARD ? BasicPopupMenuUI.nextEnabledChild(menuElementArray4, n2 + 1) : BasicPopupMenuUI.previousEnabledChild(menuElementArray4, n2 - 1);
                            break;
                        }
                        ++n2;
                    }
                    if (menuElement4 == null) {
                        MenuElement menuElement5 = menuElement4 = this.direction == FORWARD ? BasicPopupMenuUI.nextEnabledChild(menuElementArray4, 0) : BasicPopupMenuUI.previousEnabledChild(menuElementArray4, menuElementArray4.length - 1);
                    }
                    if (menuElement4 != null) {
                        menuElementArray[menuElementArray.length - 1] = menuElement4;
                        MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                    }
                }
            }
        }
    }

    private static class ReturnAction
    extends AbstractAction {
        private ReturnAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length > 0) {
                MenuElement menuElement = menuElementArray[menuElementArray.length - 1];
                if (menuElement instanceof JMenu) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                    menuElementArray2[menuElementArray.length] = ((JMenu)menuElement).getPopupMenu();
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                } else if (menuElement instanceof JMenuItem) {
                    JMenuItem jMenuItem = (JMenuItem)menuElement;
                    if (jMenuItem.getUI() instanceof BasicMenuItemUI) {
                        ((BasicMenuItemUI)jMenuItem.getUI()).doClick(menuSelectionManager);
                    } else {
                        menuSelectionManager.clearSelectedPath();
                        jMenuItem.doClick(0);
                    }
                }
            }
        }
    }

    private static class CancelAction
    extends AbstractAction {
        private CancelAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray.length > 4) {
                MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length - 2];
                System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length - 2);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray2);
            } else {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
        }
    }

    private class BasicPopupMenuListener
    implements PopupMenuListener {
        private BasicPopupMenuListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            Action action;
            JPopupMenu jPopupMenu = (JPopupMenu)popupMenuEvent.getSource();
            ActionMap actionMap = jPopupMenu.getActionMap();
            if (actionMap != null && (action = actionMap.get("PopupMenu.popupSound")) != null) {
                BasicLookAndFeel basicLookAndFeel = (BasicLookAndFeel)UIManager.getLookAndFeel();
                basicLookAndFeel.playSound(action);
            }
        }
    }

    private static class MouseGrabber
    implements MouseListener,
    MouseMotionListener,
    MouseWheelListener,
    WindowListener,
    ComponentListener,
    ChangeListener {
        Vector grabbed = new Vector();
        MenuElement lastGrabbed = null;
        boolean lastGrabbedMenuBarChild = false;
        MenuElement[] lastPathSelected = new MenuElement[0];

        public MouseGrabber() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.addChangeListener(this);
        }

        private void requestAddGrab(Component component) {
            Window window = BasicPopupMenuUI.getWindow(component);
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            Component component2 = null;
            int n2 = 0;
            while (component2 == null && n2 < menuElementArray.length) {
                if (menuElementArray[n2] instanceof JPopupMenu) {
                    component2 = menuElementArray[n2].getComponent();
                }
                ++n2;
            }
            this.grabContainer(window, component2);
        }

        private void requestRemoveGrab() {
            this.ungrabContainers();
        }

        void cancelPopupMenu() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (this.lastGrabbed == this.getFirstPopup()) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                this.ungrabContainers();
            } else {
                this.lastGrabbed = this.getFirstPopup();
                this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (this.lastPathSelected.length == 0 && menuElementArray.length != 0) {
                Component component = menuElementArray[0].getComponent();
                if (component instanceof JPopupMenu) {
                    component = ((JPopupMenu)component).getInvoker();
                }
                this.requestAddGrab(component);
            }
            if (this.lastPathSelected.length != 0 && menuElementArray.length == 0) {
                this.requestRemoveGrab();
            }
            if (menuElementArray != null && menuElementArray.length > 2 && menuElementArray[0] instanceof JMenuBar && this.lastGrabbedMenuBarChild && this.lastGrabbed != this.getFirstPopup()) {
                this.lastGrabbed = this.getFirstPopup();
                this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            }
            this.lastPathSelected = menuElementArray;
        }

        private MenuElement getFirstPopup() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            MenuElement menuElement = null;
            int n2 = 0;
            while (menuElement == null && n2 < menuElementArray.length) {
                if (menuElementArray[n2] instanceof JPopupMenu) {
                    menuElement = menuElementArray[n2];
                }
                ++n2;
            }
            return menuElement;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void grabContainer(Container container, Component component) {
            if (container == component) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            this.lastGrabbed = this.getFirstPopup();
            this.lastGrabbedMenuBarChild = menuElementArray[0] instanceof JMenuBar;
            if (container instanceof Window) {
                ((Window)container).addWindowListener(this);
                ((Window)container).addComponentListener(this);
                this.grabbed.addElement(container);
            }
            Object object = container.getTreeLock();
            synchronized (object) {
                int n2 = container.getComponentCount();
                Component[] componentArray = container.getComponents();
                int n3 = 0;
                while (n3 < n2) {
                    Component component2 = componentArray[n3];
                    if (component2.isVisible()) {
                        component2.addMouseListener(this);
                        component2.addMouseMotionListener(this);
                        component2.addMouseWheelListener(this);
                        this.grabbed.addElement(component2);
                        if (component2 instanceof Container) {
                            Container container2 = (Container)component2;
                            this.grabContainer(container2, component);
                        }
                    }
                    ++n3;
                }
            }
        }

        void ungrabContainers() {
            int n2 = 0;
            int n3 = this.grabbed.size();
            while (n2 < n3) {
                Component component = (Component)this.grabbed.elementAt(n2);
                if (component instanceof Window) {
                    ((Window)component).removeWindowListener(this);
                    ((Window)component).removeComponentListener(this);
                } else {
                    component.removeMouseListener(this);
                    component.removeMouseMotionListener(this);
                    component.removeMouseWheelListener(this);
                }
                ++n2;
            }
            this.grabbed = new Vector();
            this.lastGrabbed = null;
            this.lastGrabbedMenuBarChild = false;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Component component = (Component)mouseEvent.getSource();
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            this.cancelPopupMenu();
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mouseMoved(MouseEvent mouseEvent) {
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
        }

        public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
            this.cancelPopupMenu();
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowClosed(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowIconified(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }
}

