/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class DeflaterOutputStream
extends FilterOutputStream {
    protected Deflater def;
    protected byte[] buf;
    private boolean usesDefaultDeflater = false;

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater, int n2) {
        super(outputStream);
        if (outputStream == null || deflater == null) {
            throw new NullPointerException();
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("buffer size <= 0");
        }
        this.def = deflater;
        this.buf = new byte[n2];
    }

    public DeflaterOutputStream(OutputStream outputStream, Deflater deflater) {
        this(outputStream, deflater, 512);
    }

    public DeflaterOutputStream(OutputStream outputStream) {
        this(outputStream, new Deflater());
        this.usesDefaultDeflater = true;
    }

    public void write(int n2) throws IOException {
        byte[] byArray = new byte[]{(byte)(n2 & 0xFF)};
        this.write(byArray, 0, 1);
    }

    public void write(byte[] byArray, int n2, int n3) throws IOException {
        if (this.def.finished()) {
            throw new IOException("write beyond end of stream");
        }
        if ((n2 | n3 | n2 + n3 | byArray.length - (n2 + n3)) < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (n3 == 0) {
            return;
        }
        if (!this.def.finished()) {
            this.def.setInput(byArray, n2, n3);
            while (!this.def.needsInput()) {
                this.deflate();
            }
        }
    }

    public void finish() throws IOException {
        if (!this.def.finished()) {
            this.def.finish();
            while (!this.def.finished()) {
                this.deflate();
            }
        }
    }

    public void close() throws IOException {
        this.finish();
        if (this.usesDefaultDeflater) {
            this.def.end();
        }
        this.out.close();
    }

    protected void deflate() throws IOException {
        int n2 = this.def.deflate(this.buf, 0, this.buf.length);
        if (n2 > 0) {
            this.out.write(this.buf, 0, n2);
        }
    }
}

