/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.logging.Level;

public class LogRecord
implements Serializable {
    private static long globalSequenceNumber;
    private static int nextThreadId;
    private static ThreadLocal threadIds;
    private Level level;
    private long sequenceNumber;
    private String sourceClassName;
    private String sourceMethodName;
    private String message;
    private int threadID;
    private long millis;
    private Throwable thrown;
    private String loggerName;
    private String resourceBundleName;
    private transient boolean needToInferCaller;
    private transient Object[] parameters;
    private transient ResourceBundle resourceBundle;
    static /* synthetic */ Class class$java$util$logging$LogRecord;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRecord(Level level, String string) {
        level.getClass();
        this.level = level;
        this.message = string;
        Class clazz = class$java$util$logging$LogRecord == null ? (class$java$util$logging$LogRecord = LogRecord.class$("java.util.logging.LogRecord")) : class$java$util$logging$LogRecord;
        synchronized (clazz) {
            this.sequenceNumber = globalSequenceNumber++;
            Integer n2 = (Integer)threadIds.get();
            if (n2 == null) {
                n2 = new Integer(nextThreadId++);
                threadIds.set(n2);
            }
            this.threadID = n2;
        }
        this.millis = System.currentTimeMillis();
        this.needToInferCaller = true;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public void setLoggerName(String string) {
        this.loggerName = string;
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String getResourceBundleName() {
        return this.resourceBundleName;
    }

    public void setResourceBundleName(String string) {
        this.resourceBundleName = string;
    }

    public Level getLevel() {
        return this.level;
    }

    public void setLevel(Level level) {
        if (level == null) {
            throw new NullPointerException();
        }
        this.level = level;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(long l2) {
        this.sequenceNumber = l2;
    }

    public String getSourceClassName() {
        if (this.needToInferCaller) {
            this.inferCaller();
        }
        return this.sourceClassName;
    }

    public void setSourceClassName(String string) {
        this.sourceClassName = string;
        this.needToInferCaller = false;
    }

    public String getSourceMethodName() {
        if (this.needToInferCaller) {
            this.inferCaller();
        }
        return this.sourceMethodName;
    }

    public void setSourceMethodName(String string) {
        this.sourceMethodName = string;
        this.needToInferCaller = false;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] objectArray) {
        this.parameters = objectArray;
    }

    public int getThreadID() {
        return this.threadID;
    }

    public void setThreadID(int n2) {
        this.threadID = n2;
    }

    public long getMillis() {
        return this.millis;
    }

    public void setMillis(long l2) {
        this.millis = l2;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public void setThrown(Throwable throwable) {
        this.thrown = throwable;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeByte(1);
        objectOutputStream.writeByte(0);
        if (this.parameters == null) {
            objectOutputStream.writeInt(-1);
            return;
        }
        objectOutputStream.writeInt(this.parameters.length);
        int n2 = 0;
        while (n2 < this.parameters.length) {
            if (this.parameters[n2] == null) {
                objectOutputStream.writeObject(null);
            } else {
                objectOutputStream.writeObject(this.parameters[n2].toString());
            }
            ++n2;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        byte by = objectInputStream.readByte();
        byte by2 = objectInputStream.readByte();
        if (by != 1) {
            throw new IOException("LogRecord: bad version: " + by + "." + by2);
        }
        int n2 = objectInputStream.readInt();
        if (n2 == -1) {
            this.parameters = null;
        } else {
            this.parameters = new Object[n2];
            int n3 = 0;
            while (n3 < this.parameters.length) {
                this.parameters[n3] = objectInputStream.readObject();
                ++n3;
            }
        }
        if (this.resourceBundleName != null) {
            try {
                this.resourceBundle = ResourceBundle.getBundle(this.resourceBundleName);
            }
            catch (MissingResourceException missingResourceException) {
                this.resourceBundle = null;
            }
        }
        this.needToInferCaller = false;
    }

    private void inferCaller() {
        String string;
        StackTraceElement stackTraceElement;
        this.needToInferCaller = false;
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        int n2 = 0;
        while (n2 < stackTraceElementArray.length) {
            stackTraceElement = stackTraceElementArray[n2];
            string = stackTraceElement.getClassName();
            if (string.equals("java.util.logging.Logger")) break;
            ++n2;
        }
        while (n2 < stackTraceElementArray.length) {
            stackTraceElement = stackTraceElementArray[n2];
            string = stackTraceElement.getClassName();
            if (!string.equals("java.util.logging.Logger")) {
                this.setSourceClassName(string);
                this.setSourceMethodName(stackTraceElement.getMethodName());
                return;
            }
            ++n2;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        nextThreadId = 10;
        threadIds = new ThreadLocal();
    }
}

