/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.Serializable;
import java.security.AllPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PermissionsEnumerator;
import java.security.PermissionsHash;
import java.security.UnresolvedPermission;
import java.security.UnresolvedPermissionCollection;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class Permissions
extends PermissionCollection
implements Serializable {
    private Hashtable perms = new Hashtable(11);
    private PermissionCollection allPermission = null;
    static /* synthetic */ Class class$java$security$UnresolvedPermission;

    public void add(Permission permission) {
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly Permissions object");
        }
        PermissionCollection permissionCollection = this.getPermissionCollection(permission);
        permissionCollection.add(permission);
        if (permission instanceof AllPermission) {
            this.allPermission = permissionCollection;
        }
    }

    public boolean implies(Permission permission) {
        PermissionCollection permissionCollection = this.getPermissionCollection(permission);
        if (this.allPermission != null && this.allPermission.implies(permission)) {
            return true;
        }
        return permissionCollection.implies(permission);
    }

    public Enumeration elements() {
        return new PermissionsEnumerator(this.perms.elements());
    }

    private Enumeration elements(Permission permission) {
        PermissionCollection permissionCollection = this.getPermissionCollection(permission);
        return permissionCollection.elements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PermissionCollection getPermissionCollection(Permission permission) {
        Class clazz = permission.getClass();
        PermissionCollection permissionCollection = null;
        Hashtable hashtable = this.perms;
        synchronized (hashtable) {
            permissionCollection = (PermissionCollection)this.perms.get(clazz);
            if (permissionCollection == null && (permissionCollection = this.getUnresolvedPermissions(permission)) == null && (permissionCollection = permission.newPermissionCollection()) == null) {
                permissionCollection = new PermissionsHash();
            }
            this.perms.put(clazz, permissionCollection);
        }
        return permissionCollection;
    }

    private PermissionCollection getUnresolvedPermissions(Permission permission) {
        UnresolvedPermissionCollection unresolvedPermissionCollection = (UnresolvedPermissionCollection)this.perms.get(class$java$security$UnresolvedPermission == null ? (class$java$security$UnresolvedPermission = Permissions.class$("java.security.UnresolvedPermission")) : class$java$security$UnresolvedPermission);
        if (unresolvedPermissionCollection == null) {
            return null;
        }
        Vector vector = unresolvedPermissionCollection.getUnresolvedPermissions(permission);
        if (vector == null) {
            return null;
        }
        Certificate[] certificateArray = null;
        Object[] objectArray = permission.getClass().getSigners();
        int n2 = 0;
        if (objectArray != null) {
            int n3 = 0;
            while (n3 < objectArray.length) {
                if (objectArray[n3] instanceof Certificate) {
                    ++n2;
                }
                ++n3;
            }
            certificateArray = new Certificate[n2];
            n2 = 0;
            int n4 = 0;
            while (n4 < objectArray.length) {
                if (objectArray[n4] instanceof Certificate) {
                    certificateArray[n2++] = (Certificate)objectArray[n4];
                }
                ++n4;
            }
        }
        PermissionCollection permissionCollection = null;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            UnresolvedPermission unresolvedPermission = (UnresolvedPermission)enumeration.nextElement();
            Permission permission2 = unresolvedPermission.resolve(permission, certificateArray);
            if (permission2 == null) continue;
            if (permissionCollection == null && (permissionCollection = permission.newPermissionCollection()) == null) {
                permissionCollection = new PermissionsHash();
            }
            permissionCollection.add(permission2);
        }
        return permissionCollection;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

