/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.LookupTable;

public class ByteLookupTable
extends LookupTable {
    byte[][] data;

    public ByteLookupTable(int n2, byte[][] byArray) {
        super(n2, byArray.length);
        this.numComponents = byArray.length;
        this.numEntries = byArray[0].length;
        this.data = new byte[this.numComponents][];
        int n3 = 0;
        while (n3 < this.numComponents) {
            this.data[n3] = byArray[n3];
            ++n3;
        }
    }

    public ByteLookupTable(int n2, byte[] byArray) {
        super(n2, byArray.length);
        this.numComponents = 1;
        this.numEntries = byArray.length;
        this.data = new byte[1][];
        this.data[0] = byArray;
    }

    public final byte[][] getTable() {
        return this.data;
    }

    public int[] lookupPixel(int[] nArray, int[] nArray2) {
        if (nArray2 == null) {
            nArray2 = new int[nArray.length];
        }
        if (this.numComponents == 1) {
            int n2 = 0;
            while (n2 < nArray.length) {
                int n3 = nArray[n2] - this.offset;
                if (n3 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + n2 + "]-offset is " + "less than zero");
                }
                nArray2[n2] = this.data[0][n3];
                ++n2;
            }
        } else {
            int n4 = 0;
            while (n4 < nArray.length) {
                int n5 = nArray[n4] - this.offset;
                if (n5 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + n4 + "]-offset is " + "less than zero");
                }
                nArray2[n4] = this.data[n4][n5];
                ++n4;
            }
        }
        return nArray2;
    }

    public byte[] lookupPixel(byte[] byArray, byte[] byArray2) {
        if (byArray2 == null) {
            byArray2 = new byte[byArray.length];
        }
        if (this.numComponents == 1) {
            int n2 = 0;
            while (n2 < byArray.length) {
                int n3 = (byArray[n2] & 0xFF) - this.offset;
                if (n3 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + n2 + "]-offset is " + "less than zero");
                }
                byArray2[n2] = this.data[0][n3];
                ++n2;
            }
        } else {
            int n4 = 0;
            while (n4 < byArray.length) {
                int n5 = (byArray[n4] & 0xFF) - this.offset;
                if (n5 < 0) {
                    throw new ArrayIndexOutOfBoundsException("src[" + n4 + "]-offset is " + "less than zero");
                }
                byArray2[n4] = this.data[n4][n5];
                ++n4;
            }
        }
        return byArray2;
    }
}

