/*
 * Decompiled with CFR 0.152.
 */
package java.awt.geom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.QuadIterator;
import java.awt.geom.Rectangle2D;

public abstract class QuadCurve2D
implements Shape,
Cloneable {
    private static final int BELOW = -2;
    private static final int LOWEDGE = -1;
    private static final int INSIDE = 0;
    private static final int HIGHEDGE = 1;
    private static final int ABOVE = 2;

    protected QuadCurve2D() {
    }

    public abstract double getX1();

    public abstract double getY1();

    public abstract Point2D getP1();

    public abstract double getCtrlX();

    public abstract double getCtrlY();

    public abstract Point2D getCtrlPt();

    public abstract double getX2();

    public abstract double getY2();

    public abstract Point2D getP2();

    public abstract void setCurve(double var1, double var3, double var5, double var7, double var9, double var11);

    public void setCurve(double[] dArray, int n2) {
        this.setCurve(dArray[n2 + 0], dArray[n2 + 1], dArray[n2 + 2], dArray[n2 + 3], dArray[n2 + 4], dArray[n2 + 5]);
    }

    public void setCurve(Point2D point2D, Point2D point2D2, Point2D point2D3) {
        this.setCurve(point2D.getX(), point2D.getY(), point2D2.getX(), point2D2.getY(), point2D3.getX(), point2D3.getY());
    }

    public void setCurve(Point2D[] point2DArray, int n2) {
        this.setCurve(point2DArray[n2 + 0].getX(), point2DArray[n2 + 0].getY(), point2DArray[n2 + 1].getX(), point2DArray[n2 + 1].getY(), point2DArray[n2 + 2].getX(), point2DArray[n2 + 2].getY());
    }

    public void setCurve(QuadCurve2D quadCurve2D) {
        this.setCurve(quadCurve2D.getX1(), quadCurve2D.getY1(), quadCurve2D.getCtrlX(), quadCurve2D.getCtrlY(), quadCurve2D.getX2(), quadCurve2D.getY2());
    }

    public static double getFlatnessSq(double d2, double d3, double d4, double d5, double d6, double d7) {
        return Line2D.ptSegDistSq(d2, d3, d6, d7, d4, d5);
    }

    public static double getFlatness(double d2, double d3, double d4, double d5, double d6, double d7) {
        return Line2D.ptSegDist(d2, d3, d6, d7, d4, d5);
    }

    public static double getFlatnessSq(double[] dArray, int n2) {
        return Line2D.ptSegDistSq(dArray[n2 + 0], dArray[n2 + 1], dArray[n2 + 4], dArray[n2 + 5], dArray[n2 + 2], dArray[n2 + 3]);
    }

    public static double getFlatness(double[] dArray, int n2) {
        return Line2D.ptSegDist(dArray[n2 + 0], dArray[n2 + 1], dArray[n2 + 4], dArray[n2 + 5], dArray[n2 + 2], dArray[n2 + 3]);
    }

    public double getFlatnessSq() {
        return Line2D.ptSegDistSq(this.getX1(), this.getY1(), this.getX2(), this.getY2(), this.getCtrlX(), this.getCtrlY());
    }

    public double getFlatness() {
        return Line2D.ptSegDist(this.getX1(), this.getY1(), this.getX2(), this.getY2(), this.getCtrlX(), this.getCtrlY());
    }

    public void subdivide(QuadCurve2D quadCurve2D, QuadCurve2D quadCurve2D2) {
        QuadCurve2D.subdivide(this, quadCurve2D, quadCurve2D2);
    }

    public static void subdivide(QuadCurve2D quadCurve2D, QuadCurve2D quadCurve2D2, QuadCurve2D quadCurve2D3) {
        double d2 = quadCurve2D.getX1();
        double d3 = quadCurve2D.getY1();
        double d4 = quadCurve2D.getCtrlX();
        double d5 = quadCurve2D.getCtrlY();
        double d6 = quadCurve2D.getX2();
        double d7 = quadCurve2D.getY2();
        double d8 = (d2 + d4) / 2.0;
        double d9 = (d3 + d5) / 2.0;
        double d10 = (d6 + d4) / 2.0;
        double d11 = (d7 + d5) / 2.0;
        d4 = (d8 + d10) / 2.0;
        d5 = (d9 + d11) / 2.0;
        if (quadCurve2D2 != null) {
            quadCurve2D2.setCurve(d2, d3, d8, d9, d4, d5);
        }
        if (quadCurve2D3 != null) {
            quadCurve2D3.setCurve(d4, d5, d10, d11, d6, d7);
        }
    }

    public static void subdivide(double[] dArray, int n2, double[] dArray2, int n3, double[] dArray3, int n4) {
        double d2 = dArray[n2 + 0];
        double d3 = dArray[n2 + 1];
        double d4 = dArray[n2 + 2];
        double d5 = dArray[n2 + 3];
        double d6 = dArray[n2 + 4];
        double d7 = dArray[n2 + 5];
        if (dArray2 != null) {
            dArray2[n3 + 0] = d2;
            dArray2[n3 + 1] = d3;
        }
        if (dArray3 != null) {
            dArray3[n4 + 4] = d6;
            dArray3[n4 + 5] = d7;
        }
        d2 = (d2 + d4) / 2.0;
        d3 = (d3 + d5) / 2.0;
        d6 = (d6 + d4) / 2.0;
        d7 = (d7 + d5) / 2.0;
        d4 = (d2 + d6) / 2.0;
        d5 = (d3 + d7) / 2.0;
        if (dArray2 != null) {
            dArray2[n3 + 2] = d2;
            dArray2[n3 + 3] = d3;
            dArray2[n3 + 4] = d4;
            dArray2[n3 + 5] = d5;
        }
        if (dArray3 != null) {
            dArray3[n4 + 0] = d4;
            dArray3[n4 + 1] = d5;
            dArray3[n4 + 2] = d6;
            dArray3[n4 + 3] = d7;
        }
    }

    public static int solveQuadratic(double[] dArray) {
        return QuadCurve2D.solveQuadratic(dArray, dArray);
    }

    public static int solveQuadratic(double[] dArray, double[] dArray2) {
        double d2 = dArray[2];
        double d3 = dArray[1];
        double d4 = dArray[0];
        int n2 = 0;
        if (d2 == 0.0) {
            if (d3 == 0.0) {
                return -1;
            }
            dArray2[n2++] = -d4 / d3;
        } else {
            double d5 = d3 * d3 - 4.0 * d2 * d4;
            if (d5 < 0.0) {
                return 0;
            }
            d5 = Math.sqrt(d5);
            if (d3 < 0.0) {
                d5 = -d5;
            }
            double d6 = (d3 + d5) / -2.0;
            dArray2[n2++] = d6 / d2;
            if (d6 != 0.0) {
                dArray2[n2++] = d4 / d6;
            }
        }
        return n2;
    }

    public boolean contains(double d2, double d3) {
        int n2 = 0;
        double d4 = this.getX1();
        double d5 = this.getY1();
        double d6 = this.getX2();
        double d7 = this.getY2();
        double d8 = d7 - d5;
        if ((d8 > 0.0 && d3 >= d5 && d3 <= d7 || d8 < 0.0 && d3 <= d5 && d3 >= d7) && d2 <= d4 + (d3 - d5) * (d6 - d4) / d8) {
            ++n2;
        }
        double d9 = this.getCtrlX();
        double d10 = this.getCtrlY();
        boolean bl2 = (d7 - d5) * (d10 - d5) >= 0.0;
        boolean bl3 = (d5 - d7) * (d10 - d7) >= 0.0;
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        QuadCurve2D.fillEqn(dArray, d3, d5, d10, d7);
        int n3 = QuadCurve2D.solveQuadratic(dArray, dArray2);
        n3 = QuadCurve2D.evalQuadratic(dArray2, n3, bl2, bl3, dArray, d4, d9, d6);
        while (--n3 >= 0) {
            if (!(d2 < dArray2[n3])) continue;
            ++n2;
        }
        return (n2 & 1) == 1;
    }

    public boolean contains(Point2D point2D) {
        return this.contains(point2D.getX(), point2D.getY());
    }

    private static void fillEqn(double[] dArray, double d2, double d3, double d4, double d5) {
        dArray[0] = d3 - d2;
        dArray[1] = d4 + d4 - d3 - d3;
        dArray[2] = d3 - d4 - d4 + d5;
    }

    private static int evalQuadratic(double[] dArray, int n2, boolean bl2, boolean bl3, double[] dArray2, double d2, double d3, double d4) {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            double d5 = dArray[n4];
            if ((bl2 ? d5 >= 0.0 : d5 > 0.0) && (bl3 ? d5 <= 1.0 : d5 < 1.0) && (dArray2 == null || dArray2[1] + 2.0 * dArray2[2] * d5 != 0.0)) {
                double d6 = 1.0 - d5;
                dArray[n3++] = d2 * d6 * d6 + 2.0 * d3 * d5 * d6 + d4 * d5 * d5;
            }
            ++n4;
        }
        return n3;
    }

    private static int getTag(double d2, double d3, double d4) {
        if (d2 <= d3) {
            return d2 < d3 ? -2 : -1;
        }
        if (d2 >= d4) {
            return d2 > d4 ? 2 : 1;
        }
        return 0;
    }

    private static boolean inwards(int n2, int n3, int n4) {
        switch (n2) {
            default: {
                return false;
            }
            case -1: {
                return n3 >= 0 || n4 >= 0;
            }
            case 0: {
                return true;
            }
            case 1: 
        }
        return n3 <= 0 || n4 <= 0;
    }

    public boolean intersects(double d2, double d3, double d4, double d5) {
        int n2;
        boolean bl2;
        if (d4 < 0.0 || d5 < 0.0) {
            return false;
        }
        double d6 = this.getX1();
        double d7 = this.getY1();
        int n3 = QuadCurve2D.getTag(d6, d2, d2 + d4);
        int n4 = QuadCurve2D.getTag(d7, d3, d3 + d5);
        if (n3 == 0 && n4 == 0) {
            return true;
        }
        double d8 = this.getX2();
        double d9 = this.getY2();
        int n5 = QuadCurve2D.getTag(d8, d2, d2 + d4);
        int n6 = QuadCurve2D.getTag(d9, d3, d3 + d5);
        if (n5 == 0 && n6 == 0) {
            return true;
        }
        double d10 = this.getCtrlX();
        double d11 = this.getCtrlY();
        int n7 = QuadCurve2D.getTag(d10, d2, d2 + d4);
        int n8 = QuadCurve2D.getTag(d11, d3, d3 + d5);
        if (n3 < 0 && n5 < 0 && n7 < 0) {
            return false;
        }
        if (n4 < 0 && n6 < 0 && n8 < 0) {
            return false;
        }
        if (n3 > 0 && n5 > 0 && n7 > 0) {
            return false;
        }
        if (n4 > 0 && n6 > 0 && n8 > 0) {
            return false;
        }
        if (QuadCurve2D.inwards(n3, n5, n7) && QuadCurve2D.inwards(n4, n6, n8)) {
            return true;
        }
        if (QuadCurve2D.inwards(n5, n3, n7) && QuadCurve2D.inwards(n6, n4, n8)) {
            return true;
        }
        boolean bl3 = n3 * n5 <= 0;
        boolean bl4 = bl2 = n4 * n6 <= 0;
        if (n3 == 0 && n5 == 0 && bl2) {
            return true;
        }
        if (n4 == 0 && n6 == 0 && bl3) {
            return true;
        }
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        if (!bl2) {
            QuadCurve2D.fillEqn(dArray, n4 < 0 ? d3 : d3 + d5, d7, d11, d9);
            return QuadCurve2D.solveQuadratic(dArray, dArray2) == 2 && QuadCurve2D.evalQuadratic(dArray2, 2, true, true, null, d6, d10, d8) == 2 && QuadCurve2D.getTag(dArray2[0], d2, d2 + d4) * QuadCurve2D.getTag(dArray2[1], d2, d2 + d4) <= 0;
        }
        if (!bl3) {
            QuadCurve2D.fillEqn(dArray, n3 < 0 ? d2 : d2 + d4, d6, d10, d8);
            return QuadCurve2D.solveQuadratic(dArray, dArray2) == 2 && QuadCurve2D.evalQuadratic(dArray2, 2, true, true, null, d7, d11, d9) == 2 && QuadCurve2D.getTag(dArray2[0], d3, d3 + d5) * QuadCurve2D.getTag(dArray2[1], d3, d3 + d5) <= 0;
        }
        double d12 = d8 - d6;
        double d13 = d9 - d7;
        double d14 = d9 * d6 - d8 * d7;
        int n9 = n4 == 0 ? n3 : QuadCurve2D.getTag((d14 + d12 * (n4 < 0 ? d3 : d3 + d5)) / d13, d2, d2 + d4);
        if (n9 * (n2 = n6 == 0 ? n5 : QuadCurve2D.getTag((d14 + d12 * (n6 < 0 ? d3 : d3 + d5)) / d13, d2, d2 + d4)) <= 0) {
            return true;
        }
        n9 = n9 * n3 <= 0 ? n4 : n6;
        QuadCurve2D.fillEqn(dArray, n2 < 0 ? d2 : d2 + d4, d6, d10, d8);
        int n10 = QuadCurve2D.solveQuadratic(dArray, dArray2);
        QuadCurve2D.evalQuadratic(dArray2, n10, true, true, null, d7, d11, d9);
        n2 = QuadCurve2D.getTag(dArray2[0], d3, d3 + d5);
        return n9 * n2 <= 0;
    }

    public boolean intersects(Rectangle2D rectangle2D) {
        return this.intersects(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public boolean contains(double d2, double d3, double d4, double d5) {
        return this.contains(d2, d3) && this.contains(d2 + d4, d3) && this.contains(d2 + d4, d3 + d5) && this.contains(d2, d3 + d5);
    }

    public boolean contains(Rectangle2D rectangle2D) {
        return this.contains(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public PathIterator getPathIterator(AffineTransform affineTransform) {
        return new QuadIterator(this, affineTransform);
    }

    public PathIterator getPathIterator(AffineTransform affineTransform, double d2) {
        return new FlatteningPathIterator(this.getPathIterator(affineTransform), d2);
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public static class Double
    extends QuadCurve2D {
        public double x1;
        public double y1;
        public double ctrlx;
        public double ctrly;
        public double x2;
        public double y2;

        public Double() {
        }

        public Double(double d2, double d3, double d4, double d5, double d6, double d7) {
            this.setCurve(d2, d3, d4, d5, d6, d7);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Double(this.x1, this.y1);
        }

        public double getCtrlX() {
            return this.ctrlx;
        }

        public double getCtrlY() {
            return this.ctrly;
        }

        public Point2D getCtrlPt() {
            return new Point2D.Double(this.ctrlx, this.ctrly);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Double(this.x2, this.y2);
        }

        public void setCurve(double d2, double d3, double d4, double d5, double d6, double d7) {
            this.x1 = d2;
            this.y1 = d3;
            this.ctrlx = d4;
            this.ctrly = d5;
            this.x2 = d6;
            this.y2 = d7;
        }

        public Rectangle2D getBounds2D() {
            double d2 = Math.min(Math.min(this.x1, this.x2), this.ctrlx);
            double d3 = Math.min(Math.min(this.y1, this.y2), this.ctrly);
            double d4 = Math.max(Math.max(this.x1, this.x2), this.ctrlx);
            double d5 = Math.max(Math.max(this.y1, this.y2), this.ctrly);
            return new Rectangle2D.Double(d2, d3, d4 - d2, d5 - d3);
        }
    }

    public static class Float
    extends QuadCurve2D {
        public float x1;
        public float y1;
        public float ctrlx;
        public float ctrly;
        public float x2;
        public float y2;

        public Float() {
        }

        public Float(float f2, float f3, float f4, float f5, float f6, float f7) {
            this.setCurve(f2, f3, f4, f5, f6, f7);
        }

        public double getX1() {
            return this.x1;
        }

        public double getY1() {
            return this.y1;
        }

        public Point2D getP1() {
            return new Point2D.Float(this.x1, this.y1);
        }

        public double getCtrlX() {
            return this.ctrlx;
        }

        public double getCtrlY() {
            return this.ctrly;
        }

        public Point2D getCtrlPt() {
            return new Point2D.Float(this.ctrlx, this.ctrly);
        }

        public double getX2() {
            return this.x2;
        }

        public double getY2() {
            return this.y2;
        }

        public Point2D getP2() {
            return new Point2D.Float(this.x2, this.y2);
        }

        public void setCurve(double d2, double d3, double d4, double d5, double d6, double d7) {
            this.x1 = (float)d2;
            this.y1 = (float)d3;
            this.ctrlx = (float)d4;
            this.ctrly = (float)d5;
            this.x2 = (float)d6;
            this.y2 = (float)d7;
        }

        public void setCurve(float f2, float f3, float f4, float f5, float f6, float f7) {
            this.x1 = f2;
            this.y1 = f3;
            this.ctrlx = f4;
            this.ctrly = f5;
            this.x2 = f6;
            this.y2 = f7;
        }

        public Rectangle2D getBounds2D() {
            float f2 = Math.min(Math.min(this.x1, this.x2), this.ctrlx);
            float f3 = Math.min(Math.min(this.y1, this.y2), this.ctrly);
            float f4 = Math.max(Math.max(this.x1, this.x2), this.ctrlx);
            float f5 = Math.max(Math.max(this.y1, this.y2), this.ctrly);
            return new Rectangle2D.Float(f2, f3, f4 - f2, f5 - f3);
        }
    }
}

