/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.auth.callback;

import com.sun.security.auth.callback.TextCallbackHandler;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackInputStream;
import java.util.Arrays;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextOutputCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class TextCallbackHandler
implements CallbackHandler {
    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        ConfirmationCallback confirmationCallback = null;
        int n2 = 0;
        while (n2 < callbackArray.length) {
            String string;
            Callback callback;
            if (callbackArray[n2] instanceof TextOutputCallback) {
                callback = (TextOutputCallback)callbackArray[n2];
                switch (((TextOutputCallback)callback).getMessageType()) {
                    case 0: {
                        string = "";
                        break;
                    }
                    case 1: {
                        string = "Warning: ";
                        break;
                    }
                    case 2: {
                        string = "Error: ";
                        break;
                    }
                    default: {
                        throw new UnsupportedCallbackException(callbackArray[n2], "Unrecognized message type");
                    }
                }
                String string2 = ((TextOutputCallback)callback).getMessage();
                if (string2 != null) {
                    string = string + string2;
                }
                if (string != null) {
                    System.err.println(string);
                }
            } else if (callbackArray[n2] instanceof NameCallback) {
                callback = (NameCallback)callbackArray[n2];
                if (((NameCallback)callback).getDefaultName() == null) {
                    System.err.print(((NameCallback)callback).getPrompt());
                } else {
                    System.err.print(((NameCallback)callback).getPrompt() + " [" + ((NameCallback)callback).getDefaultName() + "] ");
                }
                System.err.flush();
                string = this.readLine();
                if (string.equals("")) {
                    string = ((NameCallback)callback).getDefaultName();
                }
                ((NameCallback)callback).setName(string);
            } else if (callbackArray[n2] instanceof PasswordCallback) {
                callback = (PasswordCallback)callbackArray[n2];
                System.err.print(((PasswordCallback)callback).getPrompt());
                System.err.flush();
                ((PasswordCallback)callback).setPassword(this.readPassword(System.in));
            } else if (callbackArray[n2] instanceof ConfirmationCallback) {
                confirmationCallback = (ConfirmationCallback)callbackArray[n2];
            } else {
                throw new UnsupportedCallbackException(callbackArray[n2], "Unrecognized Callback");
            }
            ++n2;
        }
        if (confirmationCallback != null) {
            this.doConfirmation(confirmationCallback);
        }
    }

    private String readLine() throws IOException {
        return new BufferedReader(new InputStreamReader(System.in)).readLine();
    }

    private char[] readPassword(InputStream inputStream) throws IOException {
        char[] cArray;
        char[] cArray2 = cArray = new char[128];
        int n2 = cArray2.length;
        int n3 = 0;
        boolean bl2 = false;
        while (!bl2) {
            int n4 = inputStream.read();
            switch (n4) {
                case -1: 
                case 10: {
                    bl2 = true;
                    break;
                }
                case 13: {
                    int n5 = inputStream.read();
                    if (n5 != 10 && n5 != -1) {
                        if (!(inputStream instanceof PushbackInputStream)) {
                            inputStream = new PushbackInputStream(inputStream);
                        }
                        ((PushbackInputStream)inputStream).unread(n5);
                    } else {
                        bl2 = true;
                        break;
                    }
                }
                default: {
                    if (--n2 < 0) {
                        cArray2 = new char[n3 + 128];
                        n2 = cArray2.length - n3 - 1;
                        System.arraycopy(cArray, 0, cArray2, 0, n3);
                        Arrays.fill(cArray, ' ');
                        cArray = cArray2;
                    }
                    cArray2[n3++] = (char)n4;
                }
            }
        }
        if (n3 == 0) {
            return null;
        }
        char[] cArray3 = new char[n3];
        System.arraycopy(cArray2, 0, cArray3, 0, n3);
        Arrays.fill(cArray2, ' ');
        return cArray3;
    }

    private void doConfirmation(ConfirmationCallback confirmationCallback) throws IOException, UnsupportedCallbackException {
        int n2;
        class OptionInfo {
            String name;
            int value;
            private final /* synthetic */ TextCallbackHandler this$0;

            OptionInfo(TextCallbackHandler textCallbackHandler, String string, int n2) {
                this.this$0 = textCallbackHandler;
                this.name = string;
                this.value = n2;
            }
        }
        OptionInfo[] optionInfoArray;
        String string;
        int n3 = confirmationCallback.getMessageType();
        switch (n3) {
            case 1: {
                string = "Warning: ";
                break;
            }
            case 2: {
                string = "Error: ";
                break;
            }
            case 0: {
                string = "";
                break;
            }
            default: {
                throw new UnsupportedCallbackException(confirmationCallback, "Unrecognized message type: " + n3);
            }
        }
        int n4 = confirmationCallback.getOptionType();
        switch (n4) {
            case 0: {
                optionInfoArray = new OptionInfo[]{new OptionInfo(this, "Yes", 0), new OptionInfo(this, "No", 1)};
                break;
            }
            case 1: {
                optionInfoArray = new OptionInfo[]{new OptionInfo(this, "Yes", 0), new OptionInfo(this, "No", 1), new OptionInfo(this, "Cancel", 2)};
                break;
            }
            case 2: {
                optionInfoArray = new OptionInfo[]{new OptionInfo(this, "OK", 3), new OptionInfo(this, "Cancel", 2)};
                break;
            }
            case -1: {
                String[] stringArray = confirmationCallback.getOptions();
                optionInfoArray = new OptionInfo[stringArray.length];
                int n5 = 0;
                while (n5 < optionInfoArray.length) {
                    optionInfoArray[n5].value = n5;
                    ++n5;
                }
                break;
            }
            default: {
                throw new UnsupportedCallbackException(confirmationCallback, "Unrecognized option type: " + n4);
            }
        }
        int n6 = confirmationCallback.getDefaultOption();
        String string2 = confirmationCallback.getPrompt();
        if (string2 == null) {
            string2 = "";
        }
        if (!(string2 = string + string2).equals("")) {
            System.err.println(string2);
        }
        int n7 = 0;
        while (n7 < optionInfoArray.length) {
            if (n4 == -1) {
                System.err.println(n7 + ". " + optionInfoArray[n7].name + (n7 == n6 ? " [default]" : ""));
            } else {
                System.err.println(n7 + ". " + optionInfoArray[n7].name + (optionInfoArray[n7].value == n6 ? " [default]" : ""));
            }
            ++n7;
        }
        System.err.print("Enter a number: ");
        System.err.flush();
        try {
            n2 = Integer.parseInt(this.readLine());
            if (n2 < 0 || n2 > optionInfoArray.length - 1) {
                n2 = n6;
            }
            n2 = optionInfoArray[n2].value;
        }
        catch (NumberFormatException numberFormatException) {
            n2 = n6;
        }
        confirmationCallback.setSelectedIndex(n2);
    }
}

