/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.sound;

import com.sun.media.sound.AbstractDataLine;
import com.sun.media.sound.AbstractMixer;
import com.sun.media.sound.HeadspaceMixer;
import com.sun.media.sound.Platform;
import com.sun.media.sound.Printer;
import com.sun.media.sound.Toolkit;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.BooleanControl;
import javax.sound.sampled.Clip;
import javax.sound.sampled.Control;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineUnavailableException;

public class MixerClip
extends AbstractDataLine
implements Clip {
    private int id;
    private long waveformId;
    private int frameLength = -1;
    private long microsecondLength = -1L;
    int position = 0;
    int loopCount = 0;
    int currentLoop = 0;
    int loopStart;
    int loopEnd;
    private boolean resettingFramePosition = false;
    private boolean stopping = false;
    MixerClipSampleRateControl rateControl;
    MixerClipGainControl gainControl;
    MixerClipMuteControl muteControl;
    MixerClipPanControl panControl;

    MixerClip(DataLine.Info info, HeadspaceMixer headspaceMixer, AudioFormat audioFormat, int n2) throws LineUnavailableException {
        super(info, headspaceMixer, new Control[4], audioFormat, n2);
        if (Printer.trace) {
            Printer.trace("> MixerClip: constructor: format: " + audioFormat + " bufferSize: " + n2);
        }
        this.gainControl = new MixerClipGainControl();
        this.controls[0] = this.gainControl;
        this.muteControl = new MixerClipMuteControl();
        this.controls[1] = this.muteControl;
        this.panControl = new MixerClipPanControl();
        this.controls[2] = this.panControl;
        this.rateControl = new MixerClipSampleRateControl();
        this.controls[3] = this.rateControl;
        if (Printer.trace) {
            Printer.trace("< MixerClip: constructor completed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(AudioFormat audioFormat, byte[] byArray, int n2, int n3) throws LineUnavailableException {
        AbstractMixer abstractMixer = this.mixer;
        synchronized (abstractMixer) {
            if (!this.isOpen()) {
                this.mixer.open(this, audioFormat, n3);
                try {
                    this.implOpen(audioFormat, byArray, n2, n3);
                    this.setOpen(true);
                }
                catch (LineUnavailableException lineUnavailableException) {
                    this.mixer.close(this);
                    throw lineUnavailableException;
                }
            } else {
                throw new IllegalStateException("Line is already open with " + this.getBufferSize() + " bytes of " + this.getFormat() + " data");
            }
        }
    }

    public void open(AudioInputStream audioInputStream) throws LineUnavailableException, IOException {
        byte[] byArray;
        int n2 = (int)audioInputStream.getFrameLength();
        int n3 = n2 * audioInputStream.getFormat().getFrameSize();
        if (Printer.debug) {
            Printer.debug("HeadspaceMixer: getClip: lengthInFrames: " + n2);
        }
        int n4 = (int)(0.015f * audioInputStream.getFormat().getFrameRate()) * audioInputStream.getFormat().getFrameSize();
        if (Printer.debug) {
            Printer.debug("HeadspaceMixer: getClip: Bytes for 15ms: " + n4);
        }
        if (n2 != -1) {
            int n5 = n3;
            if (n3 < n4) {
                n5 = n4;
            }
            byArray = new byte[n5];
            int n6 = n3;
            int n7 = 0;
            while (n6 > 0) {
                int n8 = audioInputStream.read(byArray, n7, n6);
                if (n8 > 0) {
                    n7 += n8;
                    n6 -= n8;
                    continue;
                }
                if (n8 != 0) break;
                Thread.yield();
            }
            if (audioInputStream.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED) && audioInputStream.getFormat().getSampleSizeInBits() == 8) {
                int n9 = n7;
                while (n9 < n5) {
                    byArray[n9] = -128;
                    ++n9;
                }
            }
            if (n7 != n3) {
                n3 = n7;
                n2 = n7 / audioInputStream.getFormat().getFrameSize();
            }
        } else {
            n3 = 0;
            int n10 = 0;
            int n11 = 2048;
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            byte[] byArray2 = new byte[n11];
            while (true) {
                if ((n10 = audioInputStream.read(byArray2, 0, byArray2.length)) == -1) {
                    if (n3 != 0) break;
                    throw new IOException("No data found in stream");
                }
                dataOutputStream.write(byArray2, 0, n10);
                n3 += n10;
                Thread.currentThread();
                Thread.yield();
            }
            if (n3 < n4) {
                int n12;
                boolean bl2 = audioInputStream.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED) && audioInputStream.getFormat().getSampleSizeInBits() == 8;
                int n13 = 0;
                if (audioInputStream.getFormat().getEncoding().equals(AudioFormat.Encoding.PCM_UNSIGNED) && audioInputStream.getFormat().getSampleSizeInBits() == 8) {
                    n13 = -128;
                }
                if ((n12 = n4 - n3) > byArray2.length) {
                    n12 = byArray2.length;
                }
                int n14 = 0;
                while (n14 < n12) {
                    byArray2[n14] = n13;
                    ++n14;
                }
                dataOutputStream.write(byArray2, 0, n12);
            }
            byArray = byteArrayOutputStream.toByteArray();
            n2 = byArray.length / audioInputStream.getFormat().getFrameSize();
            if (Printer.debug) {
                Printer.debug("Read to end of stream.  lengthInBytes: " + n3 + " streamData.length: " + byArray.length + " lengthInFrames: " + n2);
            }
        }
        this.open(audioInputStream.getFormat(), byArray, 0, byArray.length);
    }

    public int getFrameLength() {
        return this.frameLength;
    }

    public long getMicrosecondLength() {
        return this.microsecondLength;
    }

    public synchronized void setFramePosition(int n2) {
        if (Printer.trace) {
            Printer.trace("> MixerClip: setFramePosition: " + n2);
        }
        int n3 = this.bufferSize / this.format.getFrameSize();
        if (Printer.debug) {
            Printer.debug("    MixerClip: bufferSize: " + this.bufferSize + " lengthInFrames: " + n3);
        }
        if (Printer.debug) {
            Printer.debug("    getFramePosition(): " + this.getFramePosition());
        }
        if (!this.isStartedRunning() && n2 == this.position) {
            return;
        }
        this.resettingFramePosition = true;
        boolean bl2 = this.isStartedRunning();
        if (this.id != 0) {
            this.implStop();
        }
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 > n3) {
            n2 = n3;
        }
        this.position = n2;
        if (this.loopStart < this.position) {
            if (Printer.debug) {
                Printer.debug("Adjusting loopStart to new position value " + this.position);
            }
            this.loopStart = this.position;
        }
        if (this.loopEnd < this.position) {
            if (Printer.debug) {
                Printer.debug("Adjusting loopEnd to end of sample " + n3);
            }
            this.loopStart = n3;
        }
        if (bl2) {
            this.implStart();
        }
        this.resettingFramePosition = false;
        if (Printer.trace) {
            Printer.trace("< MixerClip: setFramePosition: set position to " + this.position);
        }
    }

    public synchronized void setMicrosecondPosition(long l2) {
        if (Printer.trace) {
            Printer.trace("> MixerClip: setMicrosecondPosition: " + l2);
        }
        int n2 = (int)((double)((float)l2 * this.getFormat().getFrameRate()) / 1000000.0);
        if (Printer.debug) {
            Printer.debug("    frame rate: " + this.format.getFrameRate());
        }
        if (Printer.debug) {
            Printer.debug("    frames: " + n2);
        }
        this.setFramePosition(n2);
    }

    public void setLoopPoints(int n2, int n3) {
        if (Printer.trace) {
            Printer.trace("> MixerClip: setLoopPoints: start: " + n2 + " end: " + n3);
        }
        int n4 = this.bufferSize / this.format.getFrameSize();
        if (Printer.debug) {
            Printer.debug("    > MixerClip: setLoopPoints: lengthInFrames: " + n4);
        }
        if (n2 < 0) {
            n2 = 0;
        }
        if (n3 > n4) {
            n3 = n4;
        }
        if (n3 == -1) {
            n3 = n4;
        }
        if (n3 < n2) {
            throw new IllegalArgumentException("End position " + n3 + "  preceeds start position " + n2);
        }
        if (n2 < this.position) {
            if (Printer.debug) {
                Printer.debug("Adjusting start to new position value " + this.position);
            }
            n2 = this.position;
        }
        if (n3 < this.position) {
            if (Printer.debug) {
                Printer.debug("Adjusting end to end of sample " + n4);
            }
            n3 = n4;
        }
        this.loopStart = n2;
        this.loopEnd = n3;
        if (Printer.trace) {
            Printer.trace("< MixerClip: setLoopPoints completed: loopStart: " + this.loopStart + " loopEnd: " + this.loopEnd);
        }
    }

    public void loop(int n2) {
        if (n2 != 0) {
            this.stop();
        }
        this.loopCount = n2;
        this.start();
    }

    void implOpen(AudioFormat audioFormat, int n2) throws LineUnavailableException {
        throw new IllegalArgumentException("Illegal call to open() in interface Clip");
    }

    void implOpen(AudioFormat audioFormat, byte[] byArray, int n2, int n3) throws LineUnavailableException {
        this.rateControl.update(audioFormat.getFrameRate());
        boolean bl2 = false;
        boolean bl3 = false;
        if (audioFormat.getSampleSizeInBits() == 8 && audioFormat.getEncoding() == AudioFormat.Encoding.PCM_SIGNED) {
            bl2 = true;
        }
        if (audioFormat.getSampleSizeInBits() > 8 && audioFormat.isBigEndian() != Platform.isBigEndian()) {
            bl3 = true;
        }
        if (bl2) {
            Toolkit.getUnsigned8(byArray, n2, n3);
        } else if (bl3) {
            Toolkit.getByteSwapped(byArray, n2, n3);
        }
        int n4 = n3 / audioFormat.getFrameSize();
        HeadspaceMixer cfr_ignored_0 = (HeadspaceMixer)this.mixer;
        if (n4 > 0x100000) {
            throw new LineUnavailableException("Failed to allocate clip data: Requested buffer too large.");
        }
        this.waveformId = this.nOpen(audioFormat.getSampleSizeInBits(), audioFormat.getChannels(), audioFormat.getSampleRate(), byArray, n2, n4);
        if (this.waveformId == 0L) {
            throw new LineUnavailableException("Failed to allocate clip data.");
        }
        this.format = audioFormat;
        this.bufferSize = n3;
        this.frameLength = this.bufferSize / audioFormat.getFrameSize();
        this.microsecondLength = (long)((double)this.frameLength / (double)audioFormat.getFrameRate() * 1000000.0);
        this.loopStart = 0;
        this.loopEnd = n4;
        this.position = 0;
        this.id = this.getValidVoiceId();
    }

    synchronized int getValidVoiceId() throws LineUnavailableException {
        int n2;
        float f2;
        if (this.id != 0) {
            return this.id;
        }
        float f3 = this.muteControl.getValue() ? 0.0f : Toolkit.dBToLinear(this.gainControl.getValue());
        int n3 = this.nSetup(this.waveformId, this.position, this.loopStart, this.loopEnd, f3, (f2 = this.panControl.getValue()) * -1.0f, n2 = (int)this.rateControl.getValue());
        if (n3 == 0) {
            throw new LineUnavailableException("Failed to allocate sample voice");
        }
        return n3;
    }

    void implClose() {
        this.nClose(this.id, this.waveformId);
        this.id = 0;
        this.waveformId = 0L;
    }

    void implStart() {
        block5: {
            int n2 = this.bufferSize / this.format.getFrameSize();
            if (this.position >= n2) {
                if (Printer.debug) {
                    Printer.debug("MixerClip: implStart: already at end of sample; returning.");
                }
                return;
            }
            try {
                this.id = this.getValidVoiceId();
                if (this.nStart(this.id)) {
                    this.setActive(true);
                    this.setStarted(true);
                }
            }
            catch (LineUnavailableException lineUnavailableException) {
                if (!Printer.err) break block5;
                Printer.err("ERROR: LineUnavailableException in implStart: " + lineUnavailableException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void implStop() {
        if (Printer.debug) {
            Printer.debug("> MixerClip: implStop: id: " + this.id);
        }
        this.position = this.getFramePosition();
        this.loopCount = 0;
        this.currentLoop = 0;
        this.stopping = true;
        this.nStop(this.id);
        while (this.id != 0) {
            MixerClip mixerClip = this;
            synchronized (mixerClip) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        this.stopping = false;
        this.setStarted(false);
        if (Printer.debug) {
            Printer.debug("< MixerClip: implStop: id: " + this.id + " position: " + this.position);
        }
    }

    public int getFramePosition() {
        return this.id != 0 ? this.position + (int)this.nGetPosition(this.id) : this.position;
    }

    boolean callbackSampleLoop() {
        boolean bl2;
        if (Printer.trace) {
            Printer.trace(">> MixerClip: callbackSampleLoop()");
        }
        boolean bl3 = bl2 = this.loopCount == -1 || this.currentLoop < this.loopCount;
        if (Printer.debug) {
            Printer.debug("currentLoop: " + this.currentLoop + " loopCount: " + this.loopCount + " keepLooping: " + bl2);
        }
        ++this.currentLoop;
        if (!bl2) {
            this.loopCount = 0;
            this.currentLoop = 0;
        }
        if (Printer.trace) {
            Printer.trace("<< MixerClip: callbackSampleLoop() returning: " + bl2);
        }
        return bl2;
    }

    void callbackSampleEnd() {
        if (Printer.trace) {
            Printer.trace(">> MixerClip: callbackSampleEnd()");
        }
        this.id = 0;
        if (!this.resettingFramePosition) {
            this.setActive(false);
            if (!this.stopping) {
                this.setEOM();
            }
        }
        if (Printer.trace) {
            Printer.trace("<< MixerClip: callbackSampleEnd() completed");
        }
    }

    private native boolean nStart(int var1);

    private native int nSetup(long var1, int var3, int var4, int var5, float var6, float var7, int var8) throws LineUnavailableException, IllegalArgumentException;

    private native void nDrain(int var1);

    private native void nFlush(int var1);

    private native long nGetPosition(int var1);

    private native float nGetLevel(int var1);

    private native long nOpen(int var1, int var2, float var3, byte[] var4, int var5, int var6) throws LineUnavailableException;

    private native void nClose(int var1, long var2);

    private native void nStop(int var1);

    protected native float nSetLinearGain(int var1, float var2);

    protected native float nSetPan(int var1, float var2);

    protected native int nSetSampleRate(int var1, int var2);

    private class MixerClipApplyReverbControl
    extends BooleanControl {
        private MixerClipApplyReverbControl() {
            super(BooleanControl.Type.APPLY_REVERB, false, "Yes", "No");
        }

        public void setValue(boolean bl2) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            if (bl2 == this.getValue() || MixerClip.this.id != 0) {
                // empty if block
            }
            super.setValue(bl2);
        }
    }

    private class MixerClipMuteControl
    extends BooleanControl {
        private MixerClipMuteControl() {
            super(BooleanControl.Type.MUTE, false, "Mute", "Not Mute");
        }

        public void setValue(boolean bl2) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            if (bl2 && !this.getValue() && MixerClip.this.id != 0) {
                MixerClip.this.nSetLinearGain(MixerClip.this.id, 0.0f);
            } else if (!bl2 && this.getValue() && MixerClip.this.id != 0) {
                float f2 = Toolkit.dBToLinear(MixerClip.this.gainControl.getValue());
                MixerClip.this.nSetLinearGain(MixerClip.this.id, f2);
            }
            super.setValue(bl2);
        }
    }

    private class MixerClipSampleRateControl
    extends FloatControl {
        private MixerClipSampleRateControl() {
            super(FloatControl.Type.SAMPLE_RATE, 0.0f, 48000.0f, 1.0f, -1, MixerClip.this.getFormat().getFrameRate(), "FPS", "Minimum", "", "Maximum");
        }

        public void setValue(float f2) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            f2 = Math.min(f2, this.getMaximum());
            if ((f2 = Math.max(f2, this.getMinimum())) != this.getValue() && MixerClip.this.id != 0) {
                f2 = MixerClip.this.nSetSampleRate(MixerClip.this.id, (int)f2);
            }
            super.setValue(f2);
        }

        private void update(float f2) {
            super.setValue(f2);
        }
    }

    private class MixerClipPanControl
    extends FloatControl {
        private MixerClipPanControl() {
            super(FloatControl.Type.PAN, -1.0f, 1.0f, 0.015625f, -1, 0.0f, "", "Left", "Center", "Right");
        }

        public void setValue(float f2) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            f2 = Math.min(f2, this.getMaximum());
            if ((f2 = Math.max(f2, this.getMinimum())) != this.getValue() && MixerClip.this.id != 0) {
                f2 = -1.0f * MixerClip.this.nSetPan(MixerClip.this.id, -1.0f * f2);
            }
            super.setValue(f2);
        }
    }

    private class MixerClipGainControl
    extends FloatControl {
        private float linearGain;

        private MixerClipGainControl() {
            super(FloatControl.Type.MASTER_GAIN, Toolkit.linearToDB(0.0f), Toolkit.linearToDB(5.0f), Math.abs(Toolkit.linearToDB(5.0f) - Toolkit.linearToDB(0.0f)) / 128.0f, -1, 0.0f, "dB", "Minimum", "", "Maximum");
            this.linearGain = 1.0f;
        }

        public void setValue(float f2) {
            if (!MixerClip.this.isOpen()) {
                return;
            }
            f2 = Math.min(f2, this.getMaximum());
            float f3 = Toolkit.dBToLinear(f2 = Math.max(f2, this.getMinimum()));
            if (f3 != this.linearGain && MixerClip.this.id != 0) {
                f3 = MixerClip.this.nSetLinearGain(MixerClip.this.id, f3);
            }
            this.linearGain = f3;
            super.setValue(Toolkit.linearToDB(this.linearGain));
        }
    }
}

