/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import COM.rsa.jsafe.SunJSSE_a7;
import COM.rsa.jsafe.SunJSSE_b3;
import COM.rsa.jsafe.SunJSSE_b7;
import COM.rsa.jsafe.SunJSSE_bg;
import com.sun.net.ssl.internal.ssl.SunJSSE_bd;
import com.sun.net.ssl.internal.ssl.SunJSSE_be;
import com.sun.net.ssl.internal.ssl.SunJSSE_bf;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import sun.security.pkcs.ContentInfo;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;

public final class PKCS12KeyStore
extends KeyStoreSpi {
    public static final int VERSION_3 = 3;
    private static final int a = 20;
    private static final int[] b = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 2};
    private static final int[] c = new int[]{1, 2, 840, 113549, 1, 12, 10, 1, 3};
    private static final int[] d = new int[]{1, 2, 840, 113549, 1, 9, 20};
    private static final int[] e = new int[]{1, 2, 840, 113549, 1, 9, 21};
    private static ObjectIdentifier f;
    private static ObjectIdentifier g;
    private static ObjectIdentifier h;
    private static ObjectIdentifier i;
    private static int j;
    private Hashtable k = new Hashtable();
    private ArrayList l = new ArrayList();
    private HashMap m = new HashMap();
    private int n = 1;

    public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
        Object v = this.k.get(string.toLowerCase());
        PrivateKey privateKey = null;
        if (v == null || !(v instanceof SunJSSE_be)) {
            return null;
        }
        byte[] byArray = ((SunJSSE_be)v).b;
        try {
            DerValue derValue = new DerValue(byArray);
            DerValue[] derValueArray = new DerValue[]{derValue.data.getDerValue(), derValue.data.getDerValue()};
            if (derValue.data.available() != 0) {
                throw new IOException("overrun, bytes = " + derValue.data.available());
            }
            byte[] byArray2 = derValueArray[1].getOctetString();
            SunJSSE_bg sunJSSE_bg = SunJSSE_bg.a(byArray, 0, "Java");
            SunJSSE_b3 sunJSSE_b3 = sunJSSE_bg.g();
            sunJSSE_b3.a(cArray, 0, cArray.length);
            sunJSSE_bg.a(sunJSSE_b3);
            if (!"3DES_EDE".equals(sunJSSE_bg.m())) {
                throw new NoSuchAlgorithmException("3DES_EDE only for shrouded keys");
            }
            byte[] byArray3 = PKCS12KeyStore.a(cArray, sunJSSE_bg.u(), sunJSSE_bg.q()[0], sunJSSE_bg.q()[1] * sunJSSE_bg.h());
            byte[] byArray4 = PKCS12KeyStore.b(cArray, sunJSSE_bg.u(), sunJSSE_bg.q()[0], sunJSSE_bg.h());
            String string2 = sunJSSE_bg.m() + "/" + sunJSSE_bg.n() + "/" + sunJSSE_bg.s();
            sunJSSE_bg = SunJSSE_bg.a(string2, "Java");
            sunJSSE_bg.c(byArray4, 0, byArray4.length);
            sunJSSE_b3 = sunJSSE_bg.g();
            sunJSSE_b3.a(byArray3, 0, byArray3.length);
            sunJSSE_bg.a(sunJSSE_b3);
            byte[] byArray5 = PKCS12KeyStore.a(sunJSSE_bg, byArray2);
            PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(byArray5);
            SunJSSE_a7 sunJSSE_a7 = SunJSSE_a7.a(byArray5, 0, "Java");
            KeyFactory keyFactory = KeyFactory.getInstance(sunJSSE_a7.b());
            privateKey = keyFactory.generatePrivate(pKCS8EncodedKeySpec);
        }
        catch (Exception exception) {
            throw new UnrecoverableKeyException(exception.getMessage());
        }
        return privateKey;
    }

    public Certificate[] engineGetCertificateChain(String string) {
        Object v = this.k.get(string.toLowerCase());
        if (v != null && v instanceof SunJSSE_be) {
            if (((SunJSSE_be)v).c == null) {
                return null;
            }
            return (Certificate[])((SunJSSE_be)v).c.clone();
        }
        return null;
    }

    public Certificate engineGetCertificate(String string) {
        Object v = this.k.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof SunJSSE_bf) {
                return ((SunJSSE_bf)v).b;
            }
            if (((SunJSSE_be)v).c == null) {
                return null;
            }
            return ((SunJSSE_be)v).c[0];
        }
        return null;
    }

    public Date engineGetCreationDate(String string) {
        Object v = this.k.get(string.toLowerCase());
        if (v != null) {
            if (v instanceof SunJSSE_bf) {
                return new Date(((SunJSSE_bf)v).a.getTime());
            }
            return new Date(((SunJSSE_be)v).a.getTime());
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
        try {
            Hashtable hashtable = this.k;
            synchronized (hashtable) {
                SunJSSE_be sunJSSE_be = new SunJSSE_be(this);
                sunJSSE_be.a = new Date();
                if (certificateArray != null) {
                    sunJSSE_be.c = (Certificate[])certificateArray.clone();
                }
                this.k.put(string.toLowerCase(), sunJSSE_be);
            }
        }
        catch (Exception exception) {
            throw new KeyStoreException("Key protection algorithm not found");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
        Hashtable hashtable = this.k;
        synchronized (hashtable) {
            SunJSSE_be sunJSSE_be = new SunJSSE_be(this);
            sunJSSE_be.a = new Date();
            sunJSSE_be.b = (byte[])byArray.clone();
            if (certificateArray != null) {
                sunJSSE_be.c = (Certificate[])certificateArray.clone();
            }
            this.k.put(string.toLowerCase(), sunJSSE_be);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
        Hashtable hashtable = this.k;
        synchronized (hashtable) {
            Object v = this.k.get(string.toLowerCase());
            if (v != null && v instanceof SunJSSE_be) {
                throw new KeyStoreException("Cannot overwrite own certificate");
            }
            SunJSSE_bf sunJSSE_bf = new SunJSSE_bf(this);
            sunJSSE_bf.b = certificate;
            sunJSSE_bf.a = new Date();
            this.k.put(string.toLowerCase(), sunJSSE_bf);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void engineDeleteEntry(String string) throws KeyStoreException {
        Hashtable hashtable = this.k;
        synchronized (hashtable) {
            this.k.remove(string.toLowerCase());
        }
    }

    public Enumeration engineAliases() {
        return this.k.keys();
    }

    public boolean engineContainsAlias(String string) {
        return this.k.containsKey(string.toLowerCase());
    }

    public int engineSize() {
        return this.k.size();
    }

    public boolean engineIsKeyEntry(String string) {
        Object v = this.k.get(string.toLowerCase());
        return v != null && v instanceof SunJSSE_be;
    }

    public boolean engineIsCertificateEntry(String string) {
        Object v = this.k.get(string.toLowerCase());
        return v != null && v instanceof SunJSSE_bf;
    }

    public String engineGetCertificateAlias(Certificate certificate) {
        Enumeration enumeration = this.k.keys();
        while (enumeration.hasMoreElements()) {
            Certificate certificate2;
            String string = (String)enumeration.nextElement();
            Object v = this.k.get(string);
            if (v instanceof SunJSSE_bf) {
                certificate2 = ((SunJSSE_bf)v).b;
            } else {
                if (((SunJSSE_be)v).c == null) continue;
                certificate2 = ((SunJSSE_be)v).c[0];
            }
            if (!certificate2.equals(certificate)) continue;
            return string;
        }
        return null;
    }

    public void engineStore(OutputStream outputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable hashtable = this.k;
        synchronized (hashtable) {
            throw new IOException("PKCS 12 storing not implemented");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void engineLoad(InputStream inputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        Hashtable hashtable = this.k;
        synchronized (hashtable) {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object var5_4 = null;
            Object var6_5 = null;
            Hashtable hashtable2 = null;
            Object var8_7 = null;
            Object var9_8 = null;
            if (inputStream == null) {
                return;
            }
            DerValue derValue = new DerValue(inputStream);
            DerInputStream derInputStream = derValue.toDerInputStream();
            int n = derInputStream.getInteger().toInt();
            if (n != 3) {
                throw new IOException("PKCS12 keystore not in version 3 format");
            }
            hashtable2 = new Hashtable(3);
            this.k.clear();
            ContentInfo contentInfo = new ContentInfo(derInputStream);
            ObjectIdentifier objectIdentifier = contentInfo.getContentType();
            if (!objectIdentifier.equals(ContentInfo.DATA_OID)) {
                throw new IOException("public key protected PKCS12 not supported");
            }
            byte[] byArray = contentInfo.getData();
            DerInputStream derInputStream2 = new DerInputStream(byArray);
            DerValue[] derValueArray = derInputStream2.getSequence(2);
            int n2 = derValueArray.length;
            int n3 = 0;
            while (n3 < n2) {
                block24: {
                    void var20_24;
                    block23: {
                        block22: {
                            object4 = null;
                            object3 = new DerInputStream(derValueArray[n3].toByteArray());
                            object2 = new ContentInfo((DerInputStream)object3);
                            objectIdentifier = ((ContentInfo)object2).getContentType();
                            Object var20_20 = null;
                            if (!objectIdentifier.equals(ContentInfo.DATA_OID)) break block22;
                            byte[] byArray2 = ((ContentInfo)object2).getData();
                            break block23;
                        }
                        if (!objectIdentifier.equals(ContentInfo.ENCRYPTED_DATA_OID)) throw new IOException("public key protected PKCS12 not supported");
                        if (cArray != null) {
                            object = ((ContentInfo)object2).getContent().toDerInputStream();
                            int n4 = object.getInteger().toInt();
                            DerValue[] derValueArray2 = ((DerInputStream)object).getSequence(2);
                            ObjectIdentifier objectIdentifier2 = derValueArray2[0].getOID();
                            object4 = derValueArray2[1].toByteArray();
                            if (!derValueArray2[2].isContextSpecific((byte)0)) {
                                throw new IOException("encrypted content not present!");
                            }
                            byte by = 4;
                            if (derValueArray2[2].isConstructed()) {
                                by = (byte)(by | 0x20);
                            }
                            derValueArray2[2].resetTag(by);
                            byte[] byArray3 = derValueArray2[2].getOctetString();
                            try {
                                SunJSSE_bg sunJSSE_bg = SunJSSE_bg.a((byte[])object4, 0, "Java");
                                SunJSSE_b3 sunJSSE_b3 = sunJSSE_bg.g();
                                sunJSSE_b3.a(cArray, 0, cArray.length);
                                sunJSSE_bg.a(sunJSSE_b3);
                                if (!"RC2".equals(sunJSSE_bg.m())) {
                                    throw new NoSuchAlgorithmException("RC2 Only for safeContents");
                                }
                                byte[] byArray4 = sunJSSE_b3.n();
                                byte[] byArray5 = sunJSSE_bg.p();
                                int[] nArray = sunJSSE_bg.q();
                                String string = "RC2-" + nArray[1] + "/CBC/PKCS5Padding";
                                sunJSSE_bg = SunJSSE_bg.a(string, "Java");
                                sunJSSE_bg.c(byArray5, 0, byArray5.length);
                                sunJSSE_b3 = sunJSSE_bg.g();
                                sunJSSE_b3.a(byArray4, 0, byArray4.length);
                                sunJSSE_bg.a(sunJSSE_b3);
                                byte[] byArray6 = PKCS12KeyStore.a(sunJSSE_bg, byArray3);
                            }
                            catch (Exception exception) {
                                throw new IOException("failed to decrypt safe contents entry");
                            }
                        }
                        break block24;
                    }
                    object = new DerInputStream((byte[])var20_24);
                    this.a((DerInputStream)object, cArray);
                }
                ++n3;
            }
            if (cArray != null && derInputStream.available() > 0) {
                SunJSSE_bd sunJSSE_bd = new SunJSSE_bd(derInputStream);
                try {
                    object2 = sunJSSE_bd.a().toUpperCase();
                    if (((String)object2).equals("SHA") || ((String)object2).equals("SHA1") || ((String)object2).equals("SHA-1")) {
                        object2 = "SHA1";
                    }
                    object3 = SunJSSE_b7.a("HMAC/" + (String)object2, "Java");
                    object4 = PKCS12KeyStore.c(cArray, sunJSSE_bd.b(), sunJSSE_bd.c(), 20);
                    object = ((SunJSSE_b7)object3).c();
                    ((SunJSSE_b3)object).a((byte[])object4, 0, ((Object)object4).length);
                    ((SunJSSE_b7)object3).a((SunJSSE_b3)object, new SecureRandom());
                    ((SunJSSE_b7)object3).a(byArray, 0, byArray.length);
                    byte[] byArray7 = ((SunJSSE_b7)object3).i();
                    if (!Arrays.equals(sunJSSE_bd.d(), byArray7)) {
                        throw new SecurityException("Failed PKCS12 integrity checking");
                    }
                }
                catch (Exception exception) {
                    throw new IOException("integrity check: " + exception);
                }
            }
            Object[] objectArray = this.l.toArray();
            int n5 = 0;
            while (n5 < objectArray.length) {
                object3 = (SunJSSE_be)objectArray[n5];
                if (((SunJSSE_be)object3).d != null) {
                    object4 = new ArrayList();
                    object = (X509Certificate)this.m.get(new KeyId(((SunJSSE_be)object3).d));
                    while (object != null) {
                        ((ArrayList)object4).add(object);
                        if (((X509Certificate)object).getIssuerDN().equals(((X509Certificate)object).getSubjectDN())) break;
                        object = (X509Certificate)this.m.get(((X509Certificate)object).getIssuerDN());
                    }
                    if (((ArrayList)object4).size() > 0) {
                        ((SunJSSE_be)object3).c = ((ArrayList)object4).toArray(new Certificate[((ArrayList)object4).size()]);
                    }
                }
                ++n5;
            }
            this.m.clear();
            this.l.clear();
            return;
        }
    }

    private static byte[] a(SunJSSE_bg sunJSSE_bg, byte[] byArray) throws Exception {
        byte[] byArray2;
        int n = sunJSSE_bg.a(byArray.length);
        byte[] byArray3 = new byte[n];
        int n2 = 0;
        n2 = sunJSSE_bg.a(byArray, 0, byArray.length, byArray3, 0);
        if ((n2 += sunJSSE_bg.a(byArray3, n2)) < byArray3.length) {
            byArray2 = new byte[n2];
            System.arraycopy(byArray3, 0, byArray2, 0, byArray2.length);
        } else {
            byArray2 = byArray3;
        }
        return byArray2;
    }

    private void a(DerInputStream derInputStream, char[] cArray) throws IOException, NoSuchAlgorithmException, CertificateException {
        DerValue[] derValueArray = derInputStream.getSequence(2);
        int n = derValueArray.length;
        int n2 = 0;
        while (n2 < n) {
            DerValue[] derValueArray2;
            Object object;
            Object object2;
            Object object3;
            DerValue[] derValueArray3;
            DerValue[] derValueArray4 = null;
            DerInputStream derInputStream2 = derValueArray[n2].toDerInputStream();
            ObjectIdentifier objectIdentifier = derInputStream2.getOID();
            DerValue derValue = derInputStream2.getDerValue();
            if (!derValue.isContextSpecific((byte)0)) {
                throw new IOException("unsupported PKCS12 bag value type " + derValue.tag);
            }
            derValue = derValue.data.getDerValue();
            if (objectIdentifier.equals(f)) {
                derValueArray3 = new SunJSSE_be(this);
                derValueArray3.b = derValue.toByteArray();
                derValueArray3.a = new Date();
                derValueArray4 = derValueArray3;
            } else if (objectIdentifier.equals(g)) {
                derValueArray3 = new DerInputStream(derValue.toByteArray());
                object3 = derValueArray3.getSequence(2);
                object2 = object3[0].getOID();
                if (!object3[1].isContextSpecific((byte)0)) {
                    throw new IOException("unsupported PKCS12 cert value type " + object3[1].tag);
                }
                DerValue derValue2 = object3[1].data.getDerValue();
                object = CertificateFactory.getInstance("X509");
                derValueArray2 = (DerValue[])((CertificateFactory)object).generateCertificate(new ByteArrayInputStream(derValue2.getOctetString()));
                derValueArray4 = derValueArray2;
            } else {
                throw new IOException("unsupported PKCS12 bag type " + objectIdentifier);
            }
            derValueArray3 = derInputStream2.getSet(2);
            object3 = null;
            object2 = null;
            int n3 = 0;
            while (n3 < derValueArray3.length) {
                object = new DerInputStream(derValueArray3[n3].toByteArray());
                derValueArray2 = ((DerInputStream)object).getSequence(2);
                ObjectIdentifier objectIdentifier2 = derValueArray2[0].getOID();
                DerInputStream derInputStream3 = new DerInputStream(derValueArray2[1].toByteArray());
                DerValue[] derValueArray5 = derInputStream3.getSet(2);
                if (objectIdentifier2.equals(h)) {
                    object3 = derValueArray5[0].getBMPString();
                } else if (objectIdentifier2.equals(i)) {
                    object2 = derValueArray5[0].getOctetString();
                } else {
                    System.out.println("unknown attr" + objectIdentifier2);
                }
                ++n3;
            }
            if (derValueArray4 instanceof SunJSSE_be) {
                object = (SunJSSE_be)derValueArray4;
                if (object2 != null) {
                    ((SunJSSE_be)object).d = (byte[])object2;
                    this.l.add(object);
                    if (object3 == null) {
                        object3 = this.a();
                    }
                    this.k.put(((String)object3).toLowerCase(), object);
                }
            } else if (derValueArray4 instanceof X509Certificate) {
                object = (X509Certificate)derValueArray4;
                if (object2 != null) {
                    this.m.put(new KeyId((byte[])object2), derValueArray4);
                }
                if (object3 != null) {
                    this.m.put(object3, derValueArray4);
                }
                if (((X509Certificate)object).getSubjectDN() != null) {
                    this.m.put(((X509Certificate)object).getSubjectDN(), derValueArray4);
                }
            }
            ++n2;
        }
    }

    private String a() {
        return String.valueOf(++j);
    }

    static byte[] a(char[] cArray, byte[] byArray, int n, int n2) {
        return PKCS12KeyStore.a(cArray, byArray, n, n2, 1);
    }

    static byte[] b(char[] cArray, byte[] byArray, int n, int n2) {
        return PKCS12KeyStore.a(cArray, byArray, n, n2, 2);
    }

    static byte[] c(char[] cArray, byte[] byArray, int n, int n2) {
        return PKCS12KeyStore.a(cArray, byArray, n, n2, 3);
    }

    private static byte[] a(char[] cArray, byte[] byArray, int n, int n2, int n3) {
        int n4 = cArray.length;
        if ((n4 *= 2) > 0) {
            n4 += 2;
        }
        byte[] byArray2 = new byte[n4];
        int n5 = 0;
        int n6 = 0;
        while (n5 < cArray.length) {
            byArray2[n6] = (byte)(cArray[n5] >>> 8 & 0xFF);
            byArray2[n6 + 1] = (byte)(cArray[n5] & 0xFF);
            ++n5;
            n6 += 2;
        }
        int n7 = 64;
        int n8 = 20;
        int n9 = PKCS12KeyStore.a(n2, n8) / n8;
        byte[] byArray3 = new byte[n7];
        int n10 = PKCS12KeyStore.a(byArray.length, n7);
        int n11 = PKCS12KeyStore.a(byArray2.length, n7);
        byte[] byArray4 = new byte[n10 + n11];
        byte[] byArray5 = new byte[n2];
        Arrays.fill(byArray3, (byte)n3);
        PKCS12KeyStore.a(byArray, byArray4, 0, n10);
        PKCS12KeyStore.a(byArray2, byArray4, n10, n11);
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA1");
            byte[] byArray6 = new byte[n7];
            byte[] byArray7 = new byte[n7];
            int n12 = 0;
            while (true) {
                messageDigest.update(byArray3);
                messageDigest.update(byArray4);
                byte[] byArray8 = messageDigest.digest();
                int n13 = 1;
                while (n13 < n) {
                    byArray8 = messageDigest.digest(byArray8);
                    ++n13;
                }
                System.arraycopy(byArray8, 0, byArray5, n8 * n12, Math.min(n2, n8));
                if (n12 + 1 != n9) {
                    PKCS12KeyStore.a(byArray8, byArray6, 0, byArray6.length);
                    BigInteger bigInteger = new BigInteger(1, byArray6).add(BigInteger.ONE);
                    int n14 = 0;
                    while (n14 < byArray4.length) {
                        if (byArray7.length != n7) {
                            byArray7 = new byte[n7];
                        }
                        System.arraycopy(byArray4, n14, byArray7, 0, n7);
                        BigInteger bigInteger2 = new BigInteger(1, byArray7);
                        bigInteger2 = bigInteger2.add(bigInteger);
                        byArray7 = bigInteger2.toByteArray();
                        int n15 = byArray7.length - n7;
                        if (n15 >= 0) {
                            System.arraycopy(byArray7, n15, byArray4, n14, n7);
                        } else if (n15 < 0) {
                            Arrays.fill(byArray4, n14, n14 + -n15, (byte)0);
                            System.arraycopy(byArray7, 0, byArray4, n14 + -n15, byArray7.length);
                        }
                        n14 += n7;
                    }
                    ++n12;
                    n2 -= n8;
                    continue;
                }
                break;
            }
        }
        catch (Exception exception) {
            throw new RuntimeException("internal error: " + exception);
        }
        return byArray5;
    }

    private static int a(int n, int n2) {
        return (n + (n2 - 1)) / n2 * n2;
    }

    private static void a(byte[] byArray, byte[] byArray2, int n, int n2) {
        int n3 = n2 / byArray.length;
        int n4 = 0;
        int n5 = 0;
        while (n4 < n3) {
            System.arraycopy(byArray, 0, byArray2, n5 + n, byArray.length);
            ++n4;
            n5 += byArray.length;
        }
        System.arraycopy(byArray, 0, byArray2, n5 + n, n2 - n5);
    }

    static {
        j = 0;
        try {
            f = new ObjectIdentifier(b);
            g = new ObjectIdentifier(c);
            h = new ObjectIdentifier(d);
            i = new ObjectIdentifier(e);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class KeyId {
        byte[] a;

        KeyId(byte[] byArray) {
            this.a = byArray;
        }

        public int hashCode() {
            int n = 0;
            int n2 = 0;
            while (n2 < this.a.length) {
                n += this.a[n2];
                ++n2;
            }
            return n;
        }

        public boolean equals(Object object) {
            if (!(object instanceof KeyId)) {
                return false;
            }
            KeyId keyId = (KeyId)object;
            if (this.a == keyId.a) {
                return true;
            }
            if (this.a.length != keyId.a.length) {
                return false;
            }
            int n = 0;
            while (n < this.a.length) {
                if (this.a[n] != keyId.a[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
    }
}

