/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.internal.ssl.CipherSpec;
import com.sun.net.ssl.internal.ssl.ClientDiffieHellmanPublic;
import com.sun.net.ssl.internal.ssl.Debug;
import com.sun.net.ssl.internal.ssl.HandshakeMessage;
import com.sun.net.ssl.internal.ssl.Handshaker;
import com.sun.net.ssl.internal.ssl.MAC;
import com.sun.net.ssl.internal.ssl.SSLContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionContextImpl;
import com.sun.net.ssl.internal.ssl.SSLSessionImpl;
import com.sun.net.ssl.internal.ssl.SSLSocketImpl;
import com.sun.net.ssl.internal.ssl.SunJSSE_au;
import com.sun.net.ssl.internal.ssl.SunJSSE_av;
import com.sun.net.ssl.internal.ssl.SunJSSE_e;
import com.sun.net.ssl.internal.ssl.SunJSSE_m;
import com.sun.net.ssl.internal.ssl.SunJSSE_n;
import com.sun.net.ssl.internal.ssl.SunJSSE_o;
import com.sun.net.ssl.internal.ssl.SunJSSE_q;
import com.sun.net.ssl.internal.ssl.SunJSSE_s;
import com.sun.net.ssl.internal.ssl.SunJSSE_t;
import com.sun.net.ssl.internal.ssl.SunJSSE_u;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.ArrayList;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.X509TrustManager;

final class ClientHandshaker
extends Handshaker {
    private PublicKey a;
    private byte[] b;
    private BigInteger c;
    private SunJSSE_au d;
    private SunJSSE_s e;
    private boolean f;

    ClientHandshaker(SSLSocketImpl sSLSocketImpl, SSLContextImpl sSLContextImpl) throws NoSuchAlgorithmException {
        super(sSLSocketImpl, sSLContextImpl, true);
    }

    ClientHandshaker(SSLSocketImpl sSLSocketImpl) throws NoSuchAlgorithmException {
        this(sSLSocketImpl, null);
    }

    SunJSSE_e e() throws NoSuchAlgorithmException {
        return this.aa.a(this.n, this.p, false);
    }

    MAC f() throws NoSuchAlgorithmException {
        return this.ae.newMAC(this.r);
    }

    SunJSSE_e c() throws NoSuchAlgorithmException {
        return this.aa.a(this.m, this.o, true);
    }

    MAC d() throws NoSuchAlgorithmException {
        return this.ae.newMAC(this.q);
    }

    protected void processMessage(byte by, int n) throws IOException, NoSuchAlgorithmException {
        if (((Handshaker)this).f > by && by != 0 && ((Handshaker)this).f != 1) {
            throw new SSLProtocolException("Handshake message sequence violation, " + by);
        }
        block2 : switch (by) {
            case 0: {
                this.a(new SunJSSE_m(((Handshaker)this).d));
                break;
            }
            case 2: {
                this.a(new SunJSSE_o(((Handshaker)this).d));
                break;
            }
            case 11: {
                if (((CipherSpec)this).q == 7) {
                    ((Handshaker)this).a.a((byte)10, "unexpected server cert chain");
                }
                this.a(new HandshakeMessage.CertificateMsg(((Handshaker)this).d));
                this.a = this.j.getPeerCertificates()[0].getPublicKey();
                break;
            }
            case 12: {
                this.f = true;
                switch (((CipherSpec)this).q) {
                    case 1: 
                    case 2: {
                        try {
                            this.a(new SunJSSE_q(((Handshaker)this).d, n));
                            break block2;
                        }
                        catch (SignatureException signatureException) {
                            throw new SSLException("Server key, " + signatureException);
                        }
                        catch (InvalidKeyException invalidKeyException) {
                            throw new SSLException("Server key, " + invalidKeyException);
                        }
                    }
                    case 7: {
                        this.a(new HandshakeMessage.DH_ServerKeyExchange(((Handshaker)this).d));
                        break block2;
                    }
                    case 5: 
                    case 6: {
                        try {
                            this.a(new HandshakeMessage.DH_ServerKeyExchange(((Handshaker)this).d, this.a, this.h.a, this.i.a, n));
                            break block2;
                        }
                        catch (SignatureException signatureException) {
                            throw new SSLException("Server key, " + signatureException);
                        }
                        catch (InvalidKeyException invalidKeyException) {
                            throw new SSLException("Server key, " + invalidKeyException);
                        }
                    }
                }
                throw new SSLProtocolException("unsupported key exchange algorithm = " + ((CipherSpec)this).q);
            }
            case 13: {
                if (((CipherSpec)this).q == 7) {
                    throw new SSLHandshakeException("Client authentication requested for anonymous cipher suite.");
                }
                this.e = new SunJSSE_s(((Handshaker)this).d);
                if (Handshaker.s == null || !Debug.isOn("handshake")) break;
                this.e.a(System.out);
                break;
            }
            case 14: {
                this.a(new SunJSSE_t(((Handshaker)this).d));
                break;
            }
            case 20: {
                this.a(new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).d));
                break;
            }
            default: {
                throw new SSLProtocolException("Illegal client handshake msg, " + by);
            }
        }
        if (((Handshaker)this).f < by) {
            ((Handshaker)this).f = by;
        }
    }

    boolean a(int n, boolean bl) {
        switch (n) {
            case 1: 
            case 2: 
            case 5: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        return false;
    }

    protected boolean canUseCipherSuite(String string) {
        return this.isEnabled(string);
    }

    private void a(SunJSSE_m sunJSSE_m) throws IOException {
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            sunJSSE_m.a(System.out);
        }
        if (((Handshaker)this).f < 1) {
            this.kickstart();
        }
    }

    private void a(SunJSSE_o sunJSSE_o) throws IOException {
        this.f = false;
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            sunJSSE_o.a(System.out);
        }
        if (sunJSSE_o.a != 3 || sunJSSE_o.b > 1) {
            throw new SSLProtocolException("version mismatch, server is v" + sunJSSE_o.a + "." + sunJSSE_o.b);
        }
        ((CipherSpec)this).a = sunJSSE_o.a;
        ((CipherSpec)this).b = sunJSSE_o.b;
        ((Handshaker)this).a.a(((CipherSpec)this).a, ((CipherSpec)this).b);
        ((Handshaker)this).e.r.a(((CipherSpec)this).a, ((CipherSpec)this).b);
        this.i = sunJSSE_o.d;
        if (this.j != null) {
            if (this.j.d().equals(sunJSSE_o.e)) {
                CipherSpec cipherSpec = this.j.e();
                byte[] byArray = cipherSpec.getCipherSuite();
                if (sunJSSE_o.f[0] != byArray[0] || sunJSSE_o.f[1] != byArray[1] || sunJSSE_o.a != cipherSpec.a || sunJSSE_o.b != cipherSpec.b) {
                    throw new SSLProtocolException("Server returned wrong cipher suite for session");
                }
                this.k = true;
                ((Handshaker)this).f = 19;
                if (Handshaker.s != null && Debug.isOn("session")) {
                    System.out.println("%% Server resumed " + this.j);
                }
            } else {
                this.j = null;
                if (!this.l) {
                    throw new SSLException("New session creation was disabled");
                }
            }
        }
        if (!this.a(sunJSSE_o.f[0], sunJSSE_o.f[1])) {
            ((Handshaker)this).a.a((byte)47, "Can't support cipher suite [" + sunJSSE_o.f[0] + ", " + sunJSSE_o.f[1] + "]");
        } else if (sunJSSE_o.g != 0) {
            ((Handshaker)this).a.a((byte)47, "compression type not supported, " + sunJSSE_o.g);
        }
        if (this.j == null) {
            this.j = new SSLSessionImpl((CipherSpec)this, sunJSSE_o.e, ((Handshaker)this).a.e(), ((Handshaker)this).a.getPort());
            if (Handshaker.s != null && Debug.isOn("handshake")) {
                System.out.println("** " + this.j.e());
            }
        } else {
            try {
                this.b(this.j.a());
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SSLException("Missing algorithm: " + noSuchAlgorithmException.getMessage());
            }
        }
    }

    private void a(SunJSSE_q sunJSSE_q) throws IOException, NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            sunJSSE_q.a(System.out);
        }
        if (!(this.a instanceof RSAPublicKey)) {
            throw new InvalidKeyException("server key not an RSA key");
        }
        if (!sunJSSE_q.a((RSAPublicKey)this.a, this.h, this.i)) {
            ((Handshaker)this).a.a((byte)40, "server key exchange invalid");
        }
        this.a = sunJSSE_q.a();
    }

    private void a(BigInteger bigInteger, BigInteger bigInteger2) {
        this.d = new SunJSSE_au(bigInteger, bigInteger2);
        this.d.a(this.g.a(), 768);
    }

    private void a(HandshakeMessage.DH_ServerKeyExchange dH_ServerKeyExchange) throws IOException, NoSuchAlgorithmException {
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            dH_ServerKeyExchange.a(System.out);
        }
        if (((CipherSpec)this).q == 4 || ((CipherSpec)this).q == 3) {
            ((Handshaker)this).a.a((byte)10, "not supporting DH certs for key exchange now");
        }
        this.a(dH_ServerKeyExchange.getModulus(), dH_ServerKeyExchange.getBase());
        this.c = dH_ServerKeyExchange.getServerPublicKey();
    }

    private void a(SunJSSE_t sunJSSE_t) throws IOException, NoSuchAlgorithmException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            sunJSSE_t.a(System.out);
        }
        ((Handshaker)this).d.a();
        PrivateKey privateKey = null;
        if (this.e != null) {
            object4 = this.g.b();
            object3 = null;
            HandshakeMessage.CertificateMsg certificateMsg = null;
            object2 = null;
            object = new ArrayList<String>(4);
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            int n = 0;
            while (n < this.e.g.length) {
                switch (this.e.g[n]) {
                    case 1: {
                        if (bl) break;
                        ((ArrayList)object).add("RSA");
                        bl = true;
                        break;
                    }
                    case 2: {
                        if (bl2) break;
                        ((ArrayList)object).add("DSA");
                        bl2 = true;
                        break;
                    }
                    case 3: {
                        if (bl3) break;
                        ((ArrayList)object).add("DH_RSA");
                        bl3 = true;
                        break;
                    }
                    case 4: {
                        if (bl4) break;
                        ((ArrayList)object).add("DH_DSA");
                        bl4 = true;
                        break;
                    }
                }
                ++n;
            }
            int n2 = ((ArrayList)object).size();
            if (n2 != 0) {
                String[] stringArray = new String[n2];
                int n3 = 0;
                while (n3 < stringArray.length) {
                    stringArray[n3] = (String)((ArrayList)object).get(n3);
                    ++n3;
                }
                object3 = object4.chooseClientAlias(stringArray, this.e.a(), ((Handshaker)this).a);
            }
            if (object3 != null) {
                object2 = object4.getCertificateChain((String)object3);
                certificateMsg = new HandshakeMessage.CertificateMsg((X509Certificate[])object2);
                privateKey = object4.getPrivateKey((String)object3);
                this.j.a(true);
            } else if (((CipherSpec)this).b > 0) {
                certificateMsg = new HandshakeMessage.CertificateMsg(new X509Certificate[0]);
            } else {
                ((Handshaker)this).a.b((byte)41);
            }
            if (certificateMsg != null) {
                this.j.b((X509Certificate[])object2);
                if (Handshaker.s != null && Debug.isOn("handshake")) {
                    certificateMsg.a(System.out);
                }
                certificateMsg.write(((Handshaker)this).e);
            }
        }
        switch (((CipherSpec)this).q) {
            case 1: 
            case 2: {
                object3 = new SunJSSE_av(((CipherSpec)this).a, ((CipherSpec)this).b, this.g.a(), this.a);
                this.b = ((SunJSSE_av)object3).c;
                object4 = object3;
                break;
            }
            case 3: 
            case 4: {
                object4 = new ClientDiffieHellmanPublic();
                break;
            }
            case 6: 
            case 7: {
                object4 = new ClientDiffieHellmanPublic(this.d.c());
                break;
            }
            default: {
                throw new SSLProtocolException("unsupported key exchange algorithm = " + ((CipherSpec)this).q);
            }
        }
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            ((HandshakeMessage)object4).a(System.out);
        }
        ((HandshakeMessage)object4).write(((Handshaker)this).e);
        ((Handshaker)this).e.b();
        ((Handshaker)this).e.flush();
        switch (((CipherSpec)this).q) {
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                this.b = this.d.b(this.c);
                break;
            }
            default: {
                throw new SSLProtocolException("unsupported key exchange algorithm = " + ((CipherSpec)this).q);
            }
        }
        this.a(this.b);
        int n = 0;
        while (n < this.b.length) {
            this.b[n] = 0;
            ++n;
        }
        if (privateKey != null) {
            MessageDigest messageDigest;
            object2 = null;
            try {
                object = (MessageDigest)((Handshaker)this).b[0].clone();
                messageDigest = (MessageDigest)((Handshaker)this).c[0].clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                object = ((Handshaker)this).b[2];
                messageDigest = ((Handshaker)this).c[2];
                ((Handshaker)this).b[2] = null;
                ((Handshaker)this).c[2] = null;
            }
            try {
                object2 = privateKey instanceof RSAPrivateKey ? new SunJSSE_u(((CipherSpec)this).b, (RSAPrivateKey)privateKey, (MessageDigest)object, messageDigest, this.j.a(), this.g.a()) : new SunJSSE_u(((CipherSpec)this).b, privateKey, messageDigest, this.j.a(), this.g.a());
            }
            catch (InvalidKeyException invalidKeyException) {
                ((Handshaker)this).a.a((byte)40, "Invalid private key");
            }
            catch (SignatureException signatureException) {
                ((Handshaker)this).a.a((byte)40, "DSS/DSA signature failure");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                ((Handshaker)this).a.a((byte)40, "No DSS/DSA implementation");
            }
            if (Handshaker.s != null && Debug.isOn("handshake")) {
                object2.a(System.out);
            }
            object2.write(((Handshaker)this).e);
            ((Handshaker)this).e.b();
        }
        this.g();
    }

    private void a(HandshakeMessage.Finished finished) throws IOException {
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            finished.a(System.out);
        }
        boolean bl = false;
        try {
            bl = ((CipherSpec)this).b == 0 ? finished.verify((MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), HandshakeMessage.Finished.d, this.j.a()) : finished.verify((MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), "server finished", this.j.a());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            bl = ((CipherSpec)this).b == 0 ? finished.verify(((Handshaker)this).b[0], ((Handshaker)this).c[0], HandshakeMessage.Finished.d, this.j.a()) : finished.verify(((Handshaker)this).b[0], ((Handshaker)this).c[0], "server finished", this.j.a());
            ((Handshaker)this).b[0] = null;
            ((Handshaker)this).c[0] = null;
        }
        if (!bl) {
            ((Handshaker)this).a.a((byte)47, "server 'finished' message doesn't verify");
        }
        if (this.k) {
            ((Handshaker)this).d.a();
            this.g();
        }
        this.j.a(System.currentTimeMillis());
        if (!this.k) {
            if (((Handshaker)this).a.b() && this.j.b()) {
                ((SSLSessionContextImpl)this.g.engineGetClientSessionContext()).a(this.j);
                if (Handshaker.s != null && Debug.isOn("session")) {
                    System.out.println("%% Cached client session: " + this.j);
                }
            } else if (Handshaker.s != null && Debug.isOn("session")) {
                System.out.println("%% Didn't cache non-resumable client session: " + this.j);
            }
        }
    }

    private void g() throws IOException {
        HandshakeMessage.Finished finished;
        try {
            if (((Handshaker)this).b[0] == null) {
                throw new CloneNotSupportedException("minor hack");
            }
            finished = ((CipherSpec)this).b == 0 ? new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, (MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), HandshakeMessage.Finished.c, this.j.a()) : new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, (MessageDigest)((Handshaker)this).b[0].clone(), (MessageDigest)((Handshaker)this).c[0].clone(), "client finished", this.j.a());
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            finished = ((CipherSpec)this).b == 0 ? new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).b[1], ((Handshaker)this).c[1], HandshakeMessage.Finished.c, this.j.a()) : new HandshakeMessage.Finished(((CipherSpec)this).a, ((CipherSpec)this).b, ((Handshaker)this).b[1], ((Handshaker)this).c[1], "client finished", this.j.a());
            ((Handshaker)this).b[1] = null;
            ((Handshaker)this).c[1] = null;
        }
        this.sendChangeCipherSpec(finished);
        ((Handshaker)this).f = 19;
    }

    protected HandshakeMessage getKickstartMessage() throws SSLException {
        SunJSSE_n sunJSSE_n = new SunJSSE_n(this.g.a(), ((CipherSpec)this).a, ((CipherSpec)this).b, ((CipherSpec)this).c);
        this.h = sunJSSE_n.d;
        this.j = ((SSLSessionContextImpl)this.g.engineGetClientSessionContext()).a(((Handshaker)this).a.e(), ((Handshaker)this).a.getPort());
        if (Handshaker.s != null && Debug.isOn("session")) {
            if (this.j != null) {
                System.out.println("%% Client cached " + this.j + (this.j.b() ? "" : " (not rejoinable)"));
            } else {
                System.out.println("%% No cached client session");
            }
        }
        if (this.j != null) {
            CipherSpec cipherSpec;
            if (!this.isEnabled(this.j.getCipherSuite())) {
                if (Handshaker.s != null && Debug.isOn("session")) {
                    System.out.println("%% can't resume, cipher disabled");
                }
                this.j = null;
            }
            if (this.j != null) {
                if (Handshaker.s != null && (Debug.isOn("handshake") || Debug.isOn("session"))) {
                    System.out.println("%% Try resuming " + this.j + " from port " + ((Handshaker)this).a.getLocalPort());
                }
                sunJSSE_n.e = this.j.d();
                cipherSpec = this.j.e();
                ((CipherSpec)this).a = sunJSSE_n.a = cipherSpec.a;
                ((CipherSpec)this).b = sunJSSE_n.b = cipherSpec.b;
                ((Handshaker)this).a.a(((CipherSpec)this).a, ((CipherSpec)this).b);
                ((Handshaker)this).e.r.a(((CipherSpec)this).a, ((CipherSpec)this).b);
            }
            if (!this.l) {
                if (this.j == null) {
                    throw new SSLException("Can't reuse existing SSL client session");
                }
                cipherSpec = this.j.e();
                sunJSSE_n.f = cipherSpec.getCipherSuite();
                return sunJSSE_n;
            }
        }
        if (this.j == null) {
            if (this.l) {
                sunJSSE_n.e = SSLSessionImpl.a.d();
            } else {
                throw new SSLException("No existing session to resume.");
            }
        }
        sunJSSE_n.f = new byte[2 * this.ag.length];
        int n = 0;
        byte[] byArray = new byte[2];
        int n2 = 0;
        while (n2 < this.ag.length) {
            byArray = this.a(this.ag[n2]);
            sunJSSE_n.f[n++] = byArray[0];
            sunJSSE_n.f[n++] = byArray[1];
            ++n2;
        }
        return sunJSSE_n;
    }

    void b(byte by) throws SSLProtocolException {
        String string = SSLSocketImpl.a(by);
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            System.out.println("SSL - handshake alert: " + string);
        }
        throw new SSLProtocolException("handshake alert:  " + string);
    }

    private void a(HandshakeMessage.CertificateMsg certificateMsg) throws IOException {
        X509Certificate[] x509CertificateArray;
        if (Handshaker.s != null && Debug.isOn("handshake")) {
            certificateMsg.a(System.out);
        }
        if ((x509CertificateArray = certificateMsg.getCertificateChain()).length == 0) {
            ((Handshaker)this).a.a((byte)42, "null cert chain");
        }
        X509TrustManager x509TrustManager = this.g.c();
        try {
            String string = this.j.getCipherSuite();
            String string2 = string.substring(string.indexOf(95) + 1, string.indexOf("_WITH"));
            if (string2.startsWith("RSA_EXPORT") && !this.f) {
                string2 = "RSA";
            }
            x509TrustManager.checkServerTrusted(x509CertificateArray, string2);
        }
        catch (CertificateException certificateException) {
            ((Handshaker)this).a.a((byte)46, certificateException.getMessage());
        }
        this.j.a(x509CertificateArray);
    }
}

