/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;

public abstract class URLStreamHandler {
    protected abstract URLConnection openConnection(URL var1) throws IOException;

    protected void parseURL(URL u, String spec, int start, int limit) {
        String host = u.getHost();
        int port = u.getPort();
        String file = u.getFile();
        if (spec.regionMatches(start, "//", 0, 2)) {
            int colon;
            int slash = spec.indexOf(47, start += 2);
            int hostEnd = slash >= 0 ? slash : limit;
            if ((colon = (host = spec.substring(start, hostEnd)).indexOf(58)) >= 0) {
                try {
                    port = Integer.parseInt(host.substring(colon + 1));
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
                host = host.substring(0, colon);
            }
            file = null;
            start = hostEnd;
        } else if (host == null) {
            host = "";
        }
        if (start < limit && spec.charAt(start) == '/') {
            file = spec.substring(start, limit);
        } else if (file == null || file.length() <= 0) {
            file = spec.substring(start, limit);
        } else if (start < limit) {
            file = file.substring(0, file.lastIndexOf(47)) + '/' + spec.substring(start, limit);
        }
        u.set(u.getProtocol(), host, port, file, u.getRef());
    }

    private static String canonicalizeFilename(String file) {
        int previous;
        int index;
        while ((index = file.indexOf("/./")) >= 0) {
            file = file.substring(0, index) + file.substring(index + 2);
        }
        while ((index = file.indexOf("/../")) >= 0 && (previous = file.lastIndexOf(47, index - 1)) >= 0) {
            file = file.substring(0, previous) + file.substring(index + 3);
        }
        return file;
    }

    public boolean sameFile(URL url1, URL url2) {
        String s2;
        if (url1 == url2) {
            return true;
        }
        if (url1 == null || url2 == null || url1.getPort() != url2.getPort()) {
            return false;
        }
        String s1 = url1.getProtocol();
        if (!(s1 == (s2 = url2.getProtocol()) || s1 != null && s1.equals(s2))) {
            return false;
        }
        s1 = url1.getHost();
        if (!(s1 == (s2 = url2.getHost()) || s1 != null && s1.equals(s2))) {
            return false;
        }
        s1 = URLStreamHandler.canonicalizeFilename(url1.getFile());
        return s1 == (s2 = URLStreamHandler.canonicalizeFilename(url2.getFile())) || s1 != null && s1.equals(s2);
    }

    protected void setURL(URL u, String protocol, String host, int port, String file, String ref) {
        u.set(protocol, host, port, file, ref);
    }

    protected String toExternalForm(URL u) {
        String resStr = u.getProtocol() + ":";
        String host = u.getHost();
        int port = u.getPort();
        String file = u.getFile();
        String ref = u.getRef();
        if (host == null) {
            host = "";
        }
        if (port >= 0 || host.length() != 0) {
            resStr = resStr + "//" + host + (port < 0 ? "" : ":" + port);
        }
        resStr = resStr + file;
        if (ref != null) {
            resStr = resStr + "#" + ref;
        }
        return resStr;
    }
}

