/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class RandomAccessFile
implements DataOutput,
DataInput {
    private FileDescriptor fd;
    private DataOutputStream out;
    private DataInputStream in;

    public void close() throws IOException {
        if (this.fd.valid()) {
            this.fd.close();
        }
    }

    public final FileDescriptor getFD() throws IOException {
        if (!this.fd.valid()) {
            throw new IOException();
        }
        return this.fd;
    }

    public long getFilePointer() throws IOException {
        return this.fd.getFilePointer();
    }

    public long length() throws IOException {
        return this.fd.length();
    }

    public RandomAccessFile(String fileName, String mode) throws IOException {
        int fdmode;
        if (mode.compareTo("r") == 0) {
            fdmode = 1;
        } else if (mode.compareTo("rw") == 0) {
            fdmode = 3;
        } else {
            throw new IllegalArgumentException("invalid mode: " + mode);
        }
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkRead(fileName);
            if ((fdmode & 2) != 0) {
                s.checkWrite(fileName);
            }
        }
        this.fd = new FileDescriptor(fileName, fdmode);
        this.out = new DataOutputStream(new FileOutputStream(this.fd));
        this.in = new DataInputStream(new FileInputStream(this.fd));
    }

    public RandomAccessFile(File file, String mode) throws IOException {
        this(file.getPath(), mode);
    }

    public int read() throws IOException {
        return this.in.read();
    }

    public int read(byte[] buffer) throws IOException {
        return this.in.read(buffer);
    }

    public int read(byte[] buffer, int offset, int count) throws IOException {
        return this.in.read(buffer, offset, count);
    }

    public final boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    public final byte readByte() throws IOException {
        return this.in.readByte();
    }

    public final char readChar() throws IOException {
        return this.in.readChar();
    }

    public final double readDouble() throws IOException {
        return this.in.readDouble();
    }

    public final float readFloat() throws IOException {
        return this.in.readFloat();
    }

    public final void readFully(byte[] buffer) throws IOException {
        this.in.readFully(buffer);
    }

    public final void readFully(byte[] buffer, int offset, int count) throws IOException {
        this.in.readFully(buffer, offset, count);
    }

    public final int readInt() throws IOException {
        return this.in.readInt();
    }

    public final String readLine() throws IOException {
        return this.in.readLine();
    }

    public final long readLong() throws IOException {
        return this.in.readLong();
    }

    public final short readShort() throws IOException {
        return this.in.readShort();
    }

    public final int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    public final int readUnsignedShort() throws IOException {
        return this.in.readUnsignedShort();
    }

    public final String readUTF() throws IOException {
        return this.in.readUTF();
    }

    public void seek(long pos) throws IOException {
        this.fd.seek(pos, 0, false);
    }

    public int skipBytes(int count) throws IOException {
        if (count <= 0) {
            return 0;
        }
        return this.fd.seek(count, 1, true);
    }

    public void write(int oneByte) throws IOException {
        this.out.write(oneByte);
    }

    public void write(byte[] buffer) throws IOException {
        this.out.write(buffer);
    }

    public void write(byte[] buffer, int offset, int count) throws IOException {
        this.out.write(buffer, offset, count);
    }

    public final void writeBoolean(boolean val) throws IOException {
        this.out.writeBoolean(val);
    }

    public final void writeByte(int v) throws IOException {
        this.out.writeByte(v);
    }

    public final void writeShort(int v) throws IOException {
        this.out.writeShort(v);
    }

    public final void writeChar(int v) throws IOException {
        this.out.writeChar(v);
    }

    public final void writeInt(int v) throws IOException {
        this.out.writeInt(v);
    }

    public final void writeLong(long v) throws IOException {
        this.out.writeLong(v);
    }

    public final void writeFloat(float v) throws IOException {
        this.out.writeFloat(v);
    }

    public final void writeDouble(double v) throws IOException {
        this.out.writeDouble(v);
    }

    public final void writeBytes(String s) throws IOException {
        this.out.writeBytes(s);
    }

    public final void writeChars(String s) throws IOException {
        this.out.writeChars(s);
    }

    public final void writeUTF(String s) throws IOException {
        this.out.writeUTF(s);
    }
}

