/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import gnu.gcj.runtime.FileDeleter;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;

public class File
implements Serializable,
Comparable {
    public static final String pathSeparator = System.getProperty("path.separator");
    public static final char pathSeparatorChar = pathSeparator.charAt(0);
    public static final String separator = System.getProperty("file.separator");
    public static final char separatorChar = separator.charAt(0);
    static final String tmpdir = System.getProperty("java.io.tmpdir");
    static int maxPathLen;
    static boolean caseSensitive;
    static String dupSeparator;
    private String path;
    private static long counter;
    private static final int READ = 0;
    private static final int WRITE = 1;
    private static final int EXISTS = 2;
    private static final int DIRECTORY = 0;
    private static final int ISFILE = 1;
    private static final int ISHIDDEN = 2;
    private static final int MODIFIED = 0;
    private static final int LENGTH = 1;
    private static final long serialVersionUID = 301077366599181567L;

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public boolean canRead() {
        this.checkRead();
        return this._access(0);
    }

    public boolean canWrite() {
        this.checkWrite();
        return this._access(1);
    }

    private native boolean performCreate() throws IOException;

    public boolean createNewFile() throws IOException {
        this.checkWrite();
        return this.performCreate();
    }

    private native boolean performDelete();

    public boolean delete() {
        SecurityManager s = System.getSecurityManager();
        String name = this.path;
        if (s != null) {
            s.checkDelete(this.path);
        }
        return this.performDelete();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof File)) {
            return false;
        }
        File other = (File)obj;
        if (caseSensitive) {
            return this.path.equals(other.path);
        }
        return this.path.equalsIgnoreCase(other.path);
    }

    public boolean exists() {
        this.checkRead();
        return this._access(2);
    }

    public File(String p) {
        this.path = this.normalizePath(p);
    }

    private String normalizePath(String p) {
        if (separatorChar == '\\') {
            p = p.replace('/', '\\');
        }
        int dupIndex = p.indexOf(dupSeparator);
        int plen = p.length();
        if (dupSeparator.equals("\\\\") && dupIndex == 0) {
            dupIndex = p.indexOf(dupSeparator, 1);
        }
        if (dupIndex == -1) {
            if (plen > 1 && p.charAt(plen - 1) == separatorChar) {
                return p.substring(0, plen - 1);
            }
            return p;
        }
        StringBuffer newpath = new StringBuffer(plen);
        int last = 0;
        while (dupIndex != -1) {
            newpath.append(p.substring(last, dupIndex));
            while (p.charAt(dupIndex) == separatorChar) {
                if (++dupIndex != plen) continue;
                return newpath.toString();
            }
            newpath.append(separatorChar);
            last = dupIndex;
            dupIndex = p.indexOf(dupSeparator, last);
        }
        int end = plen > 1 && p.charAt(plen - 1) == separatorChar ? plen - 1 : plen;
        newpath.append(p.substring(last, end));
        return newpath.toString();
    }

    public File(String dirPath, String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.path = dirPath != null && dirPath.length() > 0 ? (dirPath.charAt(dirPath.length() - 1) == separatorChar || name.length() == 0 ? this.normalizePath(dirPath + name) : this.normalizePath(dirPath + separatorChar + name)) : this.normalizePath(name);
    }

    public File(File dir, String name) {
        this(dir == null ? null : dir.path, name);
    }

    public String getAbsolutePath() {
        if (this.isAbsolute()) {
            return this.path;
        }
        return System.getProperty("user.dir") + separatorChar + this.path;
    }

    public File getAbsoluteFile() {
        return new File(this.getAbsolutePath());
    }

    public native String getCanonicalPath() throws IOException;

    public File getCanonicalFile() throws IOException {
        return new File(this.getCanonicalPath());
    }

    public String getName() {
        int last = this.path.lastIndexOf(separatorChar);
        return this.path.substring(last + 1);
    }

    public String getParent() {
        int last = this.path.lastIndexOf(separatorChar);
        if (last == -1) {
            return null;
        }
        if (last == 0 && this.path.charAt(0) == '/') {
            ++last;
        }
        return this.path.substring(0, last);
    }

    public File getParentFile() {
        String parent = this.getParent();
        if (parent == null) {
            return null;
        }
        return new File(parent);
    }

    public String getPath() {
        return this.path;
    }

    public int hashCode() {
        if (caseSensitive) {
            return this.path.hashCode() ^ 0x12D591;
        }
        return this.path.toLowerCase().hashCode() ^ 0x12D591;
    }

    public native boolean isAbsolute();

    public boolean isDirectory() {
        this.checkRead();
        return this._stat(0);
    }

    public boolean isFile() {
        this.checkRead();
        return this._stat(1);
    }

    public boolean isHidden() {
        this.checkRead();
        return this._stat(2);
    }

    public long lastModified() {
        this.checkRead();
        return this.attr(0);
    }

    public long length() {
        this.checkRead();
        return this.attr(1);
    }

    private final native Object[] performList(FilenameFilter var1, FileFilter var2, Class var3);

    public String[] list(FilenameFilter filter) {
        this.checkRead();
        return (String[])this.performList(filter, null, File.class$("java.lang.String"));
    }

    public String[] list() {
        this.checkRead();
        return (String[])this.performList(null, null, File.class$("java.lang.String"));
    }

    public File[] listFiles() {
        this.checkRead();
        return (File[])this.performList(null, null, File.class$("java.io.File"));
    }

    public File[] listFiles(FilenameFilter filter) {
        this.checkRead();
        return (File[])this.performList(filter, null, File.class$("java.io.File"));
    }

    public File[] listFiles(FileFilter filter) {
        this.checkRead();
        return (File[])this.performList(null, filter, File.class$("java.io.File"));
    }

    public String toString() {
        return this.path;
    }

    public URL toURL() throws MalformedURLException {
        return new URL("file://" + this.getAbsolutePath() + (this.isDirectory() ? "/" : ""));
    }

    private final native boolean performMkdir();

    public boolean mkdir() {
        this.checkWrite();
        return this.performMkdir();
    }

    private static boolean mkdirs(File x) {
        if (x.isDirectory()) {
            return true;
        }
        String p = x.getPath();
        String parent = x.getParent();
        if (parent != null) {
            x.path = parent;
            if (!File.mkdirs(x)) {
                return false;
            }
            x.path = p;
        }
        return x.mkdir();
    }

    public boolean mkdirs() {
        this.checkWrite();
        if (this.isDirectory()) {
            return false;
        }
        return File.mkdirs(new File(this.path));
    }

    private static synchronized String nextValue() {
        return Long.toString(counter++, 36);
    }

    public static File createTempFile(String prefix, String suffix, File directory) throws IOException {
        if (directory == null) {
            String dirname = tmpdir;
            if (dirname == null) {
                throw new IOException("Cannot determine system temporary directory");
            }
            directory = new File(dirname);
            if (!directory.exists()) {
                throw new IOException("System temporary directory " + directory.getName() + " does not exist.");
            }
            if (!directory.isDirectory()) {
                throw new IOException("System temporary directory " + directory.getName() + " is not really a directory.");
            }
        }
        if (prefix.length() < 3) {
            throw new IllegalArgumentException("Prefix too short: " + prefix);
        }
        if (suffix == null) {
            suffix = ".tmp";
        }
        if (prefix.length() + 6 + suffix.length() > maxPathLen) {
            int suf_len = 0;
            if (suffix.charAt(0) == '.') {
                suf_len = 4;
            }
            suffix = suffix.substring(0, suf_len);
            if (prefix.length() + 6 + suf_len > maxPathLen) {
                prefix = prefix.substring(0, maxPathLen - 6 - suf_len);
            }
        }
        for (int i = 0; i < 100; ++i) {
            String t = "ZZZZZZ" + File.nextValue();
            String l = prefix + t.substring(t.length() - 6) + suffix;
            try {
                File f = new File(directory, l);
                if (!f.createNewFile()) continue;
                return f;
            }
            catch (IOException ignored) {
                // empty catch block
            }
        }
        throw new IOException("cannot create temporary file");
    }

    private native boolean performSetReadOnly();

    public boolean setReadOnly() {
        this.checkWrite();
        return this.performSetReadOnly();
    }

    private static native File[] performListRoots();

    public static File[] listRoots() {
        File[] roots = File.performListRoots();
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            int count = roots.length;
            for (int i = 0; i < roots.length; ++i) {
                try {
                    s.checkRead(roots[i].path);
                    continue;
                }
                catch (SecurityException sx) {
                    roots[i] = null;
                    --count;
                }
            }
            if (count != roots.length) {
                File[] newRoots = new File[count];
                int k = 0;
                for (int i = 0; i < roots.length; ++i) {
                    if (roots[i] == null) continue;
                    newRoots[k++] = roots[i];
                }
                roots = newRoots;
            }
        }
        return roots;
    }

    public static File createTempFile(String prefix, String suffix) throws IOException {
        return File.createTempFile(prefix, suffix, null);
    }

    public int compareTo(File other) {
        if (caseSensitive) {
            return this.path.compareTo(other.path);
        }
        return this.path.compareToIgnoreCase(other.path);
    }

    public int compareTo(Object o) {
        File other = (File)o;
        return this.compareTo(other);
    }

    private native boolean performRenameTo(File var1);

    public boolean renameTo(File dest) {
        SecurityManager s = System.getSecurityManager();
        String sname = this.getName();
        String dname = dest.getName();
        if (s != null) {
            s.checkWrite(sname);
            s.checkWrite(dname);
        }
        return this.performRenameTo(dest);
    }

    private native boolean performSetLastModified(long var1);

    public boolean setLastModified(long time) {
        this.checkWrite();
        return this.performSetLastModified(time);
    }

    private static native void init_native();

    private void checkWrite() {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkWrite(this.path);
        }
    }

    private void checkRead() {
        SecurityManager s = System.getSecurityManager();
        if (s != null) {
            s.checkRead(this.path);
        }
    }

    public void deleteOnExit() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkDelete(this.getName());
        }
        FileDeleter.add(this);
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeChar(separatorChar);
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        char oldSeparatorChar = ois.readChar();
        if (oldSeparatorChar != separatorChar) {
            this.path = this.path.replace(oldSeparatorChar, separatorChar);
        }
    }

    private final native long attr(int var1);

    private final native boolean _access(int var1);

    private final native boolean _stat(int var1);

    static {
        dupSeparator = separator + separator;
        File.init_native();
        counter = Double.doubleToLongBits(Math.random());
    }
}

