/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class VetoableChangeSupport
implements Serializable {
    transient Hashtable propertyListeners;
    transient Vector listeners;
    Hashtable children;
    Object source;
    int vetoableChangeSupportSerializedDataVersion;
    private static final long serialVersionUID = -5090210921595982017L;

    private /* synthetic */ void finit$() {
        this.propertyListeners = new Hashtable();
        this.listeners = new Vector();
        this.vetoableChangeSupportSerializedDataVersion = 2;
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        this.children = this.propertyListeners.isEmpty() ? null : this.propertyListeners;
        stream.defaultWriteObject();
        Enumeration e = this.listeners.elements();
        while (e.hasMoreElements()) {
            VetoableChangeListener l = (VetoableChangeListener)e.nextElement();
            if (!(l instanceof Serializable)) continue;
            stream.writeObject(l);
        }
        stream.writeObject(null);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        VetoableChangeListener l;
        stream.defaultReadObject();
        Hashtable hashtable = this.propertyListeners = this.children == null ? new Hashtable() : this.children;
        while ((l = (VetoableChangeListener)stream.readObject()) != null) {
            this.addVetoableChangeListener(l);
        }
    }

    public VetoableChangeSupport(Object source) {
        this.finit$();
        this.source = source;
    }

    public void addVetoableChangeListener(VetoableChangeListener l) {
        this.listeners.addElement(l);
    }

    public void addVetoableChangeListener(String propertyName, VetoableChangeListener l) {
        Hashtable hashtable = this.propertyListeners;
        synchronized (hashtable) {
            try {
                Vector v = (Vector)this.propertyListeners.get(propertyName);
                try {
                    v.addElement(l);
                }
                catch (NullPointerException e) {
                    v = new Vector();
                    v.addElement(l);
                    this.propertyListeners.put(propertyName, v);
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener l) {
        this.listeners.removeElement(l);
    }

    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener l) {
        Hashtable hashtable = this.propertyListeners;
        synchronized (hashtable) {
            try {
                Vector v = (Vector)this.propertyListeners.get(propertyName);
                try {
                    v.removeElement(l);
                    if (v.size() == 0) {
                        this.propertyListeners.remove(propertyName);
                    }
                }
                catch (NullPointerException e) {
                }
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                throw throwable;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void fireVetoableChange(PropertyChangeEvent proposedChange) throws PropertyVetoException {
        int currentListener;
        try {
            for (currentListener = 0; currentListener < this.listeners.size(); ++currentListener) {
                ((VetoableChangeListener)this.listeners.elementAt(currentListener)).vetoableChange(proposedChange);
            }
        }
        catch (PropertyVetoException e) {
            void moreListeners;
            PropertyChangeEvent reversion = new PropertyChangeEvent(proposedChange.getSource(), proposedChange.getPropertyName(), proposedChange.getNewValue(), proposedChange.getOldValue());
            for (int sendAgain = 0; sendAgain < currentListener; ++sendAgain) {
                try {
                    ((VetoableChangeListener)this.listeners.elementAt(sendAgain)).vetoableChange(reversion);
                    continue;
                }
                catch (PropertyVetoException e2) {
                    // empty catch block
                }
            }
            throw moreListeners;
        }
        Vector moreListeners = (Vector)this.propertyListeners.get(proposedChange.getPropertyName());
        if (moreListeners != null) {
            try {
                for (currentListener = 0; currentListener < moreListeners.size(); ++currentListener) {
                    ((VetoableChangeListener)moreListeners.elementAt(currentListener)).vetoableChange(proposedChange);
                }
            }
            catch (PropertyVetoException e) {
                int sendAgain;
                PropertyChangeEvent reversion = new PropertyChangeEvent(proposedChange.getSource(), proposedChange.getPropertyName(), proposedChange.getNewValue(), proposedChange.getOldValue());
                for (sendAgain = 0; sendAgain < this.listeners.size(); ++sendAgain) {
                    try {
                        ((VetoableChangeListener)this.listeners.elementAt(currentListener)).vetoableChange(proposedChange);
                        continue;
                    }
                    catch (PropertyVetoException e2) {
                        // empty catch block
                    }
                }
                for (sendAgain = 0; sendAgain < currentListener; ++sendAgain) {
                    try {
                        ((VetoableChangeListener)moreListeners.elementAt(sendAgain)).vetoableChange(reversion);
                        continue;
                    }
                    catch (PropertyVetoException e2) {
                        // empty catch block
                    }
                }
                throw e;
            }
        }
    }

    public void fireVetoableChange(String propertyName, Object oldVal, Object newVal) throws PropertyVetoException {
        this.fireVetoableChange(new PropertyChangeEvent(this.source, propertyName, oldVal, newVal));
    }

    public void fireVetoableChange(String propertyName, boolean oldVal, boolean newVal) throws PropertyVetoException {
        this.fireVetoableChange(new PropertyChangeEvent(this.source, propertyName, new Boolean(oldVal), new Boolean(newVal)));
    }

    public void fireVetoableChange(String propertyName, int oldVal, int newVal) throws PropertyVetoException {
        this.fireVetoableChange(new PropertyChangeEvent(this.source, propertyName, new Integer(oldVal), new Integer(newVal)));
    }

    public boolean hasListeners(String propertyName) {
        return this.listeners.size() > 0 || this.propertyListeners.get(propertyName) != null;
    }
}

