/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import java.beans.FeatureDescriptor;
import java.beans.IntrospectionException;
import java.lang.reflect.Method;

public class PropertyDescriptor
extends FeatureDescriptor {
    Class propertyType;
    Method getMethod;
    Method setMethod;
    Class propertyEditorClass;
    boolean bound;
    boolean constrained;

    PropertyDescriptor(String name) {
        this.setName(name);
    }

    public PropertyDescriptor(String name, Class beanClass) throws IntrospectionException {
        String capitalized;
        this.setName(name);
        try {
            capitalized = Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        catch (StringIndexOutOfBoundsException e) {
            capitalized = "";
        }
        this.findMethods(beanClass, "is" + capitalized, "get" + capitalized, "set" + capitalized);
    }

    public PropertyDescriptor(String name, Class beanClass, String getMethodName, String setMethodName) throws IntrospectionException {
        this.setName(name);
        this.findMethods(beanClass, getMethodName, null, setMethodName);
    }

    public PropertyDescriptor(String name, Method getMethod, Method setMethod) throws IntrospectionException {
        this.setName(name);
        if (getMethod != null && getMethod.getParameterTypes().length > 0) {
            throw new IntrospectionException("get method has parameters");
        }
        if (setMethod != null && setMethod.getParameterTypes().length != 1) {
            throw new IntrospectionException("set method does not have exactly one parameter");
        }
        if (getMethod != null && setMethod != null) {
            if (!getMethod.getReturnType().equals(setMethod.getParameterTypes()[0])) {
                throw new IntrospectionException("set and get methods do not share the same type");
            }
            if (!getMethod.getDeclaringClass().isAssignableFrom(setMethod.getDeclaringClass()) && !setMethod.getDeclaringClass().isAssignableFrom(getMethod.getDeclaringClass())) {
                throw new IntrospectionException("set and get methods are not in the same class.");
            }
        }
        this.getMethod = getMethod;
        this.setMethod = setMethod;
        this.propertyType = getMethod != null ? getMethod.getReturnType() : setMethod.getParameterTypes()[0];
    }

    public Class getPropertyType() {
        return this.propertyType;
    }

    public Method getReadMethod() {
        return this.getMethod;
    }

    public Method getWriteMethod() {
        return this.setMethod;
    }

    public boolean isBound() {
        return this.bound;
    }

    public void setBound(boolean bound) {
        this.bound = bound;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public void setConstrained(boolean constrained) {
        this.constrained = constrained;
    }

    public Class getPropertyEditorClass() {
        return this.propertyEditorClass;
    }

    public void setPropertyEditorClass(Class propertyEditorClass) {
        this.propertyEditorClass = propertyEditorClass;
    }

    private void findMethods(Class beanClass, String getMethodName1, String getMethodName2, String setMethodName) throws IntrospectionException {
        block21: {
            try {
                if (getMethodName1 != null) {
                    try {
                        this.getMethod = beanClass.getMethod(getMethodName1, new Class[0]);
                    }
                    catch (NoSuchMethodException E) {
                        // empty catch block
                    }
                    if (getMethodName2 != null) {
                        Method getMethod2;
                        if (this.getMethod != null && !this.getMethod.getReturnType().equals(Boolean.TYPE)) {
                            this.getMethod = null;
                        }
                        try {
                            getMethod2 = beanClass.getMethod(getMethodName2, new Class[0]);
                        }
                        catch (NoSuchMethodException E) {
                            getMethod2 = null;
                        }
                        if (getMethod2 != null) {
                            if (this.getMethod != null) {
                                if (!this.getMethod.getReturnType().equals(getMethod2.getReturnType())) {
                                    throw new IntrospectionException("Both " + getMethodName1 + " and " + getMethodName2 + " exist, and have contradictory return types.");
                                }
                            } else {
                                this.getMethod = getMethod2;
                            }
                        }
                    }
                }
                if (this.getMethod != null) {
                    this.propertyType = this.getMethod.getReturnType();
                    if (setMethodName == null) break block21;
                    Class[] setArgs = new Class[]{this.propertyType};
                    try {
                        this.setMethod = beanClass.getMethod(setMethodName, setArgs);
                        if (!this.setMethod.getReturnType().equals(Void.TYPE)) {
                            throw new IntrospectionException(setMethodName + " has non-void return type");
                        }
                        break block21;
                    }
                    catch (NoSuchMethodException E) {}
                    break block21;
                }
                if (setMethodName != null) {
                    Method[] m = beanClass.getMethods();
                    for (int i = 0; i < m.length; ++i) {
                        Method current = m[i];
                        if (!current.getName().equals(setMethodName) || current.getParameterTypes().length != 1 || !current.getReturnType().equals(Void.TYPE)) continue;
                        if (this.setMethod != null) {
                            throw new IntrospectionException("Multiple, different set methods found that fit the bill!");
                        }
                        this.setMethod = current;
                        this.propertyType = current.getParameterTypes()[0];
                    }
                    if (this.setMethod == null) {
                        throw new IntrospectionException("Cannot find get or set methods.");
                    }
                    break block21;
                }
                throw new IntrospectionException("Cannot find get or set methods.");
            }
            catch (SecurityException E) {
                throw new IntrospectionException("SecurityException thrown on attempt to access methods.");
            }
        }
    }
}

