#include "kjprefs.h"
#include "kjloader.h"

#include <qcombobox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <klocale.h>
#include <kglobal.h>
#include <kstddirs.h>
#include <kfiledialog.h>
#include <netaccess.h>
#include <kprocess.h>
#include <knotifyclient.h>
#include <qpixmap.h>
#include "parser.h"
#include "kjloader.h"

KJPrefs::KJPrefs(QWidget* parent, char* name)
	: CModule(parent, name)
{
	QVBoxLayout *vbox = new QVBoxLayout( this ); 
    vbox->setSpacing( 6 );
    vbox->setMargin( 11 );

	QHBoxLayout *hbox = new QHBoxLayout; 
	hbox->setSpacing( 6 );
	hbox->setMargin( 0 );

	mSkins = new QComboBox(false, this);
	hbox->addWidget(mSkins);

//	mAdd = new QPushButton(this);
//	mAdd->setText(i18n("&Install More..."));
//	mAdd->setSizePolicy(QSizePolicy((QSizePolicy::SizeType)0,(QSizePolicy::SizeType)0,
//	                    mAdd->sizePolicy().hasHeightForWidth()));
//	hbox->addWidget(mAdd);
	vbox->addLayout(hbox);

	QGridLayout *grid = new QGridLayout;
	grid->setSpacing(6);
	grid->setMargin(0);

	mPreview = new QLabel(this);
	mPreview->setScaledContents(true);

    grid->addWidget(mPreview, 0, 1 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    grid->addItem( spacer, 0, 0 );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum );
    grid->addItem( spacer_2, 0, 2 );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    grid->addItem( spacer_3, 1, 1 );
    vbox->addLayout( grid );

	connect(mSkins, SIGNAL(activated(const QString&)), SLOT(showPreview(const QString&)));
//	connect(mAdd, SIGNAL(clicked()), SLOT(add()));
}

void KJPrefs::add()
{
#if 0
		// expiramental code
	KURL file=KFileDialog::getOpenURL(0, "*.tar.gz *.tar.bz2 *.zip");
	QString target;
	if (KIO::NetAccess::download(file, target))
	{
		KNotifyClient::event("warning", i18n("File %s couldn't be opened").
		                                arg(file.path()));
		return;
	}

	QString uncompressDir=locateLocal("data", "noatun/skins/"+
	                                          target.left(target.findRev('.'))+'/');
	KProcess uncompressor;
	if (target.right(4)==".zip")

	
		
		
	KIO::NetAccess::removeTempFile(target);
#endif
	
}

void KJPrefs::reopen()
{
	QStringList skins=KGlobal::dirs()->findAllResources("data", "noatun/skins/*/*.rc");
	
	KGlobal::config()->setGroup("KJofol-Skins"); 
	QString loaded=KGlobal::config()->readEntry("SkinResource", "kjofol");

	mSkins->clear();
	
	int index;
	for (QStringList::Iterator i=skins.begin(); i!=skins.end(); ++i)
	{
		(*i)=(*i).left((*i).findRev('/'));
		(*i)=(*i).mid((*i).findRev('/')+1);
		mSkins->insertItem(*i);
		if ((*i) == loaded)
			index=mSkins->count()-1;
	}
	mSkins->setCurrentItem(index);
	showPreview(mSkins->currentText());
}

void KJPrefs::save()
{
	KConfig *config=KGlobal::config();
	config->setGroup("KJofol-Skins");
	config->writeEntry("SkinResource", mSkins->currentText());
	config->sync();
	KJLoader *l=static_cast<KJLoader*>(napp->libraryLoader()->pluginByName("KJLoader"));
	if (l)
		l->loadSkin(getFullPath(mSkins->currentText()));
}

void KJPrefs::showPreview(const QString &skin_)
{
	QString skin=getFullPath(skin_);
	Parser p;
	p.open(skin);
	QImage image=p.image(p["BackgroundImage"][1]);
	if (!image.isNull())
	{
		mPixmap.convertFromImage(image);
		mPixmap.setMask(KJWidget::getMask(image));
	}
	else
		mPixmap=QPixmap();
	mPreview->setPixmap(mPixmap);
}


QString getFullPath(const QString &file)
{
	return locate("data", "noatun/skins/"+file+'/'+file+".rc");
}



#include "kjprefs.moc"
