// $Id: tool.cpp,v 1.14 2000/11/25 10:06:51 mlaurent Exp $

#include <kdebug.h>
#include <stdio.h>
#include <assert.h>
#include <qpixmap.h>
#include "tool.h"

Tool::Tool()
{
  active= false;
  canvas= 0;
  props= 0;
}

Tool::Tool(const QString & toolname)
  : name(toolname)
{
  active = false;
  canvas = 0;
  props = 0;
}


int Tool::getPages()
{
  return props;
}

void Tool::activate(Canvas *c)
{
  assert(!c->isActive());
  canvas= c;
  active= true;
  activating();
}

void Tool::deactivate()
{
  assert(active);
  deactivating();
  active= false;
  canvas= 0;
}

bool Tool::isActive()
{
  return active;
}

void Tool::setLeftPen(QPen &p)
{
  kdDebug(4400) << "Tool::setLeftPen()" << endl;
  leftpen= p;
}

void Tool::setLeftBrush(QBrush &b)
{
  kdDebug(4400) << "Tool::setLeftBrush()" << endl;
  leftbrush= b;
}

void Tool::setRightPen(QPen &p)
{
  kdDebug(4400) << "Tool::setRightPen()" << endl;
  rightpen= p;
}

void Tool::setRightBrush(QBrush &b)
{
  kdDebug(4400) << "Tool::setRightBrush()" << endl;
  rightbrush= b;
}

#include "tool.moc"
