/* knotesdcop.h
**
** Copyright (C) 2000 by Adriaan de Groot
**
** This file defines a DCOP interface for KNotes.
*/

/*
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
** GNU General Public License for more details.
**
** You should have received a copy of the GNU General Public License
** along with this program in a file called COPYING; if not, write to
** the Free Software Foundation, Inc., 675 Mass Ave, Cambridge,
** MA 02139, USA.
*/

#ifndef KNOTESDCOP_H
#define KNOTESDCOP_H

#include <dcopobject.h>

class KNotesDCOP : virtual public DCOPObject
{
	K_DCOP
k_dcop:
	/**
	* Show the n-th note in the list, as if it had been
	* selected from the "notes" menu.
	*/
	virtual ASYNC showNote(const QString& name) = 0;

	/**
	* Re-read the directory(ies) containing KNotes
	* and add any new notes to the notes managed by
	* KNotes.
	*/
	virtual ASYNC rereadNotesDir() = 0;

	/**
	* Add a note -- with complete text, title, and pilot id --
	* to the list of notes managed by KNotes.
	*/
	virtual ASYNC addNote(QString title, 
		QString body, 
		unsigned long pilotid) = 0;
} ;


// $Log: knotesdcop.h,v $
// Revision 1.3  2000/12/26 17:53:35  pilone
// 	Fixed dcop method declaration to match implementation declaration.
//
// Revision 1.2  2000/12/19 23:42:24  wynnw
// Added support for two dcop calls, rereadNoteDirectory and addNote
// The addNote doesn't work yet- there's some problem with the DCOP
// when I've tested from the command line.
//
// Cleaned up the internal code to use new private functions that handle
// the different cases.
//
// Revision 1.1  2000/12/19 18:00:49  adridg
// Added DCOP calls to manipulate notes (intended for KPilot)
//
#endif
